let tblpropietario;

document.addEventListener("DOMContentLoaded", function () {
       const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de Socio',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },
       {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
]
const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
"<'row'<'col-sm-12'tr>>" +
"<'row'<'col-sm-5'i><'col-sm-6'p>>";
    tblpropietario = $('#tblpropietario').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/archivados.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id'},
            { 'data': 'Nombres'},
            { 'data': 'Celular'},
            { 'data': 'utilidad'},
            { 'data': 'Direccion', 'width':'15%'},
        //    { 'data': 'ApMaterno'},
          //  { 'data': 'fecha_encargado'},
            { 'data': 'fechaInicio'},
            {'data' : 'img'},
            { "data": "opciones" },
           //    {"data":'Estado'},
         
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        bDestroy: true,
        iDisplayLength: 25,
        order:
            [0, "desc"]
        
    });//Fin de la tabla 
    var date = new Date();
    const [month, day, year] = [
      (date.getMonth()<9)?('0'+(date.getMonth()+1)):date.getMonth()+1,
      (date.getDate()<10)?('0'+date.getDate()):date.getDate(),
      date.getFullYear(),
    ];
     $('#tblpropietario').on('draw.dt', function () {
            $("tbody").find('tr').each(function () {
                var fecha = $(this).find('td:eq(4)').text();
                if (fecha===(''+year+"-"+month+"-"+day)) {
                    $(this).addClass('');
                     $('#tblpropietario')
                }else if (fecha<(''+year+"-"+month+"-"+day)){
                    $(this).addClass('');
                }
            });
    });
      
});

function frmPropietarioVivienda() {
    document.getElementById("title").textContent = "Nuevo Cliente";
    document.getElementById("btnAccion").textContent = "Registrar";
    //document.getElementById("claves").classList.remove("d-none");
    //document.getElementById("btnAccion").setAttribute('onclick','registrarEmpresa(event);')
   document.getElementById("frmPropietarioVivienda").reset();
   document.getElementById("id").value = "";
    $('#nuevo_propietariovivienda').modal('show');
}

function registrarPropietario(e) {
    e.preventDefault();
    const DNI = document.getElementById("DNI");
    const Nombres = document.getElementById("Nombres");
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (DNI.value == "" || Nombres.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/archivados.php?op=registrar";
        const frm = document.getElementById("frmPropietarioVivienda");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                
                $("#nuevo_propietariovivienda").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                
            }
        }
    }
}

function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar Cliente";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    const url = "../control/archivados.php?op=editar&id="+id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            
            document.getElementById("id").value = id;
            document.getElementById("Nombres").value=res.Nombres;
            document.getElementById("ApPaterno").value=res.ApPaterno;
            document.getElementById("ApMaterno").value=res.ApMaterno;
            document.getElementById("DNI").value=res.DNI;
            document.getElementById("EstadoCivil").value=res.EstadoCivil;
            document.getElementById("Genero").value=res.Genero;
            document.getElementById('Celular').value=res.Celular;
            document.getElementById('identificador').value=res.identificador;
            document.getElementById("Direccion").value=res.Direccion;
            document.getElementById('categoria').value=res.categoria;
            document.getElementById('montoservicio').value=res.montoservicio;
            document.getElementById('fechaInicio').value=res.fechaInicio;
            document.getElementById('adelanto_encargado').value=res.adelanto_encargado;
            document.getElementById('entrega_material').value=res.entrega_material;
            document.getElementById('fecha_encargado').value=res.fecha_encargado;
            document.getElementById('utilidad').value=res.utilidad;
              $('#nuevo_propietariovivienda').modal('show');
        }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El Propietario se eliminara de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/archivados.php?op=eliminar&id="+id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblpropietario.ajax.reload();
                   // tblpropietario2.ajax.reload();
                }
            }
            
        }
    })
}
function btnMostrar(imagen) {
    Swal.fire({
      title: '',
      iconHtml: "<img src='"+imagen+"' height='500px'>",
      customClass: {
        icon: 'no-border'
      }
    })
}

function loadImageAndConvertToDataURL(imagePath) {
    return new Promise(function (resolve, reject) {
        const img = new Image();
        img.onload = function () {
            const canvas = document.createElement("canvas");
            canvas.width = img.width;
            canvas.height = img.height;
            const ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0, img.width, img.height);
            const dataURL = canvas.toDataURL("image/jpeg"); // Puedes especificar el formato de imagen deseado
            resolve(dataURL);
        };
        img.onerror = function (error) {
            reject(error);
        };
        img.src = imagePath;
    });
}
async function btnImprimir(id) {
    // Obtén los datos del cliente de la misma manera que en btnEditar
    const url = "../control/archivados.php?op=editari&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();

    http.onreadystatechange = async function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            try {
                // Cargar la imagen y obtener el dataURL
                const src = await loadImageAndConvertToDataURL(res.imagen_url);

                // Crear la definición del PDF
                const pdfDefinition = {
                    content: [
                        { text: "Detalles del Servicio", style: "header" },
                        { qr: res.id, fit: 95,alignment: 'right' ,absolutePosition: { x: 100, y: 100 }},
                        
                        { text: "Datos del Colaborador", style: "subheader" },
                        {
                            style: "tableExample",
                            table: {
                                body: [
                                    ["Nombres", res.identificador || ''],
                                    ["Telefono", res.monto || ''],
                                ],
                            },
                        },
                        { text: "Detalle del pedido", style: "subheader" },
                        {
                            style: "tableExample",
                            table: {
                                body: [
                                 //   ["Adelanto", res.name || ''],
                                   /// ["A cuenta", res.ApPaterno || ''],
                                //    ["Total", res.montoservicio || ''],
                                    ["Detalle", res.Direccion || ''],
                                    ["Adelanto Encargado", res.adelanto_encargado || ''],
                                    ["Entrega Material", res.entrega_material || ''],
                                    ["Fecha de entrega", res.fecha_encargado || ''],
                                ],
                            },
                        },
                        { text: "Imagen:", style: "subsubheader" },
                        {
                            image: src,
                            width: 300,
                        },
                    ],
                    styles: {
                        header: {
                            fontSize: 18,
                            bold: true,
                            alignment: "center",
                            margin: [0, 0, 0, 20], // Margen inferior
                        },
                        subheader: {
                            fontSize: 14,
                            bold: true,
                            margin: [0, 15, 0, 5], // Margen inferior
                        },
                        tableExample: {
                            margin: [0, 5, 0, 15], // Margen inferior
                        },
                        subsubheader: {
                            fontSize: 12,
                            bold: true,
                            margin: [0, 15, 0, 5], // Margen inferior
                        },
                    },
                };

                // Genera el PDF y lo muestra en una nueva ventana
                pdfMake.createPdf(pdfDefinition).open();
            } catch (error) {
                console.error("Error al cargar la imagen:", error);
            }
        }
    };
}

function btnQR(id) {

    // Obtén los datos del cliente de la misma manera que en btnEditar
    const url = "../control/archivados.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            const pdfDefinition = {
                pageSize: {
                    width: 1.57 * 72, // Ancho en puntos
                    height: 1.57 * 72, // Alto en puntos
                },
                 pageMargins: [ 0, 2, 0, 2 ],
                content: [
                    {text: "", style: "header"},
                    { qr: res.id, fit: 110,alignment: 'center' },
                    {text: " ", style: "header"},
                ],
                styles: {
                    header: {
                        fontSize: 1,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 0], // Margen inferior
                    },
                    headerb: {
                        fontSize: 20,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 10], // Margen inferior
                    },
                    headerc: {
                        fontSize: 10,
                        bold: false,
                        alignment: "center",
                        margin: [0, 0, 0, 0], // Margen inferior
                    },
                    subheader: {
                        fontSize:14,
                        bold: true,
                        margin: [0, 10, 0, 3], // Margen inferior
                    },
                    subsubheader: {
                        fontSize: 12,
                        bold: false,
                        margin: [0,2, 0, 3], // Margen inferior
                    },
                },
            };
            // Genera el PDF y lo muestra en una nueva ventana
            pdfMake.createPdf(pdfDefinition).open();
        }
    };
}


function alertas(mensaje, icono) {
    Swal.fire({
       // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}


