let tblpropietario;

document.addEventListener("DOMContentLoaded", function () {
       const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },
       {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-orange"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
]
const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
"<'row'<'col-sm-12'tr>>" +
"<'row'<'col-sm-5'i><'col-sm-6'p>>";
    tblpropietario = $('#tblpropietario').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/certificados.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id','width':'10px'},
            { 'data': 'Nombres'},
            { 'data': 'DNI'},
            { 'data': 'Direccion'},
           /// { 'data': 'concepto'},
            {'data' : 'img'},
            { "data": "opciones" }
           
         
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        bDestroy: true,
        iDisplayLength: 10,
        order: 
            [0, "desc"]
        
    });//Fin de la tabla 
    var date = new Date();
    const [month, day, year] = [
      (date.getMonth()<9)?('0'+(date.getMonth()+1)):date.getMonth()+1,
      (date.getDate()<10)?('0'+date.getDate()):date.getDate(),
      date.getFullYear(),
    ];
     $('#tblpropietario').on('draw.dt', function () {
            $("tbody").find('tr').each(function () {
                var fecha = $(this).find('td:eq(4)').text();
                if (fecha===(''+year+"-"+month+"-"+day)) {
                    $(this).addClass('');
                     $('#tblpropietario')
                }else if (fecha<(''+year+"-"+month+"-"+day)){
                    $(this).addClass('');
                }
            });
    });
      
});

function frmPropietarioVivienda() {
    document.getElementById("title").textContent = "Nuevo Certificado";
    document.getElementById("btnAccion").textContent = "Registrar";
    //document.getElementById("claves").classList.remove("d-none");
    //document.getElementById("btnAccion").setAttribute('onclick','registrarEmpresa(event);')
   document.getElementById("frmPropietarioVivienda").reset();
   document.getElementById("id").value = "";
    $('#nuevo_propietariovivienda').modal('show');
}


function registrarPropietario(e) {
    e.preventDefault();
    const Direccion = document.getElementById("Direccion");
    const Nombres = document.getElementById("Nombres");
    
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (Direccion.value == "" || Nombres.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/certificados.php?op=registrar";
        const frm = document.getElementById("frmPropietarioVivienda");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                
                $("#nuevo_propietariovivienda").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                
            }
        }
    }
}
function registrarPropietarioU(e) {
    e.preventDefault();
    const DNI = document.getElementById("DNI_u");
    const Nombres = document.getElementById("Nombres_u");
    
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (DNI.value == "" || Nombres.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/certificados.php?op=registrar";
        const frm = document.getElementById("frmPropietarioVivienda_u");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                
                $("#utilidad_propietariovivienda").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                
            }
        }
    }
}
function btnUtilidad(id) {
    document.getElementById("title_u").innerHTML = "Utilidad de Pedido";
    document.getElementById("btnAccion_u").innerHTML = "Subir Utilidad";
    const url = "../control/certificados.php?op=editar&id="+id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            
            document.getElementById("id_u").value = id;
            document.getElementById("Nombres_u").value=res.Nombres;
            document.getElementById("ApPaterno_u").value=res.ApPaterno;
            document.getElementById("ApMaterno_u").value=res.ApMaterno;
            document.getElementById("DNI_u").value=res.DNI;
            document.getElementById("EstadoCivil_u").value=res.EstadoCivil;
            document.getElementById("Genero_u").value=res.Genero;
            document.getElementById('Celular_u').value=res.Celular;
            document.getElementById('identificador_u').value=res.identificador;
            document.getElementById("Direccion_u").value=res.Direccion;
            document.getElementById('categoria_u').value=res.categoria;
            document.getElementById('montoservicio_u').value=res.montoservicio;
            document.getElementById('fechaInicio_u').value=res.fechaInicio;
            document.getElementById('adelanto_encargado_u').value=res.adelanto_encargado;
            document.getElementById('entrega_material_u').value=res.entrega_material;
            document.getElementById('fecha_encargado_u').value=res.fecha_encargado;
            //document.getElementById('utilidad_u').value=res.utilidad;
            
              $('#utilidad_propietariovivienda').modal('show');
        }
    }
}

function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar Cliente";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    const url = "../control/certificados.php?op=editar&id="+id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            
            document.getElementById("id").value = id;
            document.getElementById("Nombres").value=res.Nombres;
            //document.getElementById("ApPaterno").value=res.ApPaterno;
            //document.getElementById("ApMaterno").value=res.ApMaterno;
            document.getElementById("DNI").value=res.DNI;
            document.getElementById("EstadoCivil").value=res.EstadoCivil;
            document.getElementById("Genero").value=res.Genero;
            document.getElementById('Celular').value=res.Celular;
            document.getElementById('identificador').value=res.identificador;
            document.getElementById("Direccion").value=res.Direccion;
            document.getElementById('categoria').value=res.categoria;
            document.getElementById('montoservicio').value=res.montoservicio;
            document.getElementById('fechaInicio').value=res.fechaInicio;
            document.getElementById('adelanto_encargado').value=res.adelanto_encargado;
            document.getElementById('entrega_material').value=res.entrega_material;
            document.getElementById('fecha_encargado').value=res.fecha_encargado;
            
              $('#nuevo_propietariovivienda').modal('show');
        }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El Propietario se eliminara de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/certificados.php?op=eliminar&id="+id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblpropietario.ajax.reload();
                   // tblpropietario2.ajax.reload();
                }
            }
            
        }
    })
}
function btnMostrar(imagen) {
    Swal.fire({
      title: '',
      iconHtml: "<img src='"+imagen+"' height='500px'>",
      customClass: {
        icon: 'no-border'
      }
    })
}
function btnEnviar1(id){
        const estadoCivilMapping = {
    1: "Mercaderes",
    2: "Secundaria",
    3: "Tienda 3",
    // Agrega más mapeos según sea necesario
    };
    const Tipotrabajo= {
    1: "Contrato",
    2: "Compostura",
    3: "Presupuesto",
    // Agrega más mapeos según sea necesario
    };

    // Obtén los datos del cliente de la misma manera que en btnEditar
    const url = "../control/certificados.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            const estadoCivilText = estadoCivilMapping[res.EstadoCivil];
            const tipotrabaj=Tipotrabajo[res.Genero];
            // Crea un documento PDF utilizando pdfmake
                       // Crea un documento PDF utilizando pdfmake
            const pdfDefinition = {
                pageSize: {
                    width: 3.57 * 72, // Ancho en puntos
                    height: 8.53 * 72, // Alto en puntos
                },
                 pageMargins: [ 20, 40, 20, 40 ],
                content: [
                    {text: "Joyeria", style: "header"},
                    {text: "EL KERO", style: "headerb"},
                    { text: "Factura de Cliente", style: "headerc", fontFeatures: ['smcp'] },
                    { text: estadoCivilText, style: "headerc" , fontFeatures: ['smcp']},
                    { text: "Datos del Cliente", style: "subheader", fontFeatures: ['smcp'] },
                    { text: "Nombre: "+ res.Nombres, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "DNI: "+res.DNI, style: "subsubheader" , fontFeatures: ['smcp']},
                    { text: "Telefono: "+res.Celular, style: "subsubheader", fontFeatures: ['smcp'] },
                    
                    { text: "Detalle del pedido", style: "subheader" , fontFeatures: ['smcp']},
                     
                    { text: res.Direccion|| '', style: "subsubheader", fontFeatures: ['smcp'] },
                   {alignment: 'center', text: "--------------------------------------------------", opacity: 0.1 },
                    {
                        columns: [
			            	{
			            		width: 150,
			            		text: "Tipo de trabajo: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text:tipotrabaj, style: "subsubheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    
                    {
                        columns: [
			            	{
			            		width: 150,
			            		text: "Fecha de entrega: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text:res.fechaInicio, style: "subsubheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    
                    {alignment: 'center', text: "--------------------------------------------------", opacity: 0.1},
                    {
                        columns: [
			            	{
			            		width: 180,
			            		text: "Adelanto: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.identificador, style: "subsubheader", fontFeatures: ['smcp'] 
			            	}
			            ]
                    },
                    {columns: [
			            	{
			            		width: 180,
			            		text: "A cuenta: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.ApPaterno, style: "subsubheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    {columns: [
			            	{
			            		width: 180,
			            		text: "Total: ", style: "subheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.montoservicio, style: "subheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    { qr: res.id, fit: 85,alignment: 'center' },
                    {text: " ", style: "header"},
                    {text: " ", style: "headerc"},
                   // {text: "Codigo : "+res.id, style: "headerc"},
                     {text: "Telefono: 954719184", style: "headerc"},
                     {text: "www.joyeriaelkero.pe ", style: "headerc"},
                     {text: "Oferta valida por 30 dias ", style: "headerc"},
                ],
                styles: {
                    header: {
                        fontSize: 10,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 2], // Margen inferior
                    },
                    headerb: {
                        fontSize: 14,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 10], // Margen inferior
                    },
                    headerc: {
                        fontSize: 5,
                        bold: false,
                        alignment: "center",
                        margin: [0, 0, 0, 0], // Margen inferior
                    },
                    subheader: {
                        fontSize:8,
                        bold: true,
                        margin: [0, 10, 0, 3], // Margen inferior
                    },
                    subsubheader: {
                        fontSize: 6,
                        bold: false,
                        margin: [0,2, 0, 3], // Margen inferior
                    },
                },
            };
            var PDFPrinter = require('pdfmake');
            const fonts = {
              Roboto: {
                normal: 'fonts/Roboto-Regular.ttf',
                bold: 'fonts/Roboto-Medium.ttf',
                italics: 'fonts/Roboto-Italic.ttf'
              }
            };
            const printer = new PDFPrinter(fonts);
            
            var pdf = printer.createPdfKitDocument(pdfDefinition);
            var base64Stream = pdf.pipe(Base64Stream.encode());
            pdf.end();

            // Fetch base64 encoded pdf
            var tempFileBase64 = '';
            base64Stream.on('data', function(buffer) {
                tempFileBase64 += buffer.toString();
            });
            
            base64Stream.on('end', function() {
                // Encode the PDF data as base64 URI
                var pdfBase64 = encodeURIComponent('data:application/pdf;base64,' + tempFileBase64);
            
                // Define the WhatsApp message
                var numeroDestino = '933011878'; // Reemplaza con el número de teléfono de destino
                var mensaje = 'Aquí tienes el PDF de tu pedido:';
                var enlaceWhatsApp = `https://api.whatsapp.com/send?phone=${numeroDestino}&text=${encodeURIComponent(mensaje            )}&data=${pdfBase64}`;

                // Abre la ventana de chat de WhatsApp con el PDF como enlace
                window.open(enlaceWhatsApp, '_blank');
            });

        }
    };
}

function loadImageAndConvertToDataURL(imagePath) {
    return new Promise(function (resolve, reject) {
        const img = new Image();
        img.onload = function () {
            const canvas = document.createElement("canvas");
            canvas.width = img.width;
            canvas.height = img.height;
            const ctx = canvas.getContext("2d");
            ctx.drawImage(img, 0, 0, img.width, img.height);
            const dataURL = canvas.toDataURL("image/jpeg"); // Puedes especificar el formato de imagen deseado
            resolve(dataURL);
        };
        img.onerror = function (error) {
            reject(error);
        };
        img.src = imagePath;
        img.src1 = imagePath;
        img.src2 = imagePath;
        img.src3 = imagePath;
        img.src4 = imagePath;
        img.src5 = imagePath;
    });
}

async function btnImprimir(id) {
    // Obtén los datos del cliente de la misma manera que en btnEditar
   // const termo = "../Assets/img/certificados/termo.jpeg";
    
    const url = "../control/certificados.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();

    http.onreadystatechange = async function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);

            try {
                // Cargar la imagen y obtener el dataURL
                const src = await loadImageAndConvertToDataURL(res.imagen_url);
                const src1 = await loadImageAndConvertToDataURL(res.adelanto_encargado);
                const src2 = await loadImageAndConvertToDataURL(res.entrega_material);
               const src3 = await loadImageAndConvertToDataURL(res.utilidad);
                const src4 = await loadImageAndConvertToDataURL(res.montoservicio);
                const src5 = await loadImageAndConvertToDataURL(res.ApMaterno);

                // Crear la definición del PDF
                const pdfDefinition = {
                    content: [
                        
                        //{ text: " ", style: "header" },
                        //{ text: " ", style: "header" },
                        //{ text: "CERTIFICADO DE CALIDAD", style: "header" },
                        //{ text: " ", style: "header" },
                        {image: src3,  fit: 195 ,absolutePosition: { x: 0, y: 0 }},
                        {image: src4, width: 80,alignment: 'center' },
                        { text: "E L   K E R O", style: "header3", color:'#D4AF37',fontFeatures: ['smcp'] },
                        { text: "J o y e r i a", style: "header4", color:'#D4AF37',fontFeatures: ['smcp'] },
                        { text: " ", style: "header1" },
                        { text: "CERTIFICADO DE CALIDAD", style: "header1" },
                   
                        { text: " ", style: "header1" },
                        { text: "Joyería El Kero, arte en metales finos, certifica que :", style: "header1" },
                        //{ text: " ", style: "header1" },
                        { text: " "+ res.Direccion, style: "header1", fontFeatures: ['smcp'] },
                         { text: " ", style: "header1" },
                        { text: "Esta elaborado con componentes que están dentro de los más altos estándares de calidad establecidos por normas internacionales de fabricación de joyas de alta gama.", style: "header2",absolutePosition: { x: 110, y: 240 } },
                        { text: " ", style: "header1" },
                        // { text: " "+ res.DNI, style: "header1", fontFeatures: ['smcp'] },
                       
                  
                        { text: "Descripción del producto:", style: "header4" },
                        { text: " ", style: "header1" },
                        { text: "Metal: "+res.Genero, style: "header4", fontFeatures: ['smcp'] },
                        { text: "Piedra : "+res.EstadoCivil, style: "header4", fontFeatures: ['smcp'] },
                        { text: "Peso: "+res.categoria, style: "header4", fontFeatures: ['smcp'] },
                        {image: src, width: 80, absolutePosition: { x: 370, y: 300 }},
                        
                         
                        
                       // { text: " "+ res.Direccion, style: "header1", fontFeatures: ['smcp'] },
                        
                        {image: src1, width: 90, absolutePosition: { x: 265, y: 380 }},
                        {image: src5, width: 130, absolutePosition: { x: 250, y: 430 }},
                        
                        
                        {image: src2, width: 100,absolutePosition: { x: 450, y: 660 }},
                       
                        //{ qr: res.id, width: 60 ,absolutePosition: { x: 100, y: 680 }},
                        // { qr: "https://joyeriaelkero.pe/intranet/control/certificados.php?op=editar&id="+res.id,  fit: 90, absolutePosition: { x: 195, y: 685 }},
                         { qr: "https://joyeriaelkero.pe/intranet/vista/edit.php?id="+res.id, fit: 80, absolutePosition: {x: 195, y: 685 }},
                       // https://joyeriaelkero.pe/intranet//control/certificados.php?op=editar&id=84
                        
                         { text: "Para el análisis de este producto se usaron instrumentos de las marcas más reconocidas en el mercado, obteniendo resultados de alta fiabilidad comercial.",  style: "header2",absolutePosition: { x: 197, y: 765 } },
                         { text: "Fecha de Emision: "+res.fechaInicio,   style: "header2",absolutePosition: { x: 200, y: 790 }},
                    ],
                    styles: {
                        header: {
                            fontSize: 18,
                            bold: true,
                            alignment: "center",
                            margin: [0, 30, 0, 0], // Margen inferior
                        },
                           header1: {
                            fontSize: 12,
                            bold: true,
                            alignment: "center",
                            margin: [0, 5, 0, 0], // Margen inferior
                        },
                           header2: {
                            fontSize: 10,
                            //bold: true,
                            alignment: "center",
                            margin: [0, 5, 0, 5], // Margen inferior
                        },
                            header3: {
                            fontSize: 29,
                            bold: true,
                            alignment: "center",
                            margin: [0, 0, 0, 0], // Margen inferior
                        },
                             header4: {
                            fontSize: 10,
                            bold: true,
                            alignment: "center",
                            margin: [0, 2, 0, 0], // Margen inferior
                        },
                        subheader: {
                            fontSize: 14,
                            bold: true,
                            margin: [0, 15, 0, 5], // Margen inferior
                        },
                        tableExample: {
                            margin: [0, 5, 0, 15], // Margen inferior
                        },
                        subsubheader: {
                            fontSize: 12,
                            bold: true,
                            margin: [0, 15, 0, 5], // Margen inferior
                        },
                    },
                };

                // Genera el PDF y lo muestra en una nueva ventana
                pdfMake.createPdf(pdfDefinition).open();
            } catch (error) {
                console.error("Error al cargar la imagen:", error);
            }
        }
    };
}

function alertas(mensaje, icono) {
    Swal.fire({
       // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}


