let tblControl;
document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";

        tblControl = $('#tblControl').DataTable({
            responsive: true,
            processing: true,
            serverSide: false,
            ajax: {
                url: "../control/controlC.php?op=listar",
                dataSrc: ''
            },
            columns: [
                { 'data': 'id' },
                { 'data': 'placa' },
                { 'data': 'conductor' },
                { 'data': 'hora_salida' },
                { 'data': 'numvuelta' },
                { "data": "editar" }
            ],
            language: {
                "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
            },
            dom,
            buttons,
            resonsieve: true,
            bDestroy: true,
            iDisplayLength: 10,
            order: [
                [0, "desc"]
            ]
        });
 $("#placa").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/vehiculoC.php?op=buscar2",
                dataType: "json",
                type:'get',
                data: {
                    veh: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('placa').value=ui.item.placa; // display the selected text
            document.getElementById('idveh').value=ui.item.id; // save selected id to input
    
        },
    });

 });

function frmControl() {
    document.getElementById("title").textContent = "Nueva Salida";
    document.getElementById("btnAccion").textContent = "Registrar";
    document.getElementById("formulariocontrol").reset();
    document.getElementById("id").value = ""; 
       
    $('#myModal').modal('show');
}


function registrarcontrol(e) {
    e.preventDefault();
    const placa = document.getElementById("placa").value;
   if (placa == '' ) {
        alertas('Todo los campos son requeridos', 'warning');
        return false;
    } else {
        const url = '../control/controlC.php?op=registrar';
        const frm = document.getElementById("formulariocontrol");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                frm.reset();
                $('#myModal').modal('hide');
                tblControl.ajax.reload();
            }
        }
    }
}

function btnEditar(id) {
    document.getElementById("title").textContent = "Actualizar Hora de Salida";
    document.getElementById("btnAccion").textContent = "Modificar";
    const url = "../control/controlC.php?op=editar&id="+ id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            console.log(res);
            document.getElementById("id").value = id;
            document.getElementById("idveh").value=res.id_vehiculo;
            document.getElementById("placa").value=res.placa;
            document.getElementById("conductor").value=res.conductor;
            document.getElementById("horasalida").value=res.hora_salida;
            $('#myModal').modal('show');
            tblControl.ajax.reload();
            
        }
    }
}
function alertas(mensaje, icono) {
    Swal.fire({
        //position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}

