let tblpropietario;

document.addEventListener("DOMContentLoaded", function () {
       const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de Socio',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },
       {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
]
const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
"<'row'<'col-sm-12'tr>>" +
"<'row'<'col-sm-5'i><'col-sm-7'p>>";
    tblpropietario = $('#tblpropietario').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/cy-disponibilidadC.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'ubicacion'},
            { 'data': 'estado'},
            { 'data': 'cy_id_difunto'},
            { 'data': 'cy_id_tipo_recinto'},
            { "data": "editar" }
         
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla 
      
});

function frmPropietarioVivienda() {
    document.getElementById("title").textContent = "Nuevo Socio";
    document.getElementById("btnAccion").textContent = "Registrar";
    //document.getElementById("claves").classList.remove("d-none");
    //document.getElementById("btnAccion").setAttribute('onclick','registrarEmpresa(event);')
   document.getElementById("frmPropietarioVivienda").reset();
   document.getElementById("cy_id_recinto").value = "";
    $('#nuevo_propietariovivienda').modal('show');
}

function registrarPropietario(e) {
    e.preventDefault();
    const pabellon = document.getElementById("pabellon");
    const fila = document.getElementById("fila");
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (pabellon.value == "" || fila.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/cy-disponibilidadC.php?op=registrar";
        const frm = document.getElementById("frmPropietarioVivienda");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nuevo_propietariovivienda").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                
            }
        }
    }
}

function btnEditar(cy_id_recinto) {
    document.getElementById("title").innerHTML = "Actualizar Socio";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    const url = "../control/cy-disponibilidadC.php?op=editar&cy_id_recinto="+cy_id_recinto;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            console.log(res);
            document.getElementById("cy_id_recinto").value = cy_id_recinto;
            document.getElementById("pabellon").value=res.pabellon;
            document.getElementById("fila").value=res.fila;
            document.getElementById("columna").value=res.columna;
            document.getElementById("cy_id_estado").value=res.cy_id_estado;
            document.getElementById("cy_id_difunto").value=res.cy_id_difunto;
            document.getElementById("cy_id_tipo_recinto").value=res.cy_id_tipo_recinto;
            document.getElementById("dni_difunto").value=res.dni_difunto;
            $('#nuevo_propietariovivienda').modal('show');
        }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El Propietario se eliminara de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/propietarioC.php?op=eliminar&id="+id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblpropietario.ajax.reload();
                    tblpropietario2.ajax.reload();
                }
            }
            
        }
    })
}
function alertas(mensaje, icono) {
    Swal.fire({
       // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}


