let tblEmpresas;

document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";
    tblEmpresas = $('#tblEmpresas').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/empresaC.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_empresa' },
            { 'data': 'nombre' },
            { 'data': 'ruc' },
            { 'data': 'representante' },
            { 'data': 'direccion' },
            { 'data': 'num_contacto' },
            { "data": "editar" },
            { "data": "eliminar" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla 
    


});

function frmEmpresa() {
    document.getElementById("title").textContent = "Nuevo Empresa";
    document.getElementById("btnAccion").textContent = "Registrar";

    document.getElementById("frmEmpresa").reset();
    document.getElementById("id").value = "";
    $('#nuevo_empresa').modal('show');
}




function registrarEmpresa(e) {
    e.preventDefault();
    const ruc = document.getElementById("ruc");
    const nombre = document.getElementById("nombre");
    if (ruc.value == "" || nombre.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
        return false;
    } else {
            const url = "../control/empresaC.php?op=registrar";
            const frm = document.getElementById("frmEmpresa");
            const http = new XMLHttpRequest();
            http.open("POST", url, true);
            http.send(new FormData(frm));
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    $("#nuevo_empresa").modal("hide");
                    alertas(res.msg, res.icono);
                    tblEmpresas.ajax.reload();


                }
            }
        

    }
}


function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "la empresa  no se eliminara de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/empresaC.php?op=eliminar&id=" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblEmpresas.ajax.reload();
                }
            }

        }
    })
}
function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar Empresa";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    //  document.getElementById("btnAccion").setAttribute('onclick','modificarEmpresa(event);')
    const url = "../control/empresaC.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("id").value = id;
            document.getElementById("nombre").value = res.nombre;
            document.getElementById("ruc").value = res.ruc;
            document.getElementById("telefono").value = res.num_contacto;
            document.getElementById("direccion").value = res.direccion;
            document.getElementById("representante").value = res.representante;
            //document.getElementById('autocomplete').value = res.datos;
           // document.getElementById('idusu').value = res.id_usuario;
            // document.getElementById("claves").classList.add("d-none");
            $('#nuevo_empresa').modal('show');
        }
    }
}
function modificarEmpresa(e) {
    e.preventDefault();
    const ruc = document.getElementById("ruc");
    const nombre = document.getElementById("nombre");
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (ruc.value == "" || nombre.value == "") {
        alertas('Todo los campos son obligatorios', 'warning');
    } else {
        const url = "../control/empresaC.php?op=registrar";
        const frm = document.getElementById("frmEmpresa");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                window.location.reload();
            }
        }
    }
}

function editardatosEmpresa() {
    document.getElementById('datosemp').classList.remove('d-none');

}

function alertas(mensaje, icono) {
    Swal.fire({
        //position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}

