//import firebase from "firebase/app";
// Import the functions you need from the SDKs you need
//import { initializeApp } from "https://www.gstatic.com/firebasejs/9.6.2/firebase-app.js";
//import { initializeApp } from "https://www.gstatic.com/firebasejs/9.23.0/firebase-app.js";
import { initializeApp } from "https://www.gstatic.com/firebasejs/9.23.0/firebase-app.js";

// TODO: Add SDKs for Firebase products that you want to use
// https://firebase.google.com/docs/web/setup#available-libraries
import {
  getFirestore,
  collection,
  getDocs,
  onSnapshot,
  addDoc,
  deleteDoc,
  doc,
  getDoc,
  updateDoc,
  query,
  where,
  GeoPoint
} from "https://www.gstatic.com/firebasejs/9.23.0/firebase-firestore.js";

// Your web app's Firebase configuration
const firebaseConfig = {
  apiKey: "AIzaSyB_6Vhy2zoMJvT-hKdaxagCrZq2gOyUCco",
  authDomain: "bipbip-a0b56.firebaseapp.com",
  databaseURL: "https://bipbip-a0b56-default-rtdb.firebaseio.com",
  projectId: "bipbip-a0b56",
  storageBucket: "bipbip-a0b56.appspot.com",
  messagingSenderId: "1099370222331",
  appId: "1:1099370222331:web:a840ad076c343b44e7d65e",
  measurementId: "G-QYV6JX2C0E"
};

// Initialize Firebase
export const app = initializeApp(firebaseConfig);

export const db = getFirestore();



/**
 * Save a New Task in Firestore
 * @param {string} title the title of the Task
 * @param {string} description the description of the Task
 */
// Función para calcular el geohash
function calculateGeohash(latitude, longitude, precision) {
  const base32 = "0123456789bcdefghjkmnpqrstuvwxyz"; // Caracteres permitidos en el geohash
  let geohash = "";

  let minLat = -90.0,
      maxLat = 90.0;
  let minLng = -180.0,
      maxLng = 180.0;

  let isEven = true;
  let bit = 0, ch = 0;

  while (geohash.length < precision) {
    let mid;

    if (isEven) {
      mid = (maxLng + minLng) / 2;
      if (longitude > mid) {
        ch |= (1 << bit);
        minLng = mid;
      } else {
        maxLng = mid;
      }
    } else {
      mid = (maxLat + minLat) / 2;
      if (latitude > mid) {
        ch |= (1 << bit);
        minLat = mid;
      } else {
        maxLat = mid;
      }
    }

    isEven = !isEven;

    if (bit < 4) {
      bit++;
    } else {
      geohash += base32[ch];
      bit = 0;
      ch = 0;
    }
  }

  return geohash;
}

export const saveTask = async(accepted,
canceled,
cost,
destinationAddress,
destinationLatitude,
destinationLongitude,
distance,

passengerId,
pickupAddress,
pickupLatitude,
pickupLongitude,
userPrice) => {

  const geohash = calculateGeohash(pickupLatitude, pickupLongitude, 9);

  // Crear el objeto de ubicación para Firestore
  const location = {
    geohash: geohash,
    geopoint: new GeoPoint(pickupLatitude, pickupLongitude),
  };
  var drivers =  await getDocs(collection(db, "drivers"));
drivers.docs.forEach((driver)=>{
    makeGetRequest(driver.data(),'https://fcm.googleapis.com/fcm/send',pickupAddress+" - "+destinationAddress);
    
  }
    );
  return await addDoc(collection(db, "trips"), {accepted,
canceled,
cost,
destinationAddress,
destinationLatitude,
destinationLongitude,
distance,
passengerId,
pickupAddress,
pickupLatitude,
pickupLongitude,
userPrice,
location});
    
    
};
const makeGetRequest=(driver,url,body2) =>{
    
    if(driver.notificationToken!= null){
        // Crea una nueva solicitud HTTP
        var xhr = new XMLHttpRequest();
        var serverKey =
                    'AAAA__eSUvs:APA91bFs-WO0J3lJwIsCCXK4UZVHy63o_tVfFiUaswCrVcVWK8mkavxGqxCsO0tJxby9Vof6h97R-n1cj8asGayUbmQvjWouKqg5BlQ13c2CfcxyH3SI1jzCYJIiOwQ5-pfyL_571S8v'; // Replace with your Firebase server key
        
          // Configura la solicitud
        xhr.open('POST', url, true);
  
        xhr.setRequestHeader("Content-Type", "application/json");
        xhr.setRequestHeader("Authorization", "key="+serverKey);
  
        // Se ejecuta cuando la solicitud cambia de estado
        xhr.onreadystatechange = function() {
            // Si la solicitud ha completado y el estado es "OK"
            if (xhr.readyState == 4) {
    
                if (xhr.status === 200) {
                  // Obtiene la respuesta del servidor
                  const response = xhr.responseText;
            
                  // Hacer algo con la respuesta aquí
                  console.log(driver.username);
                  console.log(response);
                }else
                {
                     console.log(`Error: ${xhr.status}`);
                }
            // request finished
            }
        };
        const body = JSON.stringify({
             to: driver.notificationToken,
             priority: 'high',
              notification: {
                title: "Nueva carrera",
                body: body2,
                sound: 'beepbeep.mp3',
                 
              }
        });
    
        // Envia la solicitud
        xhr.send(body);
    }else{
        //console.log("no tiene token")
    }
}
export const onGetTasks = (callback) =>
  onSnapshot(collection(db, "trips"), callback);

/**
 *
 * @param {string} id Task ID
 * @param {string} username task ID
 */
export const deleteTask = (id) => deleteDoc(doc(db, "trips", id));

export const getTask = (id) => getDoc(doc(db, "trips", id));

export const updateTask = (id, newFields) =>
  updateDoc(doc(db, "trips", id), newFields);

export const getTasks = () => getDocs(collection(db, "trips"));

export const getTask2 = (username) => getDoc(doc(db, "passengersWeb", username));

export const getPassengerByFamily = async (family) => {
  const passengersRef = collection(db, "passengersWeb");
  const q = query(passengersRef, where("family", "==", family));

  const querySnapshot = await getDocs(q);

  if (!querySnapshot.empty) {
    const passengerData = querySnapshot.docs[0].data();
    return passengerData;
  } else {
    return null; // No passenger found with the given username
  }
};
export const getPassengerByUsername = async (username) => {
  const passengersRef = collection(db, "passengersWeb");
  const q = query(passengersRef, where("username", "==", username));

  const querySnapshot = await getDocs(q);

  if (!querySnapshot.empty) {
    const passengerData = querySnapshot.docs[0].data();
    return passengerData;
  } else {
    return null; // No passenger found with the given username
  }
};

export const savePassenger = async (family, passengerPhone, homeAdress) => {
  const passengersRef = collection(db, "passengersWeb");
  const q = query(passengersRef, where("family", "==", family));

  const querySnapshot = await getDocs(q);
  if (querySnapshot.empty) {
    console.log("No encontrado");
    return await addDoc(collection(db, "passengersWeb"), { family, passengerPhone, homeAdress});
  }
  else{console.log("Encontrado");}
};

export const updatePassenger = (id, newFields) =>
  updateDoc(doc(db, "passengersWeb", id), newFields);



  export const iniciarEscuchaConductores = (callback) => {
    const driversCollection = collection(db, 'drivers');
    
    // Escuchar cambios en tiempo real en la colección de conductores
    onSnapshot(driversCollection, (snapshot) => {
      const coordenadas = [];
  
      snapshot.forEach((doc) => {
        const conductor = doc.data();
        const latitud = conductor.userLatitude;
        const longitud = conductor.userLongitude;
        const username = conductor.username;
        const numeroUnidad = conductor.numeroUnidad;
        const placa=conductor.placa;
        const marca=conductor.marca;
        const modelo=conductor.modeloVehiculo;
  
        // Agregar las coordenadas a la lista
        coordenadas.push({ latitud, longitud,username,numeroUnidad,placa,modelo,marca});
        console.log(latitud,longitud,username,modelo);
      });
  
      // Llamar a la función de callback con las coordenadas actualizadas
      callback(coordenadas);
    });
  };
  
  export const weblogin = async (username, password) => {
    const passengersRef = collection(db, "AdminWeb");
    const q = query(passengersRef, where("User", "==", username), where("password", "==", password));
  
    const querySnapshot = await getDocs(q);
  
    if (!querySnapshot.empty) {
      const passengerData = querySnapshot.docs[0].data();
      return passengerData;
    } else {
      return null; // No se encontró ningún registro con el nombre de usuario y contraseña proporcionados
    }
  };
  

  