let tblpropietario, tblpropietario2;

document.addEventListener("DOMContentLoaded", function () {
       const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },
       {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
]
const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
"<'row'<'col-sm-12'tr>>" +
"<'row'<'col-sm-5'i><'col-sm-7'p>>";
    tblpropietario = $('#tblpropietario').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/propietarioC.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_propietario'},
            { 'data': 'nombre'},
            { 'data': 'apellidos'},
            { 'data': 'dni'},
            { 'data': 'direccion'},
            { 'data': 'num_contacto'},
            { 'data': 'correo'},
            { 'data': 'empresa'},
            { "data": "editar" },
            { "data": "eliminar" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla 
    tblpropietario2 = $('#tblpropietario2').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/propietarioC.php?op=listarP",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_propietario'},
            { 'data': 'nombre'},
            { 'data': 'apellidos'},
            { 'data': 'dni'},
            { 'data': 'direccion'},
            { 'data': 'num_contacto'},
            { 'data': 'correo'},
            { "data": "editar" },
            { "data": "eliminar" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla 

    $("#autocomplete").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/empresaC.php?op=buscar",
                dataType: "json",
                type:'get',
                data: {
                    emp: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('autocomplete').value=ui.item.usuario; // display the selected text
            document.getElementById('idempre').value=ui.item.id; // save selected id to input
    
        },
    });
    
});

function frmPropietario() {
    document.getElementById("title").textContent = "Nuevo Propietario";
    document.getElementById("btnAccion").textContent = "Registrar";
    //document.getElementById("claves").classList.remove("d-none");
    //document.getElementById("btnAccion").setAttribute('onclick','registrarEmpresa(event);')
   document.getElementById("frmPropietario").reset();
   document.getElementById("id").value = "";
    $('#nuevo_propietario').modal('show');
}

function registrarPropietario(e) {
    e.preventDefault();
    const dni = document.getElementById("dni");
    const nombre = document.getElementById("nombre");
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (dni.value == "" || nombre.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/propietarioC.php?op=registrar";
        const frm = document.getElementById("frmPropietario");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nuevo_propietario").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                tblpropietario2.ajax.reload();
            }
        }
    }
}

function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar Propietario";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    const url = "../control/propietarioC.php?op=editar&id="+id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("id").value = id;
             document.getElementById("nombre").value=res.nombre;
            document.getElementById("apellidos").value=res.apellidos;
            document.getElementById("dni").value=res.dni;
            document.getElementById("numcontacto").value=res.num_contacto;
            document.getElementById("direccion").value=res.direccion;
            document.getElementById("correo").value=res.correo;
            document.getElementById('idempre').value=res.id_empresa;
            document.getElementById('autocomplete').value=res.empresa;
              $('#nuevo_propietario').modal('show');
        }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El Propietario se eliminara de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/propietarioC.php?op=eliminar&id="+id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblpropietario.ajax.reload();
                    tblpropietario2.ajax.reload();
                }
            }
            
        }
    })
}
function alertas(mensaje, icono) {
    Swal.fire({
       // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}


