let tblUsuarios ,tblUsuariosEmpr;
document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";
    tblUsuarios = $('#tblUsuarios').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/UsuarioC.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_usuario' },
            { 'data': 'datou' },
            { 'data': 'dni' },
            { 'data': 'nickusuario' },
            { 'data': 'perfil' },
            { 'data': 'num_contacto' },
            { 'data': 'correo' },
            { 'data': 'direccion' },
            { "data": "editar" },
            { "data": "eliminar" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla usuarios
    tblUsuariosEmpr= $('#tblUsuariosEmpr').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/UsuarioC.php?op=listaruserEmpr",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_usuario' },
            { 'data': 'datou' },
            { 'data': 'dni' },
            { 'data': 'nickusuario' },
            { 'data': 'perfil' },
            { 'data': 'num_contacto' },
            { 'data': 'correo' },
            { 'data': 'direccion' },
            { "data": "editar" },
            { "data": "eliminar" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });


});
function frmUsuario() {
    document.getElementById("title").textContent = "Nuevo Usuario";
    //document.getElementById("btnAccion").setAttribute('onclick','registrarUser(event);');
    document.getElementById("btnAccion").textContent = "Registrar";
    document.getElementById("claves").classList.remove("d-none");
    document.getElementById("frmUsuario").reset();
    document.getElementById("id").value = "";

    $('#nuevo_usuario').modal('show');
}
function registrarUser(e) {

    e.preventDefault();
    const usuario = document.getElementById("usuario");
    const nombre = document.getElementById("nombre");
    const clave = document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (usuario.value == "" || nombre.value == "") {
        alertas('Todo los campos son obligatorios', 'warning');
    }
    else if (clave.length >8) {
        alertas('Contraseña debe contener al menos 8 caracteres', 'warning');
    }
    else {
        const url = "../control/UsuarioC.php?op=registrar";
        const frm = document.getElementById("frmUsuario");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nuevo_usuario").modal("hide");
                alertas(res.msg, res.icono);
                tblUsuarios.ajax.reload();
            }
        }
    }
}
function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar usuario";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    //document.getElementById("btnAccion").setAttribute('onclick','modificarUser(event);');
    const url = "../control/usuarioC.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("id").value = id;
            document.getElementById("nombre").value = res.nombre;
            document.getElementById("apellidos").value = res.apellidos;
            document.getElementById("nuncontacto").value=res.num_contacto;
            document.getElementById("usuario").value = res.nickusuario;
            document.getElementById("perfil").value = res.id_perfil;
            document.getElementById("direccion").value = res.direccion;
            document.getElementById("correo").value = res.correo;
            document.getElementById("dni").value = res.dni;
            document.getElementById("claves").classList.add("d-none");
            $('#nuevo_usuario').modal('show');
        }
    }
}

function modificarUser(e) {
    e.preventDefault();
    const usuario = document.getElementById("usuario");
    const nombre = document.getElementById("nombre");
    if (usuario.value == "" || nombre.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } else {
    const url = "../control/UsuarioC.php?op=modificar";
    const frm = document.getElementById("frmUsuario");
    const http = new XMLHttpRequest();
    http.open("POST", url, true);
    http.send(new FormData(frm));
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {

            const res = JSON.parse(this.responseText);
            //document.getElementById("btnAccion").setAttribute('onclick','registrarUser(event);');
            $("#nuevo_usuario").modal("hide");
            alertas(res.msg, res.icono);
            tblUsuarios.ajax.reload();
            tblUsuariosEmpr.ajax.reload();
        }
    }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El usuario se eliminara de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/usuarioC.php?op=eliminar&id=" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblUsuarios.ajax.reload();
                    tblUsuariosEmpr.ajax.reload();
                }
            }

        }
    })
}

function registrarUserEmp(e) {
    e.preventDefault();
    const usuario = document.getElementById("usuario");
    const nombre = document.getElementById("nombre");
    const clave = document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (usuario.value == "" || nombre.value == "") {
        alertas('Todo los campos son obligatorios', 'warning');
    }
    else if (clave.length >8) {
        alertas('Contraseña debe contener al menos 8 caracteres', 'warning');
    }
    else {
        const url = "../control/UsuarioC.php?op=registraruserEmp";
        const frm = document.getElementById("frmUsuario");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nuevo_usuario").modal("hide");
                alertas(res.msg, res.icono);
                tblUsuariosEmpr.ajax.reload();
                tblUsuarios.ajax.reload();
                
            }
        }
    }
}
function alertas(mensaje, icono) {
    Swal.fire({
        //position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}