
let tblVehiculos, tblVehiculos2;
document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de Vehiculos',
        filename: 'Reporte de Vehiculos',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";
     tblVehiculos2 = $('#tblVehiculos2').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/vehiculoC.php?op=listar2",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_vehiculo' },
            { 'data': 'codvehiculo' },
            { 'data': 'placa' },
            { 'data': 'modelo' },
            { 'data': 'marca' },
            { 'data': 'propietario' },
            { 'data': 'cod_ruta' },
            { 'data': 'dispositivo' },
            { 'data': 'imagen' },
            { 'data': 'editar' },
            { 'data': 'eliminar' }

        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla 

       $("#autocompletar2").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/rutaC.php?op=buscar2",
                dataType: "json",
                type: 'get',
                data: {
                    rut: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('autocompletar2').value = ui.item.cod_ruta; // display the selected text
            document.getElementById('idrut').value = ui.item.id; // save selected id to input

        },
    });
       $("#autocompletarP2").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/propietarioC.php?op=buscar2",
                dataType: "json",
                type: 'get',
                data: {
                    prop: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('autocompletarP2').value = ui.item.propietario; // display the selected text
            document.getElementById('idprop').value = ui.item.id; // save selected id to input

        },
    });
    listadisp();
   // listardis();
   
});

document.getElementById("disp").onchange = function () {
    var seleccionado = this.value;
    if(seleccionado==0){
    $("#imgdis").removeClass('fas fa-edit').addClass('fas fa-plus');
    document.getElementById("idagregardispo").setAttribute("onclick","frmdisp()"); 
    }

    $("#imgdis").removeClass('fas fa-plus').addClass('fas fa-edit');
    document.getElementById("idagregardispo").setAttribute("onclick", "editardisp(" + seleccionado + ")");
    // $("#idagregardispo").onclick("editar("+seleccionado+")");
    //  document.getElementById("idagregardispo").onclick="editar("+seleccionado+")";

}
function frmVehiculo() {
    document.getElementById("title").textContent = "Nuevo Vehículo";
    document.getElementById("btnAccion").textContent = "Registrar";
    document.getElementById("formulariovehiculo").reset();
    document.getElementById("id").value = "";
    $("#imgdis").removeClass('fas fa-edit').addClass('fas fa-plus ');
    document.getElementById("idagregardispo").setAttribute("onclick", "frmdisp()");
    $('#myModal').modal('show');
    deleteImg();
}

function registrarVeh(e) {
    e.preventDefault();
    const placa = document.getElementById("placa").value;
    const marca = document.getElementById("marca").value;
    // const tipo = document.getElementById("vehiculo").value;
    const modelo = document.getElementById("modelo").value;
    if (placa == '' || marca == '' || modelo == '') {
        alertas('Todo los campos son requeridos', 'warning');
        return false;
    } else {
        const url = '../control/vehiculoC.php?op=inserta';
        const frm = document.getElementById("formulariovehiculo");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                // console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                frm.reset();
                tblVehiculos2.ajax.reload();
                $('#myModal').modal('hide');
               

            }
        }
    }
}

function btnEditarVeh(id) {
    document.getElementById("title").textContent = "Actualizar Vehículo";
    document.getElementById("btnAccion").textContent = "Modificar";
    $("#imgdis").removeClass('fas fa-plus').addClass('fas fa-edit');
    const url = "../control/vehiculoC.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("id").value = res.id_vehiculo;
            document.getElementById("codigo").value = res.codvehiculo;
            document.getElementById("placa").value = res.placa;
            document.getElementById("marca").value = res.marca;
            // document.getElementById("vehiculo").value = res.vehiculo;
            document.getElementById("modelo").value = res.modelo;
            document.getElementById("autocompletar2").value = res.cod_ruta;
            document.getElementById("idrut").value = res.id_ruta;
            document.getElementById("autocompletarP2").value = res.datoprop;
            document.getElementById("idprop").value = res.id_propietario;
            document.getElementById("img-preview").src = '../Assets/img/vehiculos/' + res.img;
            document.getElementById("icon-cerrar").innerHTML = `
            <button class="btn btn-outline-danger" onclick="deleteImg()">
            <i class="fas fa-times-circle"></i></button>`;
            document.getElementById("icon-image").classList.add("d-none");
            document.getElementById("foto_actual").value = res.img;
            document.getElementById("disp").value=res.iddevices;
            document.getElementById("idagregardispo").setAttribute("onclick", "editardisp(" + res.iddevices + ")");
             $('#myModal').modal('show');
             tblVehiculos2.ajax.reload();
        }
    }
}
function btnEliminarVeh(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El vehículo no se eliminará de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/vehiculoC.php?op=eliminar&id=" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    alertas(res.msg, res.icono);
                     tblVehiculos2.ajax.reload();
                }
            }

        }
    })
}


function listadisp(){

    $.ajax({
        url: "../control/dispositivoC.php?op=listardisp",
        type: "GET",
        dataType: "json",
        success: function (datos) {
            //console.log(datos);
            // Recorrer los datos 
            $("#disp").empty();
            $("#disp").append(
                "<option  value='0'>Seleccionar...</option>");
            for (var i = 0; i < datos.length; i++) {
                $("#disp").append(
                    "<option  value='" + datos[i]["id_empresa_devices"] + "'>" + datos[i]["dispositivo"] + "</option>");
            }
        }
    });

}
document.getElementById("disp").onclick = function () {
    var seleccionado = this.value;
    if(seleccionado==0){
        $("#imgdis").removeClass('fas fa-edit').addClass('fas  fa-plus');
        document.getElementById("idagregardispo").setAttribute("onclick","frmdisp()");

    }else{
        $("#imgdis").removeClass('fas fa-plus').addClass('fas fa-edit');
        document.getElementById("idagregardispo").setAttribute("onclick", "editardisp(" + seleccionado + ")");
    }
    
    // $("#idagregardispo").onclick("editar("+seleccionado+")");
    //  document.getElementById("idagregardispo").onclick="editar("+seleccionado+")";

}
function alertas(mensaje, icono) {
    Swal.fire({
        // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}

function preview(e) {
    var input = document.getElementById('imagen');
    var filePath = input.value;
    var extension = /(\.png|\.jpeg|\.jpg)$/i;
    if (!extension.exec(filePath)) {
        alertas('Seleccione un archivo valido', 'warning');
        deleteImg();
        return false;
    } else {
        const url = e.target.files[0];
        const urlTmp = URL.createObjectURL(url);
        document.getElementById("img-preview").src = urlTmp;
        document.getElementById("icon-image").classList.add("d-none");
        document.getElementById("icon-cerrar").innerHTML = `
        <button class="btn btn-outline-danger" onclick="deleteImg()"><i class="fas fa-times-circle"></i></button>
        `;
    }
}
function deleteImg() {
    document.getElementById("icon-cerrar").innerHTML = '';
    document.getElementById("icon-image").classList.remove("d-none");
    document.getElementById("img-preview").src = '';
    document.getElementById("imagen").value = '';
    document.getElementById("foto_actual").value = '';
}
function frmdisp() {
    document.getElementById("iddispo").value = "";
    document.getElementById("title2").textContent = "Nuevo Dispositivo";
    document.getElementById("formdisp").reset();
    document.getElementById("alerta").classList.add("d-none");
    $('#Modaldispositivo').modal('show');
}
function registrarDisp(e) {
    e.preventDefault();
    const nomdisp = document.getElementById("nomdisp").value;
    const identificador = document.getElementById("identificador").value;
    if (nomdisp == '' || identificador == '') {
        document.getElementById("alerta").classList.remove("d-none");
        document.getElementById("alerta").innerHTML = "Todo los campos son requeridos";
        
    }
    else {

        const url = '../control/dispositivoC.php?op=registar';
        const frm = document.getElementById("formdisp");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                if (res == "ok") {
                    $("#imgdis").removeClass('fas fa-plus').addClass('fas fa-edit');
                    $('#Modaldispositivo').modal('hide');
                    listadisp();
                     } else {
                    document.getElementById("alerta").classList.remove("d-none");
                    document.getElementById("alerta").innerHTML = res;
                }
            }
        }

    }
}
function editardisp(id) {
    
    document.getElementById("title2").textContent = "Modificar Dispositivo";
    document.getElementById("alerta").classList.add("d-none");
    const url = "../control/dispositivoC.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("idempdis").value =id;
            document.getElementById("iddispo").value =res.id;
            document.getElementById("nomdisp").value = res.name;
            document.getElementById("identificador").value = res.uniqueid;
             $('#Modaldispositivo').modal('show');
             }
    }
   
}
