import {
  onGetTasks,
  saveTask,
  deleteTask,
  getTask,
  updateTask,
  getTasks,
  getPassengerByUsername,
  savePassenger,
  updatePassenger,
  getTask2,
  getPassengerByFamily,
  iniciarEscuchaConductores 
} from "./firebase.js";

const taskForm = document.getElementById("task-form");
const tasksContainer = document.getElementById("tasks-container");

let previousMarker = null;
const map = document.getElementById("map");

const searchButton = document.getElementById("btn-search"); 
const tripsAcceptedCheckbox = document.getElementById("tripsAccepted");
const tripsCanceledCheckbox = document.getElementById("tripsCanceled");
const tripsSearchCheckbox = document.getElementById("tripsSearch");

const inputPickup = document.getElementById('trips-pickupAddress');
let editStatus = false;
let id = "";

function actualizarInputPickup(nuevoValor) {
  inputPickup.value = nuevoValor;
  
  // Crea un nuevo evento "change" y desencadena manualmente el evento en inputPickup
  const changeEvent = new Event('change', { bubbles: true });
  inputPickup.dispatchEvent(changeEvent);
}
window.addEventListener("DOMContentLoaded", async (e) => {
  // const querySnapshot = await getTasks();
  // querySnapshot.forEach((doc) => {
    // console.log(doc.data());
  // });
   // Evento para marcar/desmarcar la otra casilla
  
  initMap();

   function handleCheckboxChange(checkboxToUpdate, checkboxesToUncheck) {
    checkboxToUpdate.value = true;
  
    checkboxesToUncheck.forEach((checkbox) => {
      checkbox.value = false;
      checkbox.checked = false;
    });
  
    console.log("Acepted:", tripsAcceptedCheckbox.value,"Cancel" ,tripsCanceledCheckbox.value,"Search" ,tripsSearchCheckbox.value);
  }
  
  tripsAcceptedCheckbox.addEventListener("change", () => {
    handleCheckboxChange(tripsAcceptedCheckbox, [tripsCanceledCheckbox, tripsSearchCheckbox]);
  });
  
  tripsCanceledCheckbox.addEventListener("change", () => {
    handleCheckboxChange(tripsCanceledCheckbox, [tripsAcceptedCheckbox, tripsSearchCheckbox]);
  });
  
  tripsSearchCheckbox.addEventListener("change", () => {
    handleCheckboxChange(tripsSearchCheckbox, [tripsAcceptedCheckbox, tripsCanceledCheckbox]);
  });
  const geocode = new google.maps.Geocoder();
  searchButton.addEventListener("click", async (e) => {
    e.preventDefault();

    const passengerIdValue = taskForm["trips-passengerFamily"].value;

    if (passengerIdValue) {
      const passengerData = await getPassengerByFamily(passengerIdValue);

      if (passengerData) {
        taskForm["passengers-phone"].value = passengerData.passengerPhone;
        taskForm["trips-passengerId"].value=passengerData.id;
        taskForm["trips-passengerFamily"].value=taskForm["trips-passengerFamily"].value;
        taskForm["trips-pickupAddress"].value=passengerData.homeAdress;

        actualizarInputPickup(passengerData.homeAdress);
        console.log("Encontrado");
        console.log(taskForm["trips-passengerId"].value);
      } else {
        taskForm["passengers-phone"].value = "";
        taskForm["trips-passengerId"].value=taskForm["trips-passengerId"].value;
        taskForm["trips-pickupAddress"].value="";
        console.error;
      }
    }
  });
  onGetTasks((querySnapshot) => {
    tasksContainer.innerHTML = " ";

    querySnapshot.forEach((doc) => {
      const trips = doc.data();

      tasksContainer.innerHTML += `
      <div class="card card-body mt-2 border-primary">
    <h3 class="h5">${trips.accepted}</h3>
    <p>${trips.canceled}</p>
    <p>${trips.cost}</p>
    <p>${trips.destinationAddress}</p>
    <p>${trips.destinationLatitude}</p>
    <p>${trips.destinationLongitude}</p>
    <p>${trips.distance}</p>
  
    <p>${trips.passengerId}</p>
    
    <p>${trips.passengerPhone}</p>
    <p>${trips.pickupAddress}</p>
    <p>${trips.pickupLongitude}</p>
    <p>${trips.userPrice}</p>

    <div>
      <button class="btn btn-primary btn-delete" data-id="${doc.id}">
        🗑 Delete
      </button>
      <button class="btn btn-secondary btn-edit" data-id="${doc.id}">
        🖉 Edit
      </button>
    </div>
  </div>`;
    });

    const btnsDelete = tasksContainer.querySelectorAll(".btn-delete");
    btnsDelete.forEach((btn) =>
      btn.addEventListener("click", async ({ target: { dataset } }) => {
        try {
          await deleteTask(dataset.id);
        } catch (error) {
          console.log(error);
          console.log(doc.id);
        }
      })
    );

    const btnsEdit = tasksContainer.querySelectorAll(".btn-edit");
    btnsEdit.forEach((btn) => {
      btn.addEventListener("click", async (e) => {
        try {
          const doc = await getTask(e.target.dataset.id);
          const docPassenger = await getTask2(e.target.dataset.id);
          const trips = doc.data();
          const pass = docPassenger.data(); 
          taskForm["trips-accepted"].value = trips.accepted;
          taskForm["trips-canceled"].value = trips.canceled;
          taskForm["trips-cost"].value = trips.cost;
          taskForm["trips-destinationAddress"].value = trips.destinationAddress;
          taskForm["trips-destinationLatitude"].value = trips.destinationLatitude;
          taskForm["trips-destinationLongitude"].value = trips.destinationLongitude;
          taskForm["trips-distance"].value = trips.distance;
   
          taskForm["trips-passengerId"].value = trips.passengerId;
          
          taskForm["passengers-phone"].value = pass.phone;
          
          taskForm["trips-pickupAddress"].value = trips.pickupAddress;
          taskForm["trips-pickupLatitude"].value = trips.pickupLatitude;
          taskForm["trips-pickupLongitude"].value = trips.pickupLongitude;
          taskForm["trips-userPrice"].value = trips.userPrice;

          editStatus = true;
          id = doc.id;
          taskForm["btn-task-form"].innerText = "Update";
        } catch (error) {
          console.log(error);
        }
      });
    });
  });
});


taskForm.addEventListener("submit", async (e) => {
  e.preventDefault();

  const accepted = tripsAcceptedCheckbox.value === "true";
  const canceled = tripsCanceledCheckbox.value === "true";
  
  console.log("Aceptado:", accepted);  // true si está marcado, false si no
  console.log("Cancelado:", canceled); 

  const cost = Number(taskForm["trips-cost"].value);
  const destinationAddress = taskForm["trips-destinationAddress"];
  const destinationLatitude = Number(taskForm["trips-destinationLatitude"].value);
  const destinationLongitude = Number(taskForm["trips-destinationLongitude"].value);
  const distance = Number(taskForm["trips-distance"].value);
  const passengerFamily=taskForm["trips-passengerFamily"]
  const passengerId = taskForm["trips-passengerId"]; //es ul usuario, no olvidar
  const passengerPhone = taskForm["passengers-phone"];
  const pickupAddress = taskForm["trips-pickupAddress"];
  const pickupLatitude = Number(taskForm["trips-pickupLatitude"].value);
  const pickupLongitude = Number(taskForm["trips-pickupLongitude"].value);
  const userPrice = Number(taskForm["trips-userPrice"].value);

  try {
    if (!editStatus) {
        const docPas = await savePassenger(passengerFamily.value, passengerPhone.value,pickupAddress.value);
        if(docPas){
          const nuevoIdPass=docPas.id;
          console.log("Creando pasajero");
          await updatePassenger(nuevoIdPass, {id: nuevoIdPass})
          const passengerData = await getPassengerByFamily(passengerFamily.value);
          passengerId.value=passengerData.id;
          console.log(passengerId.value);
        }
        const docRef = await saveTask(accepted, canceled, cost, destinationAddress.value, destinationLatitude, destinationLongitude, distance, passengerId.value, pickupAddress.value, pickupLatitude, pickupLongitude, userPrice);
       
        const nuevoId = docRef.id;
        await updateTask(nuevoId, {id: nuevoId});;
        
    } else {
      await updateTask(id, {
        accepted: Boolean(accepted.value),
        canceled: Boolean(canceled.value),
        cost: parseFloat(cost.value),
        destinationAddress: destinationAddress.value,
        destinationLatitude: parseFloat(destinationLatitude.value).toFixed(7),
        destinationLongitude: parseFloat(destinationLongitude.value).toFixed(7),
        distance: parseFloat(distance.value),
      
        passengerId: passengerId.value,
        pickupAddress: pickupAddress.value,
        pickupLatitude: parseFloat(pickupLatitude.value).toFixed(7),
        pickupLongitude: parseFloat(pickupLongitude.value).toFixed(7),
        userPrice: parseFloat(userPrice.value),
      });

      editStatus = false;
      id = "";
      taskForm["btn-task-form"].innerText = "Save";
    }

    taskForm.reset();
    tripsAcceptedCheckbox.focus();
  } catch (error) {
    console.log(error);
  }
});
 let destinationMarker;
  let pickupMarker;


// Declarar una variable para almacenar los marcadores
// Crear un objeto para realizar un seguimiento de las posiciones anteriores de los conductores
const carPositions = {};
const carMarkers=[];

const drawMarkers = async (map,conductores) => {
  for (let i = 0; i < conductores.length; i++) {
    const carCoordinates = conductores[i];
 
    if (carCoordinates.latitud && carCoordinates.longitud) {
      const carIconUrl = '../Assets/img/car4.png';
      const carIcon = {
        url: carIconUrl,
        scaledSize: new google.maps.Size(60, 70),
        labelOrigin: new google.maps.Point(30,10), // Ajusta la posición del texto en relación con el marcador
      };
      console.log(carCoordinates.username,carCoordinates.longitud);
      // Verificar si ya existe un marcador para este conductor
      if (!carPositions[i]) {
        // Si no existe, crear uno nuevo y guardar la posición anterior
        carPositions[i] = {
          lat: carCoordinates.latitud,
          lng: carCoordinates.longitud,
        };
        const infoWindowContent = `
          <p><strong>Nombre:</strong> ${carCoordinates.username}</p>
          <p><strong>Marca:</strong> ${carCoordinates.marca}</p>
          <p><strong>Modelo:</strong> ${carCoordinates.modelo}</p>
          <p><strong>Placa:</strong> ${carCoordinates.placa}</p>
        `;
        
        const infoWindow = new google.maps.InfoWindow({
          content: infoWindowContent,
        });


        const carMarker = new google.maps.Marker({
          position: { lat: carCoordinates.latitud, lng: carCoordinates.longitud },
          map: map,
          icon: carIcon,
          label: {
            text: carCoordinates.username,
            color: 'white',
            fontSize: '15px',
            fontWeight: 'bold',
            backgroundColor: 'blue',
            padding: '30px 30px',
            borderRadius: '50px',
          },
        });
        
        carMarker.addListener('click', () => {
          infoWindow.open(map, carMarker);
        });
        carMarkers[i] = carMarker;
      } else {
        // Si existe, realizar una transición suave a la nueva posición
        const currentLatlng = carMarkers[i].getPosition();
        const newLatlng = new google.maps.LatLng(carCoordinates.latitud, carCoordinates.longitud);

        // Utilizar una función para realizar la transición suave
        smoothTransition(carMarkers[i],i, currentLatlng, newLatlng);
      }
    } else {
      //console.warn('Coordenadas inválidas para conductor:', carCoordinates);
    }
  }
};

// Función para realizar una transición suave entre dos posiciones
function smoothTransition(marker,i, startLatlng, endLatlng) {
  let numSteps = 100; // Número de pasos para la transición
  let step = 0;

  const latStep = (endLatlng.lat() - startLatlng.lat()) / numSteps;
  const lngStep = (endLatlng.lng() - startLatlng.lng()) / numSteps;

  function animateMarker() {
    if (step < numSteps) {
      const newLat = startLatlng.lat() + step * latStep;
      const newLng = startLatlng.lng() + step * lngStep;

      const newPosition = new google.maps.LatLng(newLat, newLng);
      marker.setPosition(newPosition);

      step++;
      requestAnimationFrame(animateMarker);
    } else {
      // Cuando se completa la transición, actualizar la posición anterior
      carPositions[i] = {
        lat: endLatlng.lat(),
        lng: endLatlng.lng(),
      };
    }
  }

  animateMarker();
}



// Inicializar el mapa y otros componentes
function initMap() {
  const map = new google.maps.Map(document.getElementById('map'), {
    center: { lat: -16.3989, lng: -71.5362 },
    zoom: 15
  });

iniciarEscuchaConductores((conductores) => {
  // Llama a la función para dibujar los marcadores con las coordenadas actualizadas
  drawMarkers(map, conductores);
});
// Coordenadas donde deseas ubicar el icono del auto

  const geocoder = new google.maps.Geocoder();
  const directionsService = new google.maps.DirectionsService();
  const directionsRenderer = new google.maps.DirectionsRenderer();
  directionsRenderer.setMap(map);
  const inputDestination = document.getElementById('trips-destinationAddress');


  const destinationLatitude = document.getElementById('trips-destinationLatitude');
  const destinationLongitude = document.getElementById('trips-destinationLongitude');
  const pickupLatitude = document.getElementById('trips-pickupLatitude');
  const pickupLongitude = document.getElementById('trips-pickupLongitude');
  
  function createOrUpdateMarker(location) {
  // Eliminar el marcador anterior si existe
  if (previousMarker) {
    previousMarker.setMap(null);
    previousMarker = null;
  }

  // Crear un nuevo marcador
  const newMarker = new google.maps.Marker({
    position: location,
    map: map // Asegúrate de que map esté definido en tu código
  });

  // Asignar el nuevo marcador a la variable previousMarker
  previousMarker = newMarker;

  return newMarker;
  }

  function updateRoute() {
    const destination = inputDestination.value;
    const start = inputPickup.value;
    if (destination && start && !isNaN(destinationLatitude.value) && !isNaN(destinationLongitude.value) && !isNaN(pickupLatitude.value) && !isNaN(pickupLongitude.value)) {
      calculateAndDisplayRoute(destination, start);
    }
  }

  function geocodeAndFillFields(input, latFieldId, lngFieldId, marker) {
    geocoder.geocode({ address: input.value }, (results, status) => {
      if (status === 'OK' && results[0] && results[0].geometry) {

        const location = results[0].geometry.location;
        document.getElementById(latFieldId).value = location.lat();
        document.getElementById(lngFieldId).value = location.lng();
        createOrUpdateMarker(location);
        updateRoute();
        map.setCenter(location);
      } else {
        alert('No se pudo encontrar la ubicación');
      }
    });
  }

  inputDestination.addEventListener('change', () => {
    geocodeAndFillFields(inputDestination, 'trips-destinationLatitude', 'trips-destinationLongitude', destinationMarker);
    
    console.log("Insertado destino:", inputDestination.value);
  });

  inputPickup.addEventListener('change', () => {
    
    inputPickup.value=taskForm["trips-pickupAddress"].value;
    geocodeAndFillFields(inputPickup, 'trips-pickupLatitude', 'trips-pickupLongitude', pickupMarker);

    console.log("Insertado Inicio:", inputPickup.value);
  });

  function calculateAndDisplayRoute() {
    const destinationCoords = {
      lat: parseFloat(destinationLatitude.value),
      lng: parseFloat(destinationLongitude.value)
    };

    const pickupCoords = {
      lat: parseFloat(pickupLatitude.value),
      lng: parseFloat(pickupLongitude.value)
    };

    console.log(destinationLatitude.value, destinationLongitude.value);
    console.log(pickupLatitude.value,pickupLongitude.value);
    const flightPlanCoordinates = [destinationCoords, pickupCoords];
    directionsService
            .route({
              origin: pickupCoords,
              destination:destinationCoords,
             // waypoints: flightPlanCoordinates,
              optimizeWaypoints: true,
              travelMode: google.maps.TravelMode.DRIVING,
            })
            .then((response) => {
              directionsRenderer.setDirections(response);
        
              const route = response.routes[0];
            })
            .catch((e) => window.alert("Directions request failed due to " + e));
        
      // Calcular distancia y mostrar en consola

      const distanceInMeters = google.maps.geometry.spherical.computeDistanceBetween(
        new google.maps.LatLng(destinationCoords.lat, destinationCoords.lng),
        new google.maps.LatLng(pickupCoords.lat, pickupCoords.lng)
      );
    
      const distanceInKilometers = distanceInMeters / 1000;
  
  document.getElementById('trips-distance').value =distanceInKilometers.toFixed(2);
  document.getElementById("trips-cost").value=parseFloat(distanceInKilometers*2.20);
  console.log('Distancia:', distanceInKilometers.toFixed(2), 'KM');
  }
}
