let tblingreso,tblingreso2;
document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";
    tblingreso = $('#tblingreso').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/ingresoC.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_ingreso' },
            { 'data': 'empresa' },
            { 'data': 'propietario' },
            { 'data': 'placa' },
            { 'data': 'cuota' },
            { 'data': 'prestamo' },
            { 'data': 'gps' },
            { 'data': 'ahorro' },
            { 'data': 'evento' },
            { 'data': 'fec_registro' },
            { "data": "editar" },
            { "data": "eliminar" },
            { "data": "imprimir" }


        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla usuarios

    tblingreso2 = $('#tblingreso2').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/ingresoC.php?op=listarI",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_ingreso' },
            { 'data': 'propietario' },
            { 'data': 'placa' },
            { 'data': 'cuota' },
            { 'data': 'prestamo' },
            { 'data': 'gps' },
            { 'data': 'ahorro' },
            { 'data': 'evento' },
            { 'data': 'fec_registro' },
            { "data": "editar" },
            { "data": "eliminar" },
            { "data": "imprimir" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });
    $("#placa").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/vehiculoC.php?op=buscar",
                dataType: "json",
                type:'get',
                data: {
                    veh: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('placa').value=ui.item.placa; // display the selected text
            document.getElementById('idveh').value=ui.item.id; // save selected id to input
    
        },
    });
    $("#placa2").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/vehiculoC.php?op=buscar2",
                dataType: "json",
                type:'get',
                data: {
                    veh: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('placa').value=ui.item.placa; // display the selected text
            document.getElementById('idveh').value=ui.item.id; // save selected id to input
    
        },
    });




});
function frmIngreso() {
    document.getElementById("title").textContent = "Nuevo Ingreso";
    document.getElementById("btnAccion").textContent = "Registrar";
    document.getElementById("formularioingreso").reset();
    document.getElementById("id").value = "";
    $('#myModal').modal('show');
}


function registrarIngreso(e) {
    e.preventDefault();
    const placa = document.getElementById("placa").value;
   if (placa == '' ) {
        alertas('Todo los campos son requeridos', 'warning');
        return false;
    } else {
        const url = '../control/ingresoC.php?op=registrar';
        const frm = document.getElementById("formularioingreso");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                alertas(res.msg, res.icono);
                frm.reset();
                $('#myModal').modal('hide');
                tblingreso.ajax.reload();
                tblingreso2.ajax.reload();
                 //tblVehiculos.ajax.reload();
            }
        }
    }
}
function btnEditar(id) {
    document.getElementById("title").textContent = "Actualizar Vehículo";
    document.getElementById("btnAccion").textContent = "Modificar";
    const url = "../control/ingresoC.php?op=editar&id="+ id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("id").value = id;
            document.getElementById("idveh").value=res.id_vehiculo;
            document.getElementById("placa").value=res.placa;
            document.getElementById("cuota").value=res.cuota;
            document.getElementById("ahorro").value=res.ahorro;
            document.getElementById("gps").value=res.gps;
            document.getElementById("evento").value=res.evento;
            document.getElementById("prestamo").value=res.prestamo;
            $('#myModal').modal('show');
            tblingreso.ajax.reload();
            tblingreso2.ajax.reload();
        }
    }
}

function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: " se eliminara de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/ingresoC.php?op=eliminar&id=" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblingreso.ajax.reload();
                    tblingreso2.ajax.reload();
                 
                }
            }

        }
    })
}
function btnImprimir(id){  
    document.getElementById("title1").textContent = "RECIBO DE INGRESO";
    const url = "../control/ingresoC.php?op=imprimir&id="+ id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            document.getElementById("empresaI").innerHTML= res[0]['nombre'];
            document.getElementById("placaI").innerHTML = res[0]['placa'];
            document.getElementById("propietarioI").innerHTML = res[0]['propietario'];
            document.getElementById("cuotaI").innerHTML = res[0]['cuota'];
            document.getElementById("prestamoI").innerHTML = res[0]['prestamo'];
            document.getElementById("gpsI").innerHTML = res[0]['gps'];
            document.getElementById("ahorroI").innerHTML = res[0]['ahorro'];
            document.getElementById("eventoI").innerHTML = res[0]['evento'];
            document.getElementById("fechaI").innerHTML = res[0]['fec_registro'];
            document.getElementById("dniI").innerHTML = res[0]['dni'];
            $('#myModal2').modal('show');
            tblingreso.ajax.reload();
            tblingreso2.ajax.reload();
        }
    }

}
function imprSelec(nombre) {
    var ficha = document.getElementById(nombre);
    var ventimp = window.open(' ', 'popimpr');
    ventimp.document.write( ficha.innerHTML );
    ventimp.document.close();
    ventimp.print( );
    ventimp.close();
  }



function alertas(mensaje, icono) {
    Swal.fire({
        //position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}

