let tblpropietario;

document.addEventListener("DOMContentLoaded", function () {
       const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },
       {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
]
const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
"<'row'<'col-sm-12'tr>>" +
"<'row'<'col-sm-5'i><'col-sm-6'p>>";
    tblpropietario = $('#tblpropietario').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/insumos.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id','width':'10px'},
            { 'data': 'Nombres','width':'10px'},
            { 'data': 'DNI','width':'40px'},
            { 'data': 'Celular','width':'40px'},
            { 'data': 'adelanto_encargado','width':'10px'},
            { 'data': 'EstadoCivil'},
            
            { 'data': 'categoria'},
            { 'data': 'identificador','width':'10px'},
            {'data' : 'img','width':'10px'},
            { "data": "opciones",'width':'10px' },
            //{"data":'Estado','width':'60px'},
         
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        bDestroy: true,
        iDisplayLength: 25,
        order: 
            [4, "asc"]
        
    });//Fin de la tabla 
    var date = new Date();
    const [month, day, year] = [
      (date.getMonth()<9)?('0'+(date.getMonth()+1)):date.getMonth()+1,
      (date.getDate()<10)?('0'+date.getDate()):date.getDate(),
      date.getFullYear(),
    ];
     $('#tblpropietario').on('draw.dt', function () {
            $("tbody").find('tr').each(function () {
                var fecha = $(this).find('td:eq(4)').text();
                if (fecha===(''+year+"-"+month+"-"+day)) {
                    $(this).addClass('');
                     $('#tblpropietario')
                }else if (fecha<(''+year+"-"+month+"-"+day)){
                    $(this).addClass('');
                }
            });
    });
      
});

function frmPropietarioVivienda() {
    document.getElementById("title").textContent = "Nuevo Cliente";
    document.getElementById("btnAccion").textContent = "Registrar";
    //document.getElementById("claves").classList.remove("d-none");
    //document.getElementById("btnAccion").setAttribute('onclick','registrarEmpresa(event);')
   document.getElementById("frmPropietarioVivienda").reset();
   document.getElementById("id").value = "";
    $('#nuevo_propietariovivienda').modal('show');
}


function registrarPropietario(e) {
    e.preventDefault();
    const DNI = document.getElementById("DNI");
    const Nombres = document.getElementById("Nombres");
    
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (DNI.value == "" || Nombres.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/insumos.php?op=registrar";
        const frm = document.getElementById("frmPropietarioVivienda");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                
                $("#nuevo_propietariovivienda").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                
            }
        }
    }
}
function registrarPropietarioU(e) {
    e.preventDefault();
    const DNI = document.getElementById("DNI_u");
    const Nombres = document.getElementById("Nombres_u");
    
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (DNI.value == "" || Nombres.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
    } 
    else {
        const url = "../control/insumos.php?op=registrar";
        const frm = document.getElementById("frmPropietarioVivienda_u");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                console.log(this.responseText);
                const res = JSON.parse(this.responseText);
                
                $("#utilidad_propietariovivienda").modal("hide");
                alertas(res.msg, res.icono);
                tblpropietario.ajax.reload();
                
            }
        }
    }
}
function btnUtilidad(id) {
    document.getElementById("title_u").innerHTML = "Utilidad de Pedido";
    document.getElementById("btnAccion_u").innerHTML = "Subir Utilidad";
    const url = "../control/insumos.php?op=editar&id="+id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            
            document.getElementById("id_u").value = id;
            document.getElementById("Nombres_u").value=res.Nombres;
            document.getElementById("ApPaterno_u").value=res.ApPaterno;
            document.getElementById("ApMaterno_u").value=res.ApMaterno;
            document.getElementById("DNI_u").value=res.DNI;
            document.getElementById("EstadoCivil_u").value=res.EstadoCivil;
            document.getElementById("Genero_u").value=res.Genero;
            document.getElementById('Celular_u').value=res.Celular;
            document.getElementById('identificador_u').value=res.identificador;
            document.getElementById("Direccion_u").value=res.Direccion;
            document.getElementById('categoria_u').value=res.categoria;
            document.getElementById('montoservicio_u').value=res.montoservicio;
            document.getElementById('fechaInicio_u').value=res.fechaInicio;
            document.getElementById('adelanto_encargado_u').value=res.adelanto_encargado;
            document.getElementById('entrega_material_u').value=res.entrega_material;
            document.getElementById('fecha_encargado_u').value=res.fecha_encargado;
            //document.getElementById('utilidad_u').value=res.utilidad;
            
              $('#utilidad_propietariovivienda').modal('show');
        }
    }
}

function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar Cliente";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    const url = "../control/insumos.php?op=editar&id="+id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            console.log(this.responseText);
            const res = JSON.parse(this.responseText);
            
            document.getElementById("id").value = id;
            document.getElementById("Nombres").value=res.Nombres;
            document.getElementById("ApPaterno").value=res.ApPaterno;
            document.getElementById("ApMaterno").value=res.ApMaterno;
            document.getElementById("DNI").value=res.DNI;
            document.getElementById("EstadoCivil").value=res.EstadoCivil;
            document.getElementById("Genero").value=res.Genero;
            document.getElementById('Celular').value=res.Celular;
            document.getElementById('identificador').value=res.identificador;
            document.getElementById("Direccion").value=res.Direccion;
            document.getElementById('categoria').value=res.categoria;
            document.getElementById('montoservicio').value=res.montoservicio;
            document.getElementById('fechaInicio').value=res.fechaInicio;
            document.getElementById('adelanto_encargado').value=res.adelanto_encargado;
            document.getElementById('entrega_material').value=res.entrega_material;
            document.getElementById('fecha_encargado').value=res.fecha_encargado;
            
              $('#nuevo_propietariovivienda').modal('show');
        }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "El Propietario se eliminara de forma permanente",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/insumos.php?op=eliminar&id="+id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblpropietario.ajax.reload();
                   // tblpropietario2.ajax.reload();
                }
            }
            
        }
    })
}
function btnMostrar(imagen) {
    Swal.fire({
      title: '',
      iconHtml: "<img src='"+imagen+"' height='500px'>",
      customClass: {
        icon: 'no-border'
      }
    })
}
function btnEnviar(id){
        const estadoCivilMapping = {
    1: "Mercaderes",
    2: "Secundaria",
    3: "Tienda 3",
    // Agrega más mapeos según sea necesario
    };
    const Tipotrabajo= {
    1: "Contrato",
    2: "Compostura",
    3: "Presupuesto",
    // Agrega más mapeos según sea necesario
    };

    // Obtén los datos del cliente de la misma manera que en btnEditar
    const url = "../control/insumos.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            const estadoCivilText = estadoCivilMapping[res.EstadoCivil];
            const tipotrabaj=Tipotrabajo[res.Genero];
            // Crea un documento PDF utilizando pdfmake
                       // Crea un documento PDF utilizando pdfmake
            const pdfDefinition = {
                pageSize: {
                    width: 3.57 * 72, // Ancho en puntos
                    height: 8.53 * 72, // Alto en puntos
                },
                 pageMargins: [ 20, 40, 20, 40 ],
                content: [
                    //{text: "Joyeria", style: "header"},
                    {text: "Boleta de Pago", style: "headerb"},
                   // { text: "Factura de Cliente", style: "headerc", fontFeatures: ['smcp'] },
                    //{ text: estadoCivilText, style: "headerc" , fontFeatures: ['smcp']},
                    { text: "Datos del Conductor", style: "subheader", fontFeatures: ['smcp'] },
                    { text: "Nombre: "+ res.Nombres, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "UNIDAD: "+res.DNI, style: "subsubheader" , fontFeatures: ['smcp']},
                    { text: "Telefono: "+res.Celular, style: "subsubheader", fontFeatures: ['smcp'] },
                    
                    { text: "Detalle del pago", style: "subheader" , fontFeatures: ['smcp']},
                     
                    //{ text: res.Direccion|| '', style: "subsubheader", fontFeatures: ['smcp'] },
                   {alignment: 'center', text: "--------------------------------------------------", opacity: 0.1 },
                    {
                        columns: [
			            	{
			            		width: 150,
			            		text: "Tipo de trabajo: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text:tipotrabaj, style: "subsubheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    
                    {
                        columns: [
			            	{
			            		width: 150,
			            		text: "Fecha de entrega: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text:res.fechaInicio, style: "subsubheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    
                    {alignment: 'center', text: "--------------------------------------------------", opacity: 0.1},
                    {
                        columns: [
			            	{
			            		width: 180,
			            		text: "Adelanto: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.identificador, style: "subsubheader", fontFeatures: ['smcp'] 
			            	}
			            ]
                    },
                    {columns: [
			            	{
			            		width: 180,
			            		text: "A cuenta: ", style: "subsubheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.ApPaterno, style: "subsubheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    {columns: [
			            	{
			            		width: 180,
			            		text: "Total: ", style: "subheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.montoservicio, style: "subheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                    { qr: res.id, fit: 85,alignment: 'center' },
                    {text: " ", style: "header"},
                    {text: " ", style: "headerc"},
                   // {text: "Codigo : "+res.id, style: "headerc"},
                     {text: "Telefono: 954719184", style: "headerc"},
                     {text: "www.joyeriaelkero.pe ", style: "headerc"},
                     {text: "Oferta valida por 30 dias ", style: "headerc"},
                ],
                styles: {
                    header: {
                        fontSize: 10,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 2], // Margen inferior
                    },
                    headerb: {
                        fontSize: 14,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 10], // Margen inferior
                    },
                    headerc: {
                        fontSize: 5,
                        bold: false,
                        alignment: "center",
                        margin: [0, 0, 0, 0], // Margen inferior
                    },
                    subheader: {
                        fontSize:8,
                        bold: true,
                        margin: [0, 10, 0, 3], // Margen inferior
                    },
                    subsubheader: {
                        fontSize: 6,
                        bold: false,
                        margin: [0,2, 0, 3], // Margen inferior
                    },
                },
            };
            var PDFPrinter = require('pdfmake');
            const fonts = {
              Roboto: {
                normal: 'fonts/Roboto-Regular.ttf',
                bold: 'fonts/Roboto-Medium.ttf',
                italics: 'fonts/Roboto-Italic.ttf'
              }
            };
            const printer = new PDFPrinter(fonts);
            
            var pdf = printer.createPdfKitDocument(pdfDefinition);
            var base64Stream = pdf.pipe(Base64Stream.encode());
            pdf.end();

            // Fetch base64 encoded pdf
            var tempFileBase64 = '';
            base64Stream.on('data', function(buffer) {
                tempFileBase64 += buffer.toString();
            });
            
            base64Stream.on('end', function() {
                // Encode the PDF data as base64 URI
                var pdfBase64 = encodeURIComponent('data:application/pdf;base64,' + tempFileBase64);
            
                // Define the WhatsApp message
                var numeroDestino = '933011878'; // Reemplaza con el número de teléfono de destino
                var mensaje = 'Aquí tienes el PDF de tu pedido:';
                var enlaceWhatsApp = `https://api.whatsapp.com/send?phone=${numeroDestino}&text=${encodeURIComponent(mensaje            )}&data=${pdfBase64}`;

                // Abre la ventana de chat de WhatsApp con el PDF como enlace
                window.open(enlaceWhatsApp, '_blank');
            });

        }
    };
}
function btnImprimir(id) {
    
    const estadoCivilMapping = {
    1: "Mercaderes",
    2: "Secundaria",
    3: "Tienda 3",
    // Agrega más mapeos según sea necesario
    };
    const Tipotrabajo= {
    1: "Contrato",
    2: "Compostura",
    3: "Presupuesto",
    // Agrega más mapeos según sea necesario
    };

    // Obtén los datos del cliente de la misma manera que en btnEditar
    const url = "../control/insumos.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            const estadoCivilText = estadoCivilMapping[res.EstadoCivil];
            const tipotrabaj=Tipotrabajo[res.Genero];
            // Crea un documento PDF utilizando pdfmake
                       // Crea un documento PDF utilizando pdfmake
            const pdfDefinition = {
                pageSize: {
                    width: 3.57 * 72, // Ancho en puntos
                    height: 6.53 * 72, // Alto en puntos
                },
                 pageMargins: [ 5, 5, 5, 5 ],
                content: [
                    //{text: "Joyeria", style: "header"},
                       {text: "Bep Bip", style: "headerb"},
                    {text: "BOLETA DE PAGO", style: "headerb"},
                    //{ text: "Factura de Cliente", style: "headerc", fontFeatures: ['smcp'] },
                    //{ text: estadoCivilText, style: "headerc" , fontFeatures: ['smcp']},
                    { text: "Datos del Proveedor", style: "subheader", fontFeatures: ['smcp'] },
                    { text: "Numero de Boleta: "+ res.id, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "Nombre: "+ res.Nombres, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "Numero Unidad: "+res.DNI, style: "subsubheader" , fontFeatures: ['smcp']},
                    { text: "Telefono: "+res.Celular, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "Concepto: "+res.identificador, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "Periodo: "+res.EstadoCivil, style: "subsubheader", fontFeatures: ['smcp'] },
                    { text: "Año: "+res.categoria, style: "subsubheader", fontFeatures: ['smcp'] },
                    
                    { text: "Detalle del Pago", style: "subheader" , fontFeatures: ['smcp']},
                     { text: res.Direccion|| '', style: "subsubheader", fontFeatures: ['smcp'] },
                     
                    //{ text: "Declaro bajo juramento que las  joyas que estoy vendiendo son de mi propiedad, y las vendo sin precion alguna para lo cual doy conformidad con mi firma.", style: "subheader" , fontFeatures: ['smcp']},
                     
                     
                     {text: " ", style: "headerb"},
                      {text: " ", style: "headerb"},
                       {text: " ", style: "headerb"},
                    
                     
                   
                   {alignment: 'center', text: "--------------------------------------------------", opacity: 0.1 },
                  // {text: "FIRMA", style: "headerb"},
                  
                    
                    
                    {columns: [
			            	{
			            		width: 180,
			            		text: "Monto a Pagar: ", style: "subheader" , fontFeatures: ['smcp']
			            	},
			            	{   width: '*',
			            		text: res.adelanto_encargado, style: "subheader" , fontFeatures: ['smcp']
			            	}
			            ]
                    },
                   // { qr: res.id, fit: 85,alignment: 'center' },
                    {text: " ", style: "header"},
                    {text: " ", style: "headerc"},
                  //  {text: "Codigo : "+res.id, style: "headerc"},
                     {text: "Telefono: 959114859", style: "headerc"},
                     {text: "https://telconetperu.pe ", style: "headerc"},
                    // {text: "Oferta valida por 30 dias ", style: "headerc"},
                ],
                styles: {
                    header: {
                        fontSize: 12,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 2], // Margen inferior
                    },
                    headerb: {
                        fontSize: 16,
                        bold: true,
                        alignment: "center",
                        margin: [0, 0, 0, 0], // Margen inferior
                    },
                    headerc: {
                        fontSize: 8,
                        bold: false,
                        alignment: "center",
                        margin: [0, 0, 0, 0], // Margen inferior
                    },
                    subheader: {
                        fontSize: 14,
                        bold: true,
                        margin: [0, 10, 0, 3], // Margen inferior
                    },
                    subsubheader: {
                        fontSize: 12,
                        bold: false,
                        margin: [0,2, 0, 3], // Margen inferior
                    },
                },
            };
            // Genera el PDF y lo muestra en una nueva ventana
            pdfMake.createPdf(pdfDefinition).open();
        }
    };
}

function alertas(mensaje, icono) {
    Swal.fire({
       // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}


