document.addEventListener("DOMContentLoaded", function () {

    $("#nombreveh").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/recorridoC.php?op=buscar",
                dataType: "json",
                type: 'get',
                data: {
                    rec: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('nombreveh').value = ui.item.name;
            document.getElementById('idveh').value = ui.item.id;

        },
    });
    // Obtener la fecha actual
    var today = new Date();
    // Formatear la fecha
    var date = today.toISOString().substr(0, 10);
    document.getElementById("fecha").value = date;

})
var inter = 0, inter2 = 0;
function initialize() {

    geocoder = new google.maps.Geocoder();
    map = new google.maps.Map(document.getElementById('mapa'), {
    center: new google.maps.LatLng(-16.3990021, -71.5311412),
        zoom: 14,
    });   
    clearTimeout(inter);
    clearTimeout(inter2);
}
google.maps.event.addDomListener(window, 'load', initialize);
var speed = 50; // km/h
var delay = 250;
var icon;
function frmrecorridoveh(e){
   
    initialize();
    e.preventDefault();
    const url = "../control/recorridoC.php?op=mostrarR";
    const frm = document.getElementById("frmrecorridoveh");
    const http = new XMLHttpRequest();
    http.open("POST", url, true);
    http.send(new FormData(frm));
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            console.log(res);
            var arraypos = [];
            for (var i = 0; i < res.length; i++) {
                cord= new google.maps.LatLng(res[i]['latitude'], res[i]['longitude']);
                          arraypos.push(cord); 
            }
            console.log(arraypos);
            var simbolo_linea = {
                path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW
               };
              
            var line = new google.maps.Polyline({
                path: arraypos,
                strokeColor: "#582EF2",
                strokeOpacity: 2,
                strokeWeight: 3,
                 geodesic: true,
                 icons: [{
                    icon: simbolo_linea,
                    offset: '2',
                    repeat: '75px'
                   }],
                 
                map: map,
            });
            line.setMap(map);
            var marker;
            var car = "M17.402,0H5.643C2.526,0,0,3.467,0,6.584v34.804c0,3.116,2.526,5.644,5.643,5.644h11.759c3.116,0,5.644-2.527,5.644-5.644 V6.584C23.044,3.467,20.518,0,17.402,0z M22.057,14.188v11.665l-2.729,0.351v-4.806L22.057,14.188z M20.625,10.773 c-1.016,3.9-2.219,8.51-2.219,8.51H4.638l-2.222-8.51C2.417,10.773,11.3,7.755,20.625,10.773z M3.748,21.713v4.492l-2.73-0.349 V14.502L3.748,21.713z M1.018,37.938V27.579l2.73,0.343v8.196L1.018,37.938z M2.575,40.882l2.218-3.336h13.771l2.219,3.336H2.575z M19.328,35.805v-7.872l2.729-0.355v10.048L19.328,35.805z";

            icon = {
                path: car,
                scale: .7,
                strokeColor: 'white',
                strokeWeight: .10,
                fillOpacity: 1,
                fillColor: '#404040',
                offset: '5%',
                anchor: new google.maps.Point(10, 25)
            };

           marker = new google.maps.Marker({
                position: new google.maps.LatLng(res[0]['latitude'], res[0]['longitude']),
                icon: icon,
                map: map
            });
            google.maps.event.addListenerOnce(map, 'idle', function () {
                animateMarker(marker, res, speed);

            });

           
           }}}



function animateMarker(marker, coords, km_h)
{  
    var target = 0;  
    var km_h = km_h || 50;
    //coords.push([startPos[0], startPos[1]]);
    
    function goToPoint()
    {
        var lat = marker.position.lat();
        var lng = marker.position.lng();
        var step = (km_h * 1000 * delay) / 360000; // in meters
        
        var dest = new google.maps.LatLng(
        coords[target]['latitude'], coords[target]['longitude']);
        
        var distance =
        google.maps.geometry.spherical.computeDistanceBetween(
        dest, marker.position); // in meters
        
        var numStep = distance / step;
        var i = 0;
        var deltaLat = (coords[target]['latitude'] - lat) / numStep;
        var deltaLng = (coords[target]['longitude'] - lng) / numStep;
        
        function moveMarker()
        {
            lat += deltaLat;
            lng += deltaLng;
            i += step;
            
            if (i < distance)
            {
                marker.setPosition(new google.maps.LatLng(lat, lng));
                var heading = google.maps.geometry.spherical.computeHeading(new google.maps.LatLng(lat, lng), dest);
                icon.rotation = heading;
                marker.setIcon(icon);
                map.panTo(new google.maps.LatLng(lat, lng));
                inter = setTimeout(moveMarker, delay);
            }
            else
            {   marker.setPosition(dest);
                map.panTo(dest);
                target++;
                if (target == coords.length){
                    marker.setPosition(new google.maps.LatLng(coords[0]['latitude'], coords[0]['longitude']));
                    map.panTo(new google.maps.LatLng(coords[0]['latitude'], coords[0]['longitude']));
                    target = 0; }
                
                    inter2=setTimeout(goToPoint, delay);
            }
        }
        moveMarker();
    }
    goToPoint();
}