
let tblRuta, tblRuta2;

document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";

    tblRuta2 = $('#tblRuta2').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/rutaC.php?op=listarR",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_ruta' },
            { 'data': 'cod_ruta' },
            { 'data': 'recorrido' },
            { 'data': 'duracion'},
            { "data": "editar" },
            { "data": "eliminar" },
            { "data": "vermapa" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });
    tblRuta = $('#tblRuta').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/rutaC.php?op=listar",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id_ruta' },
            { 'data': 'nombre' },
            { 'data': 'cod_ruta' },
            { 'data': 'recorrido' },
            { "data": "editar" },
            { "data": "eliminar" },
            { "data": "vermapa" }
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });//Fin de la tabla 

    //Fin de la tabla 
    $("#autocomplete").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/empresaC.php?op=buscar",
                dataType: "json",
                type: 'get',
                data: {
                    emp: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('autocomplete').value = ui.item.usuario; // display the selected text
            document.getElementById('idempre').value = ui.item.id; // save selected id to input

        },
    });

    clearTimeout(inter);
    clearTimeout(inter2);
});
function frmRuta() {
    document.getElementById("title").textContent = "Nueva Ruta";
    document.getElementById("btnAccion").textContent = "Registrar";
    //document.getElementById("claves").classList.remove("d-none");
    //document.getElementById("btnAccion").setAttribute('onclick','registrarEmpresa(event);')
    document.getElementById("frmRuta").reset();
    document.getElementById("id").value = "";
    $('#nueva_ruta').modal('show');
}

function registrarRuta(e) {
    e.preventDefault();
    const cod = document.getElementById("cod");
    const recorrido = document.getElementById("recorrido");
    //const clave= document.getElementById("clave");
    //const perfil=document.getElementById("perfil");
    if (cod.value == "" || recorrido.value == "") {
        alertas('Todo los campos son obligatorios', 'warning');
    } else {
        const url = "../control/rutaC.php?op=registrar";
        const frm = document.getElementById("frmRuta");
        const http = new XMLHttpRequest();
        http.open("POST", url, true);
        http.send(new FormData(frm));
        http.onreadystatechange = function () {
            if (this.readyState == 4 && this.status == 200) {
                const res = JSON.parse(this.responseText);
                $("#nueva_ruta").modal("hide");
                alertas(res.msg, res.icono);
                tblRuta.ajax.reload();
                tblRuta2.ajax.reload();

            }
        }
    }
}

function btnEditar(id) {
    document.getElementById("title").innerHTML = "Actualizar Ruta";
    document.getElementById("btnAccion").innerHTML = "Modificar";
    //  document.getElementById("btnAccion").setAttribute('onclick','modificarEmpresa(event);')
    const url = "../control/rutaC.php?op=editar&id=" + id;
    const http = new XMLHttpRequest();
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {
        if (this.readyState == 4 && this.status == 200) {
            const res = JSON.parse(this.responseText);
            console.log(res);
            document.getElementById("id").value = id;
            document.getElementById("cod").value = res.cod_ruta;
            document.getElementById("recorrido").value = res.recorrido;
            document.getElementById('autocomplete').value = res.nombre;
            document.getElementById('idempre').value = res.id_empresa;
            document.getElementById('duracion').value = res.duracion
            // document.getElementById("claves").classList.add("d-none");
            $('#nueva_ruta').modal('show');
        }
    }
}
function btnEliminar(id) {
    Swal.fire({
        title: 'Esta seguro de eliminar?',
        text: "la empresa  no se eliminara de forma permanente, solo cambiará el estado a inactivo!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Si!',
        cancelButtonText: 'No'
    }).then((result) => {
        if (result.isConfirmed) {
            const url = "../control/rutaC.php?op=eliminar&id=" + id;
            const http = new XMLHttpRequest();
            http.open("GET", url, true);
            http.send();
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    document.getElementById("id").value = id;
                    alertas(res.msg, res.icono);
                    tblRuta.ajax.reload();
                    tblRuta2.ajax.reload();
                }
            }

        }
    })
}

function alertas(mensaje, icono) {
    Swal.fire({
       // position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}

var speed = 50; // km/h
var delay = 250;
var icon;
var inter = 0, inter2 = 0;
function btnvermapa(id) {
    initialize();
    var infowindow = new google.maps.InfoWindow({
        content: '',
        size: new google.maps.Size(50, 10)
    });

    var res;
    const http = new XMLHttpRequest();
    const url = "../control/paradaC.php?op=listar2&id=" + id;
    http.open("GET", url, true);
    http.send();
    http.onreadystatechange = function () {

        if (this.readyState == 4 && this.status == 200) {
            res = JSON.parse(this.responseText);

           // console.log(res);

            var arraypos = Array();
            for (var i = 0; i < res.length; i++) {
                cord= new google.maps.LatLng(res[i]['latitud'], res[i]['longitud']);
                arraypos.push(cord); 
                var marker2 = new google.maps.Marker({
                    position: new google.maps.LatLng(res[i]['latitud'], res[i]['longitud']),
                    //icon: icon,
                    map: map
                });
                marker2.setMap(map);
                var contentString = "<h3><span class='glyphicon glyphicon-asterisk' aria-hidden='true'></span>&#160;" + res[i]['descripcion'] + "<br>" + res[i]['direccion'] + "</h3>";
                 (function (marker2, contentString) {

                    google.maps.event.addListener(marker2, 'click', function () {

                        infowindow.setContent(contentString);
                        infowindow.open(map, marker2);

                    });
                })(marker2, contentString);
            }


           
            var line = new google.maps.Polyline({
                path: arraypos,
                strokeColor: "#582EF2",
                strokeOpacity: 0.7,
                strokeWeight: 2,
                
                 
                geodesic: true, //set to false if you want straight line instead of arc
                map: map,
            });
            line.setMap(map);



            var marker;
            var car = "M17.402,0H5.643C2.526,0,0,3.467,0,6.584v34.804c0,3.116,2.526,5.644,5.643,5.644h11.759c3.116,0,5.644-2.527,5.644-5.644 V6.584C23.044,3.467,20.518,0,17.402,0z M22.057,14.188v11.665l-2.729,0.351v-4.806L22.057,14.188z M20.625,10.773 c-1.016,3.9-2.219,8.51-2.219,8.51H4.638l-2.222-8.51C2.417,10.773,11.3,7.755,20.625,10.773z M3.748,21.713v4.492l-2.73-0.349 V14.502L3.748,21.713z M1.018,37.938V27.579l2.73,0.343v8.196L1.018,37.938z M2.575,40.882l2.218-3.336h13.771l2.219,3.336H2.575z M19.328,35.805v-7.872l2.729-0.355v10.048L19.328,35.805z";

            icon = {
                path: car,
                scale: .7,
                strokeColor: 'white',
                strokeWeight: .10,
                fillOpacity: 1,
                fillColor: '#404040',
                offset: '5%',
                anchor: new google.maps.Point(10, 25)
            };


            marker = new google.maps.Marker({
                position: new google.maps.LatLng(res[0]['latitud'], res[0]['longitud']),
                icon: icon,
                map: map
            });
            //  marker.setMap(map);
            google.maps.event.addListenerOnce(map, 'idle', function () {
                animateMarker(marker, res, speed);

            });


        }

        $('#nueva_ruta2').modal('show');



    }

}


function initialize() {

    map = new google.maps.Map(document.getElementById('mapa'), {
        center: new google.maps.LatLng(-16.3990021, -71.5311412),
        zoom: 14,
    });
}

google.maps.event.addDomListener(window, 'load', initialize);


function animateMarker(marker, coords, km_h) {
    var target = 0;
    var km_h = km_h || 50;
    function goToPoint() {
        var lat = marker.position.lat();
        var lng = marker.position.lng();
        var step = (km_h * 1000 * delay) / 360000;
        var dest = new google.maps.LatLng(coords[target]['latitud'], coords[target]['longitud']);
        var distance = google.maps.geometry.spherical.computeDistanceBetween(
            dest, marker.position);
        var numStep = distance / step;
        var i = 0;
        var deltaLat = (coords[target]['latitud'] - lat) / numStep;
        var deltaLng = (coords[target]['longitud'] - lng) / numStep;
        //   console.log(lat);
        // console.log(lng);
        //console.log(step);
        /*  console.log(coords);
         console.log(dest);
         console.log(distance);
         console.log(numStep);*/
        // console.log(deltaLat);
        //console.log(deltaLng);
        function moveMarker() {
       //     var d = new google.maps.LatLng(deltaLat, deltaLng);
            lat += deltaLat;
            lng += deltaLng;
            i += step;
            //    console.log(lat);
            //   console.log( lng);
            console.log(distance);
            //console.log(i);

            if (i < distance) {
                marker.setPosition(new google.maps.LatLng(lat, lng));

                var heading = google.maps.geometry.spherical.computeHeading(new google.maps.LatLng(lat, lng), dest);
                icon.rotation = heading;
                marker.setIcon(icon);
                map.panTo(new google.maps.LatLng(lat, lng));
                //console.log(delay);
                inter = setTimeout(moveMarker, delay);
                //console.log(inter);
            }
            else {
                marker.setPosition(dest);
                map.panTo(dest);
                target++;
                //console.log(target);
                if (target == coords.length) {
                    marker.setPosition(new google.maps.LatLng(coords[0]['latitud'], coords[0]['longitud']));
                    map.panTo(new google.maps.LatLng(coords[0]['latitud'], coords[0]['longitud']));
                    target = 0;
                }
                inter2 = setTimeout(goToPoint, delay);
            }

        } moveMarker();

    } goToPoint();

}

function cerrar() {
    clearTimeout(inter);
    clearTimeout(inter2);
    $("#nueva_ruta2").modal("hide");
    tblRuta.ajax.reload();
    tblRuta2.ajax.reload();

}

