let tblUsuariosEmpr;
document.addEventListener("DOMContentLoaded", function () {
    const buttons = [{
        extend: 'excelHtml5',
        footer: true,
        title: 'Archivo',
        filename: 'Export_File',
        text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
    },
    {
        extend: 'pdfHtml5',
        download: 'open',
        footer: true,
        title: 'Reporte de usuarios',
        filename: 'Reporte de usuarios',
        text: '<span class="badge  bg-danger"><i class="fas fa-file-pdf"></i></span>',
        exportOptions: {
            columns: [0, ':visible']
        }
    },

    {
        extend: 'print',
        footer: true,
        filename: 'Export_File_print',
        text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
    },
    {
        extend: 'csvHtml5',
        footer: true,
        filename: 'Export_File_csv',
        text: '<span class="badge  bg-success"><i class="fas fa-file-csv"></i></span>'
    }, {
        extend: 'colvis',
        text: '<span class="badge  bg-info"><i class="fas fa-columns"></i></span>',
        postfixButtons: ['colvisRestore']
    }
    ]
    const dom = "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-5'i><'col-sm-7'p>>";
   tblUsuariosEmpr = $('#tblUsuariosEmpr').DataTable({
        responsive: true,
        processing: true,
        serverSide: false,
        ajax: {
            url: "../control/empresaC.php?op=listar2",
            dataSrc: ''
        },
        columns: [
            { 'data': 'id' },
            { 'data': 'empresa'},
            { 'data': 'usuario'},
            { 'data': 'nickusuario'},
            { 'data': 'perfil'},
            //{ "data": "eliminar"}
        ],
        language: {
            "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
        },
        dom,
        buttons,
        resonsieve: true,
        bDestroy: true,
        iDisplayLength: 10,
        order: [
            [0, "desc"]
        ]
    });
     $("#autocomplete").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/usuarioC.php?op=buscar",
                dataType: "json",
                type: 'get',
                data: {
                    usu: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('autocomplete').value = ui.item.usuario; // display the selected text
            document.getElementById('idusu').value = ui.item.id; // save selected id to input

        },
    });

     $("#autocomplete2").autocomplete({
        source: function (request, response) {
            $.ajax({
                url: "../control/empresaC.php?op=buscar",
                dataType: "json",
                type: 'get',
                data: {
                    emp: request.term
                },
                success: function (data) {
                    response(data);
                }
            });
        },
        select: function (event, ui) {
            document.getElementById('autocomplete2').value = ui.item.usuario; // display the selected text
            document.getElementById('idempre').value = ui.item.id; // save selected id to input

        },
    });

});
function frmEmpresa() {
    document.getElementById("title").textContent = "Asignar Usuarios a Empresa";
    document.getElementById("btnAccion").textContent = "Registrar";

    document.getElementById("frmEmpresa").reset();
    document.getElementById("id").value = "";
    $('#nuevo_empresa').modal('show');
}

function registrarEmpresa(e) {
    e.preventDefault();
    const idempre = document.getElementById("idempre");
    const idusu= document.getElementById("idusu");
    if (idempre.value == "" || idusu.value == "" ) {
        alertas('Todo los campos son obligatorios', 'warning');
        return false;
    } else {
            const url = "../control/empresaC.php?op=registrar2";
            const frm = document.getElementById("frmEmpresa");
            const http = new XMLHttpRequest();
            http.open("POST", url, true);
            http.send(new FormData(frm));
            http.onreadystatechange = function () {
                if (this.readyState == 4 && this.status == 200) {
                    const res = JSON.parse(this.responseText);
                    $("#nuevo_empresa").modal("hide");
                    alertas(res.msg, res.icono);
                    tblUsuariosEmpr.ajax.reload();
                }
            }
        

    }
}

function alertas(mensaje, icono) {
    Swal.fire({
        //position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    })
}
