<?php
session_start();
require 'conexion/conexion.php';
//require 'config.php'; // Archivo para la conexión a la base de datos

// Verifica si el usuario está logueado
if (!isset($_SESSION['id_usuario'])) {
    header('Location: login.php');
    exit();
}

$id_usuario = $_SESSION['id_usuario'];

// Recupera los datos del formulario
$nombre = $_POST['nombre'];
$apellidos = $_POST['apellidos'];
$correo = $_POST['correo'];
$num_contacto = $_POST['num_contacto'];
$direccion = $_POST['direccion'];
$nickusuario = $_POST['nickusuario'];
$clave = isset($_POST['clave']) ? $_POST['clave'] : '';

// Manejo del archivo de imagen
$foto = $user['foto']; // Valor por defecto si no se sube una nueva imagen

if (isset($_FILES['foto']) && $_FILES['foto']['error'] == UPLOAD_ERR_OK) {
    $img_name = $_FILES['foto']['name'];
    $img_tmp = $_FILES['foto']['tmp_name'];
    $img_path = "../Assets/img/usuario/" . basename($img_name);

    // Mueve la imagen a la carpeta deseada
    if (move_uploaded_file($img_tmp, $img_path)) {
        $foto = $img_name;
    } else {
        echo "Error al subir la imagen.";
        exit();
    }
}

// Encripta la clave si se proporciona
if (!empty($clave)) {
    $clave = hash('sha512', $clave);
    $sql = "UPDATE tc_usuario SET nombre = ?, apellidos = ?, correo = ?, num_contacto = ?, direccion = ?, foto = ?, nickusuario = ?, clave = ? WHERE id_usuario = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$nombre, $apellidos, $correo, $num_contacto, $direccion, $foto, $nickusuario, $clave, $id_usuario]);
} else {
    $sql = "UPDATE tc_usuario SET nombre = ?, apellidos = ?, correo = ?, num_contacto = ?, direccion = ?, foto = ?, nickusuario = ? WHERE id_usuario = ?";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$nombre, $apellidos, $correo, $num_contacto, $direccion, $foto, $nickusuario, $id_usuario]);
}

header('Location: perfil.php'); // Redirige al perfil actualizado
exit();
