<?php
include("../modelo/vehiculo.php");
class VehiculoC extends Vehiculo
{

    function listarV()
    {

        $data = $this->lista();
        $date = date('Y-m-d');
        for ($i = 0; $i < count($data); $i++) {
            $data[$i]['date'] = $date;
            $data[$i]['imagen'] = '<img class="img-thumbnail" src="../Assets/img/vehiculos/' . $data[$i]['img'] . '" width="60">';
            $data[$i]['editar'] = '<button class="btn btn-outline-primary" type="button" onclick="btnEditarVeh(' . $data[$i]['id_vehiculo'] . ');"><i class="fas fa-edit"></i></button>';
            $data[$i]['eliminar'] = '<button class="btn btn-outline-danger" type="button" onclick="btnEliminarVeh(' . $data[$i]['id_vehiculo'] . ');"><i class="fas fa-trash-alt"></i></button>';
        }
        echo json_encode($data);
        die();
    }
    function insertar()
    {
        $placa = $_POST['placa'];
        $codigo = $_POST['codigo'];
        $marca = $_POST['marca'];
        $modelo = $_POST['modelo'];
        $id = $_POST['id'];
        $idpropietario = $_POST['idprop'];
        $idruta = $_POST['idrut'];
        $iddisp = $_POST['disp'];
        $img = $_FILES['imagen'];
        $name = $img['name'];
        $tmpname = $img['tmp_name'];
        $fecha = date("YmdHis");

        if (!empty($name)) {
            $extension = pathinfo($name, PATHINFO_EXTENSION);
            $formatos_permitidos = array('png', 'jpeg', 'jpg');
            $extension = pathinfo($name, PATHINFO_EXTENSION);
            if (!in_array($extension, $formatos_permitidos)) {
                $msg = array('msg' => 'Archivo no permitido', 'icono' => 'warning');
            } else {
                $imgNombre = $fecha . ".jpg";
                $destino = '../Assets/img/vehiculos/' . $imgNombre;

            }
        } elseif (!empty($_POST['foto_actual']) && empty($name)) {
            $imgNombre = $_POST['foto_actual'];
        } else {

            $imgNombre = "default.png";
        }
        if ($id == "") {

            $data = $this->registrar($placa, $modelo, $marca, $imgNombre, $idpropietario, $idruta, $codigo,$iddisp);
            if ($data == "ok") {
                if (!empty($name)) {
                    move_uploaded_file($tmpname, $destino);
                }
                $msg = array('msg' => 'Vehículo registrado con éxito', 'icono' => 'success');
            } elseif ($data == "existe") {
                $msg = array('msg' => 'El Vehículo ya existe', 'icono' => 'warning');
            } else {
                $msg = array('msg' => 'No se pudo registrar el vehículo', 'icono' => 'warning');
            }
        } else {
            if (!empty($name)) {

                $imgDelete = $this->editar($id);
                if ($imgDelete['img'] != 'default.png') {
                    if (file_exists('../Assets/img/vehiculos/' . $imgDelete['img'])) {
                        unlink('../Assets/img/vehiculos/' . $imgDelete['img']);
                    }
                }

            }
            $data = $this->modificar($id, $placa, $modelo, $marca, $imgNombre, $idpropietario, $idruta, $codigo, $iddisp);
            if ($data == "modificado") {
                if (!empty($name)) {
                    move_uploaded_file($tmpname, $destino);
                }
                $msg = array('msg' => 'Vehículo modificado', 'icono' => 'success');
            } else {
                $msg = array('msg' => 'Error al modificar', 'icono' => 'error');
            }
        }

        echo json_encode($msg);
        die();
    }
    function editarV($id)
    {
        $data = $this->editar($id);
        echo json_encode($data);
        die();
    }

    function eliminarV($id)
    {
        $data = $this->eliminar($id);
        if ($data == "eliminado") {
            $msg = array('msg' => ' Vehiculo eliminado', 'icono' => 'success');
        } else {
            $msg = array('msg' => 'Error al eliminar el vehiculo', 'icono' => 'error');
        }
        echo json_encode($msg);
        die();

    }
    function buscarV()
    {
        if (isset($_GET['veh'])) {

            $data = $this->buscar(($_GET['veh']));
            $datos = array();
            foreach ($data as $row) {

                $data['id'] = $row['id_vehiculo'];
                $data['label'] = $row['placa'];
                $data['value'] = $row['placa'];
                array_push($datos, $data);
            }
            echo json_encode($datos);
            die();
        }
    }

    function buscarV2()
    {
        if (isset($_GET['veh'])) {
            session_start();
            $verf = $this->verifiaUsuEmp($_SESSION["session_idusario"]);
            $cont = count($verf);
            if ($cont == 1) {
                foreach ($verf as $col)
                    $data = $this->buscar2(($_GET['veh']), $col["empresa_idempresa"]);
                $datos = array(); foreach ($data as $row) {

                    $data['id'] = $row['id_vehiculo'];
                    $data['label'] = $row['placa'];
                    $data['value'] = $row['placa'];
                    array_push($datos, $data);
                }
            }
            echo json_encode($datos);
            die();
        }
    }
    function listarE()
    {
        session_start();
        $datos = $this->verifiaUsuEmp($_SESSION["session_idusario"]);
        $cont = count($datos);
        if ($cont == 1) {
            foreach ($datos as $row)
                ;
            $data = $this->listaEmp($row["empresa_idempresa"]);
            $date = date('Y-m-d');
            for ($i = 0; $i < count($data); $i++) {
                $data[$i]['date'] = $date;
                $data[$i]['imagen'] = '<img class="img-thumbnail" src="../Assets/img/vehiculos/' . $data[$i]['img'] . '" width="60">';
                $data[$i]['editar'] = '<button class="btn btn-outline-primary" type="button" onclick="btnEditarVeh(' . $data[$i]['id_vehiculo'] . ');"><i class="fas fa-edit"></i></button>';
                $data[$i]['eliminar'] = '<button class="btn btn-outline-danger" type="button" onclick="btnEliminarVeh(' . $data[$i]['id_vehiculo'] . ');"><i class="fas fa-trash-alt"></i></button>';
            }
        }
        echo json_encode($data);
        die();
    }
}
$obj = new VehiculoC;
switch ($_GET['op']) {
    case 'listar':
        $obj->listarV();
        break;
    case 'listar2':
        $obj->listarE();
        break;
    case 'inserta':
        $obj->insertar();
        break;
    case 'editar':
        $obj->editarV($_GET["id"]);
        break;
    case 'eliminar':
        $obj->eliminarV($_GET["id"]);
        break;
    case 'buscar':
        $obj->buscarV();
        break;
    case 'buscar2':
        $obj->buscarV2();
        break;
    default:
        # code...
        break;
}



?>