<?php
include("../conexion/conexion.php");
date_default_timezone_set('America/Lima');
class conexAgua extends db
{
    function listar()
    {
        $sql = "select r.cy_id_recinto,concat(r.pabellon,' ',r.fila,' ',r.columna) as ubicacion, r.cy_id_estado, r.cy_id_difunto, r.cy_id_tipo_recinto, r.dni_difunto,concat(d.nombres_difunto,' ', d.app_difunto, ' ', d.apm_difunto) as difunto
        from cy_recinto r 
        INNER JOIN cy_difunto d ON r.dni_difunto = d.dni_difunto 
        
        
        where r.cy_id_estado=2 ORDER BY r.cy_id_recinto ASC";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        return $data;
    }
    function registrar($pabellon, $fila, $columna, $cy_id_estado, $cy_id_difunto, $cy_id_tipo_recinto, $dni_difunto)
    {
        $sql = "insert into cy_recinto (pabellon, fila, columna, cy_id_estado, cy_id_difunto, cy_id_tipo_recinto, dni_difunto) 
        VALUES(?,?,?,?,?,?,?)";
        $datos = array($pabellon, $fila, $columna, $cy_id_estado, $cy_id_difunto, $cy_id_tipo_recinto, $dni_difunto);
        $result = $this->connect()->prepare($sql);
        if ($result->execute($datos)) {
            $facturacion = $this->listarConNue($DNI);
            foreach ($facturacion as $fac)
                ;
            $dat = $this->registrarprimeraFactura($fac['id'], $fechaInicio, $montoservicio);
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;
    }
    function editar($cy_id_recinto)
    {

        $sql = "select *  from cy_recinto where cy_id_recinto='$cy_id_recinto' ";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetch(PDO::FETCH_ASSOC);
        return $data;

    }
   function modificar($pabellon, $fila, $columna, $cy_id_estado, $cy_id_difunto, $cy_id_tipo_recinto, $cy_id_recinto, $dni_difunto)
    {
        $sql = "update  cy_recinto set pabellon=?,fila=?,columna=?,cy_id_estado=?,cy_id_difunto=?,cy_id_tipo_recinto=?, dni_difunto=? where cy_id_recinto=? ";
        $data = array($pabellon, $fila, $columna, $cy_id_estado, $cy_id_difunto, $cy_id_tipo_recinto, $cy_id_recinto, $dni_difunto);
        $result = $this->connect()->prepare($sql);
        if ($result->execute($data)) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;

    }
    function listarConNue($DNI)
    {
        $sql = "select *  from TConexion where DNI='$DNI'";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        return $data;
    }

    function registrarFactura()
    {
        $sql = "select idconexion, MAX(fechafinal) AS ultima_facturacion,estado,SUM(montopagar) as pago,c.montoservicio
        FROM Tfacturacion  f inner join TConexion c  on c.id=f.idconexion
        where estado=1
        GROUP BY  idconexion";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        for ($i = 0; $i < count($data); $i++) {
            $ultimf=$data[$i]['ultima_facturacion'];
            $conx=$data[$i]['idconexion'];
            $montant=$data[$i]['pago'];
            $montact=$montant+$data[$i]['montoservicio'];
            $sql2 = "select  * from Tfacturacion where fechafinal='$ultimf' and idconexion='$conx' ";
            $result2 = $this->connect()->prepare($sql2);
            $result2->execute();
            $data2 = $result2->fetchAll(PDO::FETCH_ASSOC);
            if(count($data)==0){
                registrarprimeraFactura($conx,$ultimf,$montact);
             
            }


        }
        $fechaFacturacion = '';
        $fechaPago = '';
        $idconexion = '';
        $fechafinal = '';
        $fechainicio = '';
        $estado = '';
        $sql = "insert into Tfacturacion(idconexion,fechaFacturacion,fechaPago,fechainicio,fechafinal,estado) 
        VALUES(?,?,?,?,?,?)";
        $datos = array($idconexion, $fechaFacturacion, $fechaPago, $fechainicio, $fechafinal, $estado);
        $result = $this->connect()->prepare($sql);
        $result->execute($datos);
    }
    function registrarprimeraFactura($idconexion, $fechainicio, $montoservicio)
    {
        $fechafinal = date('Y-m-d', strtotime('+1 month', strtotime($fechainicio)));
        $fechaFacturacion = date('Y-m-d', strtotime('+10 days', strtotime($fechafinal)));
        $fechaPago = date('Y-m-d', strtotime('+15 days', strtotime($fechaFacturacion)));
        //$estado=1;
        $sql = "insert into Tfacturacion(idconexion,fechaFacturacion,fechaPago,fechainicio,fechafinal,montopagar) 
        VALUES(?,?,?,?,?,?)";
        $datos = array($idconexion, $fechaFacturacion, $fechaPago, $fechainicio, $fechafinal, $montoservicio);
        $result = $this->connect()->prepare($sql);
        if ($result->execute($datos)) {
            $res = "ok";
        } else {
            $res = "error";
        }
        return $res;


    }
    function listarfact()
    {

        $sql = "select *,concat(Nombres,' ',ApPaterno,' ',ApMaterno) as titular,f.id as fact,c.id as pcon,concat('Ciclo del ',f.fechainicio,' al ',f.fechafinal) as ciclo    from TConexion c inner join Tfacturacion  f on c.id=f.idconexion  where f.estado=1 and MONTH(f.fechaFacturacion)=MONTH(CURRENT_DATE())";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        return $data;

    }
    function imprimir($id)
    {
        $sql = "select *,concat(Nombres,' ',ApPaterno,' ',ApMaterno) as titular,f.id as fact,c.id as pcon,concat('Ciclo del ',f.fechainicio,' al ',f.fechafinal) as ciclo    
from TConexion c inner join Tfacturacion  f on c.id=f.idconexion where f.id='$id'";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        foreach ($data as $fac)
            ;
        $dat = $this->registrarprimeraFactura($fac['pcon'], $fac['fechafinal'], $fac['montoservicio']);
        return $data;
    }

    function pagar($id)
    {
        $fechaActual = Date('Y-m-d H:i:s');
        $sql = "update Tfacturacion set estado=0 ,regpago='$fechaActual' where id='$id'";
        $result = $this->connect()->prepare($sql);
        if ($result->execute()) {

            $res = "pagado";
        } else {
            $res = "error";
        }
        return $res;

    }

    function listarpagos()
    {

        $sql = "select *,concat(Nombres,' ',ApPaterno,' ',ApMaterno) as titular,f.id as fact,c.id as pcon,concat('Ciclo del ',f.fechainicio,' al ',f.fechafinal) as ciclo    from TConexion c inner join Tfacturacion  f on c.id=f.idconexion  where f.estado=0";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        return $data;

    }

}








?>