<?php
include("../conexion/conexion.php");
class Inngreso extends db
{
    function listar()
    {
        $sql = "select i.id_ingreso, 
         v.placa,
        concat(p.nombre,' ', p.apellidos) as propietario,
         e.nombre as empresa,
         i.cuota,
         i.prestamo,
         i.gps,
         i.ahorro,
         i.evento,
         i.fec_registro
       from tc_ingreso i
         INNER JOIN tc_vehiculo v ON i.id_vehiculo = v.id_vehiculo
         INNER JOIN tc_propietario p ON v.id_propietario = p.id_propietario
         INNER JOIN tc_empres e ON p.id_empresa = e.id_empresa";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $row = $result->fetchAll(PDO::FETCH_ASSOC);
        return $row;
    }
    function registrar($idveh, $cuota, $prestamo, $gps, $ahorro, $evento)
    {
        $sql = "insert into tc_ingreso(id_vehiculo,cuota,prestamo,gps,ahorro,evento) values(?,?,?,?,?,?)";
        $data = array($idveh, $cuota, $prestamo, $gps, $ahorro, $evento);
        $result = $this->connect()->prepare($sql);
        if ($result->execute($data)) {
            $res = "ok";
        } else {
            $res = "error";
        }

        return $res;
    }
    function editar($id)
    {
        $sql = " select i.id_ingreso, 
        v.placa,
        v.id_vehiculo,
       concat(p.nombre, ' ', p.apellidos) as propietario,
        e.nombre as empresa,
        i.cuota,
        i.prestamo,
        i.gps,
        i.ahorro,
        i.evento
      from tc_ingreso i
        INNER JOIN tc_vehiculo v ON i.id_vehiculo = v.id_vehiculo
        INNER JOIN tc_propietario p ON v.id_propietario = p.id_propietario
        INNER JOIN tc_empres e ON p.id_empresa = e.id_empresa where id_ingreso='$id'";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetch(PDO::FETCH_ASSOC);
        return $data;
    }

    function modificar($id, $cuota, $prestamo, $gps, $ahorro, $evento, $idveh, $fechaActual)
    {
        $sql = "update tc_ingreso set id_vehiculo=?,cuota=?,prestamo=?,gps=?,ahorro=?,evento=?,fec_registro=? where id_ingreso=? ";
        $data = array($idveh, $cuota, $prestamo, $gps, $ahorro, $evento, $fechaActual, $id);
        $result = $this->connect()->prepare($sql);
        if ($result->execute($data)) {
            $res = "modificado";
        } else {
            $res = "error";
        }
        return $res;
    }
    function eliminar($id)
    {
        $sql = "delete  from tc_ingreso where id_ingreso='$id' ";
        $result = $this->connect()->prepare($sql);
        if ($result->execute()) {
            $res = "eliminado";
        } else {
            $res = "error";
        }
        return $res;

    }

    function listaringV($id)
    {
        $sql = "select
        i.id_ingreso,
        v.id_vehiculo,
        v.placa,
        concat(p.nombre,' ', p.apellidos) as propietario,
         i.cuota,
         i.prestamo,
         i.gps,
         i.ahorro,
         i.evento,
         i.fec_registro,
         p.id_empresa
       from
         tc_ingreso i
         INNER JOIN tc_vehiculo v ON i.id_vehiculo = v.id_vehiculo
         INNER JOIN tc_propietario p ON v.id_propietario = p.id_propietario
         WHERE p.id_empresa='$id'";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $data = $result->fetchAll(PDO::FETCH_ASSOC);
        return $data;
    }
    function verifiaUsuEmp($id)
    {
        $sql = "select * from usuario_has_empresa where usuario_idusuario='$id'";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $row = $result->fetchAll(PDO::FETCH_ASSOC);
        return $row;
    }

    function imprimir($id)
    {
        $sql = "select
        i.id_ingreso,
        v.id_vehiculo,
        v.codvehiculo,
        v.placa,
        concat(p.nombre,' ', p.apellidos) as propietario,
        p.dni,
         i.cuota,
         i.prestamo,
         i.gps,
         i.ahorro,
         i.evento,
         i.fec_registro,
         p.id_empresa,
         e.nombre
       from
         tc_ingreso i
         INNER JOIN tc_vehiculo v ON i.id_vehiculo = v.id_vehiculo
         INNER JOIN tc_propietario p ON v.id_propietario = p.id_propietario
          INNER JOIN tc_empres e ON p.id_empresa=e.id_empresa WHERE i.id_ingreso='$id'";
        $result = $this->connect()->prepare($sql);
        $result->execute();
        $row = $result->fetchAll(PDO::FETCH_ASSOC);
        return $row;
    }



}

?>