document.addEventListener('DOMContentLoaded', () => {
    const piezas = document.querySelectorAll('.pieza');
    const modal = document.getElementById('modal');
    const span = document.getElementsByClassName('close')[0];
    const formPieza = document.getElementById('formPieza');
    const piezaIdInput = document.getElementById('piezaId');
    const estadoSelect = document.getElementById('estado');
    const tipo = new URLSearchParams(window.location.search).get('tipo');
    const fechaInput = document.getElementById('fecha');
    const horaInput = document.getElementById('hora');
    const nombrePacienteInput = document.getElementById('nombrePaciente');
    const tratamientoSelect = document.getElementById('tratamiento');
    const historialTratamientosDiv = document.getElementById('historialTratamientos');

    piezas.forEach(pieza => {
        pieza.addEventListener('click', () => {
            const id = pieza.getAttribute('data-id');
            const estado = pieza.getAttribute('data-estado');
            piezaIdInput.value = id;
            estadoSelect.value = estado;
            modal.style.display = 'block';

            // Cargar el historial de tratamientos
            fetch(`cargar_historial.php?pieza_id=${id}&tipo=${tipo}`)
                .then(response => response.json())
                .then(data => {
                    historialTratamientosDiv.innerHTML = '';
                    if (data.length > 0) {
                        data.forEach(tratamiento => {
                            const tratamientoDiv = document.createElement('div');
                            tratamientoDiv.innerHTML = `
                                <p>Fecha: ${tratamiento.fecha}</p>
                                <p>Tratamiento: ${tratamiento.nombre}</p>
                                <p>Estado: ${tratamiento.estado}</p>
                                <hr>
                            `;
                            historialTratamientosDiv.appendChild(tratamientoDiv);
                        });
                    } else {
                        historialTratamientosDiv.innerHTML = '<p>No hay tratamientos registrados.</p>';
                    }
                });
        });
    });

    span.onclick = function() {
        modal.style.display = 'none';
    }

    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    }

    formPieza.addEventListener('submit', (e) => {
        e.preventDefault();
        const formData = new FormData(formPieza);
        formData.append('tipo', tipo);
        fetch('guardar_datos.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const id = piezaIdInput.value;
                const estado = estadoSelect.value;
                const pieza = document.querySelector(`.pieza[data-id='${id}']`);
                pieza.setAttribute('data-estado', estado);
                pieza.className = `pieza ${estado}`;
                alert('Datos guardados con éxito');
                modal.style.display = 'none';
            } else {
                alert('Error al guardar los datos');
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    });

    piezas.forEach(pieza => {
        const estado = pieza.getAttribute('data-estado');
        pieza.className = `pieza ${estado}`;
    });
});

