<?php
require("../vista/menu.php");
$tipo = $_GET['tipo'] ?? 'adulto';

// Piezas dentales para niño y adulto
$piezas_nino = [51, 52, 53, 54, 55, 61, 62, 63, 64, 65, 71, 72, 73, 74, 75, 81, 82, 83, 84, 85];
$piezas_adulto = [11, 12, 13, 14, 15, 16, 17, 18, 21, 22, 23, 24, 25, 26, 27, 28, 31, 32, 33, 34, 35, 36, 37, 38, 41, 42, 43, 44, 45, 46, 47, 48];
$piezas = ($tipo == 'nino') ? $piezas_nino : $piezas_adulto;

// Conexión a la base de datos
$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Consulta para obtener el estado de las piezas dentales
$sql = "SELECT pieza_id, estado FROM piezas WHERE tipo='$tipo'";
$result = $conn->query($sql);

$estadosPiezas = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $estadosPiezas[$row['pieza_id']] = $row['estado'];
    }
}

// Consulta para obtener los tratamientos
$sqlTratamientos = "SELECT tratamiento_id, nombre FROM tratamientos";
$resultTratamientos = $conn->query($sqlTratamientos);

$tratamientos = [];

if ($resultTratamientos->num_rows > 0) {
    while($row = $resultTratamientos->fetch_assoc()) {
        $tratamientos[] = $row;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Odontograma Interactivo</title>
    <link rel="stylesheet" href="css/estilos.css">
</head>
<body>
    <div class="odontograma">
        <?php foreach ($piezas as $pieza): ?>
            <div class="pieza <?= $estadosPiezas[$pieza] ?? 'sano' ?>" data-id="<?= $pieza ?>" data-estado="<?= $estadosPiezas[$pieza] ?? 'sano' ?>">
                <?= $pieza ?>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Modal para editar información de la pieza dental -->
    <div id="modal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <form id="formPieza">
                <label for="estado">Estado:</label>
                <select id="estado" name="estado">
                    <option value="sano">Sano</option>
                    <option value="cariado">Cariado</option>
                    <option value="ausente">Ausente</option>
                </select>
                <input type="hidden" id="piezaId" name="piezaId">

                <h3>Agendar Cita</h3>
                <label for="fecha">Fecha:</label>
                <input type="date" id="fecha" name="fecha" required>
                <label for="hora">Hora:</label>
                <input type="time" id="hora" name="hora" required>
                <label for="nombrePaciente">Nombre del Paciente:</label>
                <input type="text" id="nombrePaciente" name="nombrePaciente" required>

                <label for="tratamiento">Tipo de Tratamiento:</label>
                <select id="tratamiento" name="tratamiento" required>
                    <?php foreach ($tratamientos as $tratamiento): ?>
                        <option value="<?= $tratamiento['tratamiento_id'] ?>"><?= $tratamiento['nombre'] ?></option>
                    <?php endforeach; ?>
                </select>

                <button type="submit">Guardar</button>
            </form>

            <h3>Historial de Tratamientos</h3>
            <div id="historialTratamientos"></div>
        </div>
    </div>

    <script src="js/script.js"></script>
</body>
</html>
