<?php
session_start();

// Configuración de la base de datos
$host = 'exdb.telconetperu.pe';  // Cambia esto si tu base de datos está en un servidor diferente
$db = 'dental';  // Cambia esto por el nombre de tu base de datos
$user = 'user_dental';  // Cambia esto por tu nombre de usuario de la base de datos
$pass = '@lba$102979';  // Cambia esto por tu contraseña de la base de datos

try {
    $conn = new PDO("mysql:host=$host;dbname=$db;charset=utf8", $user, $pass);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

// Verifica si el usuario está logueado
//if (!isset($_SESSION['id_usuario'])) {
//    header('Location: login.php');
//    exit();
//}

require("menu.php");
if (!isset($_SESSION['session_idusario'])) {
    header('Location:../index.php');
}


$id_usuario = $_SESSION['session_idusario'];
$mensaje = '';

// Procesa el formulario cuando se envía
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'];
    $apellidos = $_POST['apellidos'];
    $correo = $_POST['correo'];
    $num_contacto = $_POST['num_contacto'];
    $direccion = $_POST['direccion'];
    $nickusuario = $_POST['nickusuario'];
    $nomb_clinica = $_POST['nomb_clinica'];
    $colegiatura = $_POST['colegiatura'];
    $clave = isset($_POST['clave']) ? $_POST['clave'] : '';

    // Manejo del archivo de imagen
    $foto = ''; // Inicialmente vacío si no hay foto nueva
    if (isset($_FILES['foto']) && $_FILES['foto']['error'] == UPLOAD_ERR_OK) {
        $img_name = $_FILES['foto']['name'];
        $img_tmp = $_FILES['foto']['tmp_name'];
        $img_path = "../Assets/img/usuario/" . basename($img_name);

        // Mueve la imagen a la carpeta deseada
        if (move_uploaded_file($img_tmp, $img_path)) {
            $foto = $img_name;
        } else {
            $mensaje = "Error al subir la imagen.";
        }
    }

    // Encripta la clave si se proporciona
    if (!empty($clave)) {
        $clave = hash('sha512', $clave);
        $sql = "UPDATE tc_usuario SET nombre = ?, apellidos = ?, correo = ?, num_contacto = ?, direccion = ?, foto = ?, nickusuario = ?, clave = ?, nomb_clinica = ?, colegiatura = ? WHERE id_usuario = ?";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$nombre, $apellidos, $correo, $num_contacto, $direccion, $foto, $nickusuario, $clave, $nomb_clinica, $colegiatura, $id_usuario]);
    } else {
        $sql = "UPDATE tc_usuario SET nombre = ?, apellidos = ?, correo = ?, num_contacto = ?, direccion = ?, foto = ?, nickusuario = ?, nomb_clinica = ?, colegiatura = ? WHERE id_usuario = ?";
        $stmt = $conn->prepare($sql);
        $stmt->execute([$nombre, $apellidos, $correo, $num_contacto, $direccion, $foto, $nickusuario, $nomb_clinica, $colegiatura, $id_usuario]);
    }

    $mensaje = "Perfil actualizado con éxito.";
}

// Obtén los datos del usuario
$sql = "SELECT * FROM tc_usuario WHERE id_usuario = ?";
$stmt = $conn->prepare($sql);
$stmt->execute([$id_usuario]);
$user = $stmt->fetch();

if (!$user) {
    echo "Usuario no encontrado.";
    exit();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Actualizar Perfil</title>
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container">
     
        <?php if ($mensaje): ?>
            <div class="alert alert-info" role="alert">
                <?php echo htmlspecialchars($mensaje); ?>
            </div>
        <?php endif; ?>

        <form action="" method="POST" enctype="multipart/form-data">
            <div class="form-group">
               
                <?php if ($user['foto']): ?>
                    <div>
                        <img src="../Assets/img/usuario/<?php echo htmlspecialchars($user['foto']); ?>" alt="Foto de perfil" class="img-fluid mb-3" style="max-height: 200px;">
                    </div>
                <?php endif; ?>
                <input type="file" class="form-control-file" id="foto" name="foto">
            </div>
            <div class="form-group">
                <label for="nombre">Nombre</label>
                <input type="text" class="form-control" id="nombre" name="nombre" value="<?php echo htmlspecialchars($user['nombre']); ?>" required>
            </div>
            <div class="form-group">
                <label for="apellidos">Apellidos</label>
                <input type="text" class="form-control" id="apellidos" name="apellidos" value="<?php echo htmlspecialchars($user['apellidos']); ?>" required>
            </div>
            <div class="form-group">
                <label for="correo">Correo electrónico</label>
                <input type="email" class="form-control" id="correo" name="correo" value="<?php echo htmlspecialchars($user['correo']); ?>" required>
            </div>
            <div class="form-group">
                <label for="num_contacto">Número de contacto</label>
                <input type="text" class="form-control" id="num_contacto" name="num_contacto" value="<?php echo htmlspecialchars($user['num_contacto']); ?>" required>
            </div>
            <div class="form-group">
                <label for="direccion">Dirección</label>
                <input type="text" class="form-control" id="direccion" name="direccion" value="<?php echo htmlspecialchars($user['direccion']); ?>" required>
            </div>
            <div class="form-group">
                <label for="nickusuario">Nick de usuario</label>
                <input type="text" class="form-control" id="nickusuario" name="nickusuario" value="<?php echo htmlspecialchars($user['nickusuario']); ?>" required>
            </div>
            <div class="form-group">
                <label for="nomb_clinica">Nombre de la clínica</label>
                <input type="text" class="form-control" id="nomb_clinica" name="nomb_clinica" value="<?php echo htmlspecialchars($user['nomb_clinica']); ?>">
            </div>
             <div class="form-group">
                <label for="colegiatura">Colegiatura</label>
                <input type="text" class="form-control" id="colegiatura" name="colegiatura" value="<?php echo htmlspecialchars($user['colegiatura']); ?>">
            </div>
            <div class="form-group">
                <label for="clave">Clave</label>
                <input type="password" class="form-control" id="clave" name="clave">
                <small class="form-text text-muted">Deja en blanco si no deseas cambiar la clave.</small>
            </div>
            <button type="submit" class="btn btn-primary">Actualizar</button>
        </form>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
