<?php
session_start();
$today = date('Y-m-d');
require("menu.php");
$mysqli = new mysqli('exdb.telconetperu.pe','user_dental',  '@lba$102979', 'dental');
$_SESSION["session_idusario"];
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Pacientes</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- DataTables CSS -->
    <link href="../Assets/DataTables/datatables.min.css" rel="stylesheet">
</head>
<body>

<div class="container-fluid">
    <button class="btn btn-outline-primary mb-2" type="button" id="btnNuevoPaciente">
        <i class="fas fa-plus"></i> Nuevo Paciente
    </button>
    
    <div class="card">
        <div class="card-header bg-orange text-white">
            Registro Paciente 
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover display responsive nowrap" id="tblpropietario" style="width: 99%;">
                    <thead class="bg-orange text-white">
                        <tr>
                            <th>Nombres</th>
                            <th>Dni</th>
                            <th>Telefono</th>
                            <th maxlength="12">Motivo Consulta</th>
                            <th maxlength="12">Odontog</th>
                            <th>Foto</th>
                            <th>Placa</th>
                            <th>Acciones</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Los datos se cargarán via AJAX -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal para nuevo paciente -->
<div class="modal fade" id="nuevo_propietariovivienda" tabindex="-1" aria-labelledby="modalTitle" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-orange text-white">
                <h5 class="modal-title" id="modalTitle">Nuevo Paciente</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="frmPropietarioVivienda" autocomplete="off" enctype="multipart/form-data">
                <div class="modal-body ui-front">
                    <div class="alert alert-orange d-flex align-items-center" role="alert">
                        <div>Todo los campos con <span class="text-danger fw-bold">*</span> son obligatorios.</div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <input type="hidden" id="id" name="id">
                                <input id="Nombres" class="form-control" type="text" name="Nombres" placeholder="Nombre del Paciente" pattern="^[a-zA-Z Ññ]+$" required>
                                <label for="Nombres"><i class="fas fa-list"></i> Nombres <span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <input id="DNI" class="form-control" name="DNI" placeholder="DNI" required pattern="((\d{8}))" title="Debe contener 8 dígitos">
                                <label for="DNI"><i class="fas fa-id-card"></i> Num.DNI<span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <input id="Celular" class="form-control" name="Celular" placeholder="Teléfono" required maxlength="9" pattern="[0-9]+">
                                <label for="Celular"><i class="fas fa-phone"></i> Num.Contacto <span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <input id="ApMaterno" class="form-control" type="text" name="ApMaterno" placeholder="Direccion" required>
                                <label for="ApMaterno"><i class="fas fa-list"></i> Direccion <span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <input id="identificador" class="form-control" name="identificador">
                                <label for="identificador"><i class="fas fa-home"></i> En caso de emergencia o Apoderado</label>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-floating mb-3">
                                <textarea id="Direccion" name="Direccion" class="form-control" rows="4" cols="40"></textarea>    
                                <label for="Direccion"><i class="fas fa-home"></i> Motivo Consulta y afección al ingresar</label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <select class="form-control" id="utilidad" name="utilidad">
                                    <option value="1">Activo</option>
                                    <option value="2">Anulado</option>
                                    <option value="3">Suspendido</option>
                                </select>
                                <label for="utilidad"><i class="fas fa-barcode"></i> Estado <span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <select class="form-control" id="montoservicio" name="montoservicio" required>
                                    <option value="0">Seleccione..</option>
                                    <option value="nino">Niño</option>
                                    <option value="adulto">Adulto</option>
                                </select>
                                <label for="montoservicio"><i class="fas fa-barcode"></i> Odontograma <span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <div class="form-floating mb-3">
                                <select class="form-control" id="ApPaterno" name="ApPaterno">
                                    <option value="0">Seleccione:</option>
                                    <?php
                                    $ident = $_SESSION["session_idusario"];
                                    $query = $mysqli->query("SELECT * FROM propietario WHERE identificador = ".$ident);
                                    while ($valores = mysqli_fetch_array($query)) {
                                        echo '<option value="'.$valores['id'].'">'.$valores['Nombres'].'</option>';
                                    }
                                    ?>
                                </select>
                                <label for="ApPaterno"><i class="fas fa-barcode"></i> Doctor <span class="text-danger fw-bold">*</span></label>
                            </div>
                            
                            <!-- Campos ocultos -->
                            <input type="hidden" id="fechaInicio" name="fechaInicio" value="<?php echo $today; ?>">
                            <input type="hidden" id="EstadoCivil" name="EstadoCivil" value="0">
                            <input type="hidden" id="fecha_encargado" name="fecha_encargado" value="2000-01-01">
                            <input type="hidden" id="categoria" name="categoria" value="<?php echo $_SESSION["session_idusario"]; ?>">
                            <input type="hidden" id="imagen_url" name="imagen_url">
                            <input type="hidden" id="imagen_url1" name="imagen_url1">
                            <input type="hidden" id="imagen" name="imagen">
                            <input type="hidden" id="imagen1" name="imagen1">
                            <input type="hidden" id="adelanto_encargado" name="adelanto_encargado">
                            <input type="hidden" id="Genero" name="Genero">
                            <input type="hidden" id="entrega_material" name="entrega_material">
                            <input type="hidden" id="id_estado" name="id_estado" value="1">
                            <input type="hidden" id="marca" name="marca">
                            <input type="hidden" id="modelo" name="modelo">
                            <input type="hidden" id="placa" name="placa">
                            <input type="hidden" id="color" name="color">
                            <input type="hidden" id="anio" name="anio">
                            <input type="hidden" id="fechaIniBrevet" name="fechaIniBrevet">
                            <input type="hidden" id="fechaFinBrevet" name="fechaFinBrevet">
                            <input type="hidden" id="fechaIniReviTec" name="fechaIniReviTec">
                            <input type="hidden" id="fechaFinReviTec" name="fechaFinReviTec">
                            <input type="hidden" id="fechaIniSoat" name="fechaIniSoat">
                            <input type="hidden" id="fechaFinSoat" name="fechaFinSoat">
                            <input type="hidden" id="fechaIniSetare" name="fechaIniSetare">
                            <input type="hidden" id="fechaFinSetare" name="fechaFinSetare">
                            <input type="hidden" id="dia_plaqueo" name="dia_plaqueo">
                        </div>
                    </div>
                </div>
 <div class="modal-footer">
                    <button class="btn btn-primary" type="submit" id="btnAccion">Registrar</button>
                    <button class="btn btn-outline-danger" type="button" data-bs-dismiss="modal">
                        <i class="fas fa-times-circle"></i> Cancelar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Todos los scripts al final del body -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.68/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.68/vfs_fonts.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.4.0/jspdf.umd.min.js"></script>
<script src="../Assets/js/jquery-3.6.0.min.js"></script>
<script src="../Assets/js/jquery-ui.min.js"></script>
<script src="../Assets/DataTables/datatables.min.js"></script>
<script src="../Assets/js/scripts.js"></script>
<script src="../Assets/js/sweetalert2.all.min.js"></script>

<!-- Script principal con todas las funciones -->
<script>
// Esperar a que el DOM esté completamente cargado
document.addEventListener("DOMContentLoaded", function() {
    // Asignar el evento click al botón después de que exista
    document.getElementById("btnNuevoPaciente").addEventListener("click", frmPropietarioVivienda);
    
    // Definir la función para mostrar el modal
    function frmPropietarioVivienda() {
        try {
            // Verificar que los elementos existen
            const titleElement = document.getElementById("modalTitle");
            const btnAccionElement = document.getElementById("btnAccion");
            const formElement = document.getElementById("frmPropietarioVivienda");
            
            if (!titleElement || !btnAccionElement || !formElement) {
                throw new Error("No se encontraron todos los elementos requeridos");
            }
            
            // Configurar el modal
            titleElement.textContent = "Nuevo Paciente";
            btnAccionElement.textContent = "Registrar";
            formElement.reset();
            document.getElementById("id").value = "";
            
            // Mostrar el modal con jQuery
            if (typeof jQuery === 'undefined') {
                throw new Error("jQuery no está cargado");
            }
            
            $('#nuevo_propietariovivienda').modal('show');
            
        } catch (error) {
            console.error("Error en frmPropietarioVivienda:", error);
            alert("Ocurrió un error al intentar abrir el formulario");
        }
    }
    
    // Hacer la función accesible globalmente si es necesario
    window.frmPropietarioVivienda = frmPropietarioVivienda;
    
    // Configuración inicial de DataTables
    if (typeof $.fn.DataTable === 'function') {
        const tblpropietario = $('#tblpropietario').DataTable({
            responsive: true,
            processing: true,
            serverSide: false,
            ajax: {
                url: "../control/connaguaC.php?op=listar",
                dataSrc: ''
            },
            columns: [
                { 'data': 'Nombres', 'width': '5px' },
                { 'data': 'DNI', 'width': '5px' },
                { 'data': 'Celular', 'width': '5px' },
                { 'data': 'Direccion', 'width': '5px' },
                { 'data': 'montoservicio', 'width': '10px' },
                { 'data': 'img', 'width': '10px' },
                { 'data': 'img1', 'width': '10px' },
                { "data": "opciones", 'width': '10px' },
                { "data": 'Estado', 'width': '5px' }
            ],
            language: {
                "url": "//cdn.datatables.net/plug-ins/1.10.11/i18n/Spanish.json"
            },
            dom: "<'row'<'col-sm-4'l><'col-sm-4 text-center'B><'col-sm-4'f>>" +
                 "<'row'<'col-sm-12'tr>>" +
                 "<'row'<'col-sm-5'i><'col-sm-6'p>>",
            buttons: [
                {
                    extend: 'excelHtml5',
                    footer: true,
                    title: 'Archivo',
                    filename: 'Export_File',
                    text: '<span class="badge bg-success"><i class="fas fa-file-excel"></i></span>'
                },
                {
                    extend: 'pdfHtml5',
                    download: 'open',
                    footer: true,
                    title: 'Reporte',
                    filename: 'Reporte de usuarios',
                    text: '<span class="badge bg-danger"><i class="fas fa-file-pdf"></i></span>'
                },
                {
                    extend: 'print',
                    footer: true,
                    filename: 'Export_File_print',
                    text: '<span class="badge bg-dark"><i class="fas fa-print"></i></span>'
                },
                {
                    extend: 'colvis',
                    text: '<span class="badge bg-info"><i class="fas fa-columns"></i></span>'
                }
            ],
            bDestroy: true,
            iDisplayLength: 100,
            order: [[4, "asc"]]
        });
    } else {
        console.error("DataTables no está cargado correctamente");
    }
});

// Función para mostrar alertas
function alertas(mensaje, icono) {
    Swal.fire({
        position: 'top-end',
        icon: icono,
        title: mensaje,
        showConfirmButton: false,
        timer: 1000
    });
}

// Función para registrar un paciente
function registrarPropietario(e) {
    e.preventDefault();
    
    const DNI = document.getElementById("DNI");
    const Nombres = document.getElementById("Nombres");
    
    if (DNI.value == "" || Nombres.value == "") {
        alertas('Todos los campos son obligatorios', 'warning');
        return;
    }
    
    const url = "../control/connaguaC.php?op=registrar";
    const frm = document.getElementById("frmPropietarioVivienda");
    const http = new XMLHttpRequest();
    
    http.open("POST", url, true);
    http.onreadystatechange = function() {
        if (this.readyState == 4) {
            if (this.status == 200) {
                try {
                    const res = JSON.parse(this.responseText);
                    $("#nuevo_propietariovivienda").modal("hide");
                    alertas(res.msg, res.icono);
                    
                    // Recargar la tabla si existe
                    if (typeof tblpropietario !== 'undefined' && typeof tblpropietario.ajax.reload === 'function') {
                        tblpropietario.ajax.reload();
                    }
                } catch (e) {
                    console.error("Error al parsear respuesta:", e);
                    alertas('Error al procesar la respuesta del servidor', 'error');
                }
            } else {
                alertas('Error en la conexión con el servidor', 'error');
            }
        }
    };
    
    http.send(new FormData(frm));
}
</script>

<!-- Cargar el resto de funciones desde fconagua.js -->
<script src="../Assets/js/fconagua.js" type="text/javascript"></script>

</body>
</html>
