<?php
session_start();
require("menu.php");

// Incluir la biblioteca FPDF
require('fpdf/fpdf.php');

// Datos de conexión a la base de datos
$host = 'exdb.telconetperu.pe'; // o la IP de tu servidor de base de datos
$db = 'dental';
$user = 'user_dental';
$pass = '@lba$102979';

// Crear conexión
$conn = new mysqli($host, $user, $pass, $db);

// Verificar la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

$tipo = $_GET['tipo'] ?? 'adulto';
$id = $_GET['id'] ?? null;
$nombre = $_GET['nombre'] ?? null;

if ($id) {
    $uploadsDir = __DIR__ . '/uploads';
    $directorio = $uploadsDir . '/' . htmlspecialchars($id);

    // Verifica si el directorio uploads existe
    if (!file_exists($uploadsDir)) {
        if (!mkdir($uploadsDir, 0777, true)) {
            die("Error al crear el directorio principal 'uploads'.");
        }
    }

    // Verifica si el directorio específico del ID ya existe
    if (!file_exists($directorio)) {
        if (!mkdir($directorio, 0777, true)) {
            die("Error al crear el directorio para el ID.");
        }
    }

    // Subida de archivo
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['generate_pdf'])) {
        // Sanitizar y obtener datos del formulario
        $descripcion = $conn->real_escape_string($_POST['descripcion']);
        $id_paciente = $conn->real_escape_string($_POST['id_paciente']);
        
        if (isset($_FILES['image'])) {
            $imagen = $_FILES['image'];
            $nombreArchivo = basename($imagen['name']);
            $rutaArchivo = $directorio . '/' . $nombreArchivo;
            $extencionArchivo = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));
            $tiposPermitidos = ['jpg', 'jpeg', 'png', 'gif'];

            // Verifica si hubo errores en la subida
            if ($imagen['error'] === UPLOAD_ERR_OK) {
                // Verifica la extensión del archivo
                if (in_array($extencionArchivo, $tiposPermitidos)) {
                    // Mueve el archivo subido a la carpeta deseada
                    if (move_uploaded_file($imagen['tmp_name'], $rutaArchivo)) {
                        echo "<div class='alert alert-success'>Imagen subida con éxito.</div>";

                        // Preparar la consulta SQL para insertar datos en la base de datos
                        $sql = "INSERT INTO rx (ruta, descripcion, fecha, id_paciente) VALUES (?, ?, NOW(), ?)";
                        $stmt = $conn->prepare($sql);
                        
                        if ($stmt === false) {
                            die("Error en la preparación de la consulta: " . $conn->error);
                        }

                        $stmt->bind_param('sss', $rutaArchivo, $descripcion, $id_paciente);

                        if ($stmt->execute()) {
                            echo "<div class='alert alert-success'>Registro guardado en la base de datos.</div>";
                        } else {
                            echo "<div class='alert alert-danger'>Error al guardar en la base de datos: " . $stmt->error . "</div>";
                        }

                        $stmt->close();
                    } else {
                        echo "<div class='alert alert-danger'>Error al mover la imagen.</div>";
                    }
                } else {
                    echo "<div class='alert alert-danger'>Tipo de archivo no permitido. Solo se permiten imágenes JPG, JPEG, PNG y GIF.</div>";
                }
            } else {
                echo "<div class='alert alert-danger'>Error en la subida de la imagen.</div>";
            }
        }
    } elseif (isset($_POST['generate_pdf'])) {
        // Generar el PDF
        $pdf = new FPDF();
        $pdf->AddPage();
        $pdf->SetFont('Arial', '', 12);

        foreach ($imagenesDatos as $data) {
            $pdf->Cell(0, 10, 'Descripción: ' . htmlspecialchars($data['descripcion']), 0, 1);
            $pdf->Image(__DIR__ . '/uploads/' . htmlspecialchars($id) . '/' . basename($data['ruta']), 10, $pdf->GetY(), 100);
            $pdf->Ln(10);
        }

        $pdfOutputPath = __DIR__ . '/uploads/' . htmlspecialchars($id) . '/reporte.pdf';
        $pdf->Output('F', $pdfOutputPath);

        // Redirigir al usuario al archivo PDF generado
        header('Location: /sisdent/vista/uploads/' . htmlspecialchars($id) . '/reporte.pdf');
        exit;
    }
} else {
    echo "<div class='alert alert-warning'>No se ha recibido ningún ID.</div>";
}

// Obtener imágenes y descripciones para el carrusel
$imagenesDatos = [];
if ($id) {
    $sql = "SELECT ruta, descripcion FROM rx WHERE id_paciente = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $id);
    $stmt->execute();
    $resultado = $stmt->get_result();

    while ($row = $resultado->fetch_assoc()) {
        $imagenesDatos[] = $row;
    }

    $stmt->close();
}

// Cerrar conexión
$conn->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Subir Imágenes</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .carousel-caption {
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            padding: 1rem;
            background: rgba(0, 0, 0, 0.5);
            color: #fff;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <h1>Subir Imagen</h1>
        <form action="" method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label for="image">Selecciona una imagen:</label>
                <input type="file" name="image" id="image" class="form-control-file" required>
            </div>
            <div class="form-group">
                <label for="descripcion">Descripción:</label>
                <textarea id="descripcion" name="descripcion" class="form-control" rows="4" required></textarea>
            </div>
            <input type="hidden" name="id_paciente" value="<?php echo htmlspecialchars($id); ?>">
            <button type="submit" class="btn btn-primary">Subir Imagen</button>
        </form>

        <h2 class="mt-4">Imágenes Subidas</h2>
        <button class="btn btn-info" data-toggle="modal" data-target="#imageModal">Ver Imágenes</button>
        <a href="reporte_img.php?id=<?php echo htmlspecialchars($id); ?>" class="btn btn-success mt-2" target="_blank">Generar PDF</a>


        <!-- Modal para la galería de imágenes -->
        <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="imageModalLabel">Galería de Imágenes</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div id="carouselExampleIndicators" class="carousel slide">
                            <ol class="carousel-indicators">
                                <?php foreach ($imagenesDatos as $index => $data): ?>
                                    <li data-target="#carouselExampleIndicators" data-slide-to="<?php echo $index; ?>" class="<?php echo $index === 0 ? 'active' : ''; ?>"></li>
                                <?php endforeach; ?>
                            </ol>
                            <div class="carousel-inner">
                                <?php foreach ($imagenesDatos as $index => $data): ?>
                                    <div class="carousel-item <?php echo $index === 0 ? 'active' : ''; ?>">
                                        <img src="/sisdent/vista/uploads/<?php echo htmlspecialchars($id); ?>/<?php echo basename($data['ruta']); ?>" class="d-block w-100" alt="Imagen">
                                        <div class="carousel-caption d-none d-md-block">
                                            <p><?php echo htmlspecialchars($data['descripcion']); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="sr-only">Previous</span>
                            </a>
                            <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="sr-only">Next</span>
                            </a>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>

