<?php
require_once 'conexion/conexion.php';

$action = $_GET['action'] ?? '';
$db = new db();
$conexion = $db->connect();

header('Content-Type: application/json');

switch ($action) {
    case 'listar':
        listarRegistros($conexion);
        break;
    case 'registrar':
        registrarRegistro($conexion);
        break;
    case 'actualizar':
        actualizarRegistro($conexion);
        break;
    case 'eliminar':
        eliminarRegistro($conexion);
        break;
    case 'obtener':
        obtenerRegistro($conexion);
        break;
    default:
        echo json_encode(['success' => false, 'message' => 'Acción no válida']);
        break;
}

function listarRegistros($conexion) {
    $query = "SELECT id, CONCAT(Nombres, ' ', ApPaterno, ' ', ApMaterno) as Nombres, 
              CONCAT(ApPaterno, ' ', ApMaterno) as Apellidos, DNI, Direccion, Celular, 
              marca, modelo, placa, id_estado FROM TConexion";
    $stmt = $conexion->prepare($query);
    $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($result);
}

function registrarRegistro($conexion) {
    try {
        // Procesar imágenes si se subieron
        $imagen_url = procesarImagen('imagen');
        $imagen_url1 = procesarImagen('imagen1');
        
        $query = "INSERT INTO TConexion (
            Nombres, ApPaterno, ApMaterno, DNI, Direccion, Celular, EstadoCivil, Genero, 
            marca, modelo, placa, color, anio, fechaIniBrevet, fechaFinBrevet, 
            fechaIniReviTec, fechaFinReviTec, dia_plaqueo, id_estado, imagen, imagen_url, 
            imagen1, imagen_url1, fechaInicio, categoria
        ) VALUES (
            :Nombres, :ApPaterno, :ApMaterno, :DNI, :Direccion, :Celular, :EstadoCivil, :Genero, 
            :marca, :modelo, :placa, :color, :anio, :fechaIniBrevet, :fechaFinBrevet, 
            :fechaIniReviTec, :fechaFinReviTec, :dia_plaqueo, :id_estado, :imagen, :imagen_url, 
            :imagen1, :imagen_url1, NOW(), :categoria
        )";
        
        $stmt = $conexion->prepare($query);
        $stmt->bindParam(':Nombres', $_POST['Nombres']);
        $stmt->bindParam(':ApPaterno', $_POST['ApPaterno']);
        $stmt->bindParam(':ApMaterno', $_POST['ApMaterno']);
        $stmt->bindParam(':DNI', $_POST['DNI']);
        $stmt->bindParam(':Direccion', $_POST['Direccion']);
        $stmt->bindParam(':Celular', $_POST['Celular']);
        $stmt->bindParam(':EstadoCivil', $_POST['EstadoCivil']);
        $stmt->bindParam(':Genero', $_POST['Genero']);
        $stmt->bindParam(':marca', $_POST['marca']);
        $stmt->bindParam(':modelo', $_POST['modelo']);
        $stmt->bindParam(':placa', $_POST['placa']);
        $stmt->bindParam(':color', $_POST['color']);
        $stmt->bindParam(':anio', $_POST['anio']);
        $stmt->bindParam(':fechaIniBrevet', $_POST['fechaIniBrevet']);
        $stmt->bindParam(':fechaFinBrevet', $_POST['fechaFinBrevet']);
        $stmt->bindParam(':fechaIniReviTec', $_POST['fechaIniReviTec']);
        $stmt->bindParam(':fechaFinReviTec', $_POST['fechaFinReviTec']);
        $stmt->bindParam(':dia_plaqueo', $_POST['dia_plaqueo']);
        $stmt->bindParam(':id_estado', $_POST['id_estado']);
        $stmt->bindParam(':imagen', $_POST['imagen']);
        $stmt->bindParam(':imagen_url', $imagen_url);
        $stmt->bindParam(':imagen1', $_POST['imagen1']);
        $stmt->bindParam(':imagen_url1', $imagen_url1);
        $stmt->bindParam(':categoria', $_SESSION['session_idusario']);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Registro creado exitosamente']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al crear el registro']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
    }
}

function actualizarRegistro($conexion) {
    try {
        // Obtener el registro actual para las imágenes
        $query = "SELECT imagen_url, imagen_url1 FROM TConexion WHERE id = :id";
        $stmt = $conexion->prepare($query);
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->execute();
        $registro = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Procesar imágenes si se subieron
        $imagen_url = !empty($_FILES['imagen']['name']) ? procesarImagen('imagen') : $registro['imagen_url'];
        $imagen_url1 = !empty($_FILES['imagen1']['name']) ? procesarImagen('imagen1') : $registro['imagen_url1'];
        
        $query = "UPDATE TConexion SET 
            Nombres = :Nombres, 
            ApPaterno = :ApPaterno, 
            ApMaterno = :ApMaterno, 
            DNI = :DNI, 
            Direccion = :Direccion, 
            Celular = :Celular, 
            EstadoCivil = :EstadoCivil, 
            Genero = :Genero, 
            marca = :marca, 
            modelo = :modelo, 
            placa = :placa, 
            color = :color, 
            anio = :anio, 
            fechaIniBrevet = :fechaIniBrevet, 
            fechaFinBrevet = :fechaFinBrevet, 
            fechaIniReviTec = :fechaIniReviTec, 
            fechaFinReviTec = :fechaFinReviTec, 
            dia_plaqueo = :dia_plaqueo, 
            id_estado = :id_estado,
            imagen = :imagen,
            imagen_url = :imagen_url,
            imagen1 = :imagen1,
            imagen_url1 = :imagen_url1
            WHERE id = :id";
        
        $stmt = $conexion->prepare($query);
        $stmt->bindParam(':Nombres', $_POST['Nombres']);
        $stmt->bindParam(':ApPaterno', $_POST['ApPaterno']);
        $stmt->bindParam(':ApMaterno', $_POST['ApMaterno']);
        $stmt->bindParam(':DNI', $_POST['DNI']);
        $stmt->bindParam(':Direccion', $_POST['Direccion']);
        $stmt->bindParam(':Celular', $_POST['Celular']);
        $stmt->bindParam(':EstadoCivil', $_POST['EstadoCivil']);
        $stmt->bindParam(':Genero', $_POST['Genero']);
        $stmt->bindParam(':marca', $_POST['marca']);
        $stmt->bindParam(':modelo', $_POST['modelo']);
        $stmt->bindParam(':placa', $_POST['placa']);
        $stmt->bindParam(':color', $_POST['color']);
        $stmt->bindParam(':anio', $_POST['anio']);
        $stmt->bindParam(':fechaIniBrevet', $_POST['fechaIniBrevet']);
        $stmt->bindParam(':fechaFinBrevet', $_POST['fechaFinBrevet']);
        $stmt->bindParam(':fechaIniReviTec', $_POST['fechaIniReviTec']);
        $stmt->bindParam(':fechaFinReviTec', $_POST['fechaFinReviTec']);
        $stmt->bindParam(':dia_plaqueo', $_POST['dia_plaqueo']);
        $stmt->bindParam(':id_estado', $_POST['id_estado']);
        $stmt->bindParam(':imagen', $_POST['imagen']);
        $stmt->bindParam(':imagen_url', $imagen_url);
        $stmt->bindParam(':imagen1', $_POST['imagen1']);
        $stmt->bindParam(':imagen_url1', $imagen_url1);
        $stmt->bindParam(':id', $_POST['id']);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Registro actualizado exitosamente']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al actualizar el registro']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
    }
}

function eliminarRegistro($conexion) {
    try {
        $query = "DELETE FROM TConexion WHERE id = :id";
        $stmt = $conexion->prepare($query);
        $stmt->bindParam(':id', $_GET['id']);
        
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Registro eliminado exitosamente']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al eliminar el registro']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
    }
}

function obtenerRegistro($conexion) {
    try {
        $query = "SELECT * FROM TConexion WHERE id = :id";
        $stmt = $conexion->prepare($query);
        $stmt->bindParam(':id', $_GET['id']);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result) {
            echo json_encode(['success' => true, 'data' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Registro no encontrado']);
        }
    } catch (PDOException $e) {
        echo json_encode(['success' => false, 'message' => 'Error en la base de datos: ' . $e->getMessage()]);
    }
}

function procesarImagen($campo) {
    if (!empty($_FILES[$campo]['name'])) {
        $target_dir = "uploads/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        
        $file_name = basename($_FILES[$campo]['name']);
        $target_file = $target_dir . uniqid() . '_' . $file_name;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        
        // Verificar si es una imagen real
        $check = getimagesize($_FILES[$campo]['tmp_name']);
        if ($check === false) {
            return '';
        }
        
        // Verificar tamaño del archivo (5MB máximo)
        if ($_FILES[$campo]['size'] > 5000000) {
            return '';
        }
        
        // Permitir ciertos formatos de archivo
        if (!in_array($imageFileType, ['jpg', 'png', 'jpeg', 'gif'])) {
            return '';
        }
        
        // Intentar subir el archivo
        if (move_uploaded_file($_FILES[$campo]['tmp_name'], $target_file)) {
            return $target_file;
        }
    }
    return '';
}
?>
