<?php
ini_set("default_charset", "UTF-8");
session_start();

// Configuración de la ruta base y la foto
$ruta_base = '../Assets/img/usuario/';
$foto = isset($_SESSION['session_foto']) ? $_SESSION['session_foto'] : 'imagen_default.jpg';
$ruta_completa = $ruta_base . $foto;
$nombre = $_SESSION['session_nomb_clinica'];
$direccionu = $_SESSION['session_direccion'];
$correo = $_SESSION['session_correo'];
$telefono = $_SESSION['session_numcontacto'];

// Incluye la biblioteca FPDF
require('fpdf/fpdf.php');

// Configuración de la base de datos
$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Comprobar conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtén el ID del paciente y el ID de la receta desde los parámetros GET
$id_paciente = isset($_GET['id_paciente']) ? intval($_GET['id_paciente']) : 0;
$receta_id = isset($_GET['receta_id']) ? intval($_GET['receta_id']) : 0;

// Verifica que los IDs no estén vacíos y sean números enteros
if ($id_paciente <= 0 || $receta_id <= 0) {
    die("ID inválido.");
}

// Consultar información de la receta
$sqlReceta = "SELECT r.fecha, r.medicamento, r.indicacion, p.Nombres, p.ApPaterno, p.ApMaterno, p.DNI, p.Direccion, p.Celular, p.EstadoCivil, d.Nombres AS doctor_nombre, d.Categoria AS doctor_categoria
              FROM altas r
              JOIN TConexion p ON r.id_paciente = p.id
              JOIN propietario d ON r.id_doctor = d.id
              WHERE p.id = ? AND r.id_alta = ?";
$stmt = $conn->prepare($sqlReceta);
$stmt->bind_param("ii", $id_paciente, $receta_id);
$stmt->execute();
$resultReceta = $stmt->get_result();

if ($resultReceta->num_rows === 0) {
    die("No se encontró la receta con el ID proporcionado.");
}

$receta = $resultReceta->fetch_assoc();

// Cierra la conexión a la base de datos
$conn->close();

// Crear el documento PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 16);
$pdf->Image($ruta_completa, 10, 10, 25, 'C');

// Espacio debajo de la imagen
$pdf->Ln(10);

// Configura la fuente para el texto
$pdf->SetFont('Arial', 'B', 18);
$pdf->Cell(0, 10, 'Clinica ' . htmlspecialchars($nombre), 0, 1, 'C');
$pdf->Ln(3);

$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, 'Direccion: ' . htmlspecialchars($direccionu), 0, 1, 'C');
$pdf->Cell(0, 4, 'Telefono: ' . htmlspecialchars($telefono), 0, 1, 'C');
$pdf->Cell(0, 4, 'Correo: ' . htmlspecialchars($correo), 0, 1, 'C');
$pdf->Ln(4);

// Título
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'Alta Medica', 0, 1, 'C');

// Información del paciente
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, utf8_decode('Informacion del Paciente'), 0, 1, 'L');

$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 5, 'Nombre: ' . htmlspecialchars($receta['Nombres'] ), 0, 1, 'L');
$pdf->Cell(0, 5, 'DNI: ' . htmlspecialchars($receta['DNI']), 0, 1, 'L');
$pdf->Cell(0, 5, utf8_decode('Dirección: ') . htmlspecialchars($receta['ApMaterno']), 0, 1, 'L');
$pdf->Cell(0, 5, 'Celular: ' . htmlspecialchars($receta['Celular']), 0, 1, 'L');
//$pdf->Cell(0, 5, 'Estado Civil: ' . htmlspecialchars($receta['EstadoCivil']), 0, 1, 'L');

// Información de la receta
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Detalles del Alta Medica', 0, 1, 'L');

$pdf->SetFont('Arial', '', 12);
//$pdf->Cell(0, 10, 'Fecha: ' . htmlspecialchars($receta['fecha']), 0, 1, 'L');
//$pdf->MultiCell(0, 10, 'Procedimiento: ' . htmlspecialchars($receta['medicamento']), 0, 1, 'L');
$pdf->MultiCell(0, 10, 'Procedimiento: ' . htmlspecialchars($receta['medicamento']), 0, 'J');
$pdf->MultiCell(0, 10, 'Indicacion: ' . htmlspecialchars($receta['indicacion']), 0, 'J');
$pdf->Cell(0, 10, 'Fecha: ' . htmlspecialchars($receta['fecha']), 0, 1, 'L');

// Espacio antes de la firma y sello
//$pdf->Ln(20);
//$pdf->SetFont('Arial', 'B', 12);
//$pdf->Cell(0, 10, 'Firma y Sello del Doctor', 0, 1, 'C');
$pdf->Ln(30);

// Línea para la firma
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, '_______________________________________', 0, 1, 'C');
$pdf->Cell(0, 5, 'Firma y Sello del Doctor', 0, 1, 'C');
$pdf->Cell(0, 5, 'Doctor: ' . htmlspecialchars($receta['doctor_nombre']), 0, 1, 'C');
$pdf->Cell(0, 5, 'Colegiatura: ' . htmlspecialchars($receta['doctor_categoria']), 0, 1, 'C');

// Output PDF
$pdf->Output();
?>
