<!DOCTYPE html>
<html>
<head>
    <link href='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.2/main.min.css' rel='stylesheet' />
    <script src='https://cdn.jsdelivr.net/npm/fullcalendar@5.11.2/main.min.js'></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        #calendar {
            max-width: 900px;
            margin: 0 auto;
        }

        .legend {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .legend div {
            margin: 0 10px;
            padding: 5px 10px;
            border-radius: 5px;
        }

        .legend .pendiente {
            background-color: yellow;
        }

        .legend .atendido {
            background-color: green;
            color: white;
        }

        .legend .cancelado {
            background-color: red;
            color: white;
        }
        
        .popup-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            display: none;
            justify-content: center;
            align-items: center;
        }

        .popup-content {
            background: white;
            padding: 20px;
            border-radius: 5px;
            max-width: 600px;
            width: 90%;
        }
    </style>
</head>
<body>
    <div id='calendar'></div>
    <div class="legend">
        <div class="pendiente">Pendiente</div>
        <div class="atendido">Atendido</div>
        <div class="cancelado">Cancelado</div>
    </div>

    <div class="popup-overlay">
        <div class="popup-content">
            <h3>Citas del día</h3>
            <div id="daily-events"></div>
            <button id="close-popup">Cerrar</button>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var popupOverlay = document.querySelector('.popup-overlay');
            var dailyEventsContainer = document.getElementById('daily-events');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                events: 'obtener_tratamientos.php',
                dateClick: function(info) {
                    // Fetch events for the clicked date
                    fetch(`obtener_tratamientos.php?fecha=${info.dateStr}`)
                        .then(response => response.json())
                        .then(data => {
                            dailyEventsContainer.innerHTML = '';
                            if (data.length > 0) {
                                data.sort((a, b) => a.hora.localeCompare(b.hora)); // Sort events by hour
                                data.forEach(event => {
                                    var eventDiv = document.createElement('div');
                                    eventDiv.innerHTML = `
                                        <p>Hora: ${event.hora}</p>
                                        <p>Tratamiento: ${event.nombre}</p>
                                        <p>Estado: ${event.estado}</p>
                                        <hr>
                                    `;
                                    dailyEventsContainer.appendChild(eventDiv);
                                });
                            } else {
                                dailyEventsContainer.innerHTML = '<p>No hay citas registradas para este día.</p>';
                            }
                            popupOverlay.style.display = 'flex';
                        });
                },
                eventClick: function(info) {
                    var estado = prompt("Modifica el estado del tratamiento (pendiente, atendido, cancelado):", info.event.extendedProps.estado);
                    if (estado !== null) {
                        $.post("modifica_estado.php", {
                            id: info.event.id,
                            estado: estado
                        }, function(response) {
                            if (response.success) {
                                info.event.setProp('title', estado); // Actualiza el título del evento en el calendario
                                info.event.setExtendedProp('estado', estado); // Actualiza el estado en las propiedades extendidas
                                switch (estado) {
                                    case 'pendiente':
                                        info.event.setProp('backgroundColor', 'yellow');
                                        info.event.setProp('borderColor', 'yellow');
                                        break;
                                    case 'atendido':
                                        info.event.setProp('backgroundColor', 'green');
                                        info.event.setProp('borderColor', 'green');
                                        break;
                                    case 'cancelado':
                                        info.event.setProp('backgroundColor', 'red');
                                        info.event.setProp('borderColor', 'red');
                                        break;
                                }
                                alert("Estado actualizado exitosamente");
                            } else {
                                alert("Error al actualizar el estado");
                            }
                        }, "json");
                    }
                },
                eventDataTransform: function(eventData) {
                    var backgroundColor;
                    switch (eventData.estado) {
                        case 'pendiente':
                            backgroundColor = 'yellow';
                            break;
                        case 'atendido':
                            backgroundColor = 'green';
                            break;
                        case 'cancelado':
                            backgroundColor = 'red';
                            break;
                    }
                    return {
                        id: eventData.id,
                        title: eventData.estado,
                        start: eventData.fecha + 'T' + eventData.hora,
                        backgroundColor: backgroundColor,
                        borderColor: backgroundColor,
                        extendedProps: {
                            estado: eventData.estado,
                            cita_id: eventData.cita_id,
                            id_paciente: eventData.id_paciente
                        }
                    };
                }
            });

            calendar.render();

            document.getElementById('close-popup').addEventListener('click', function() {
                popupOverlay.style.display = 'none';
            });
        });
    </script>
</body>
</html>

