document.addEventListener('DOMContentLoaded', () => {
    const piezas = document.querySelectorAll('.pieza');
    const modal = document.getElementById('modal');
    const span = document.getElementsByClassName('close')[0];
    const formPieza = document.getElementById('formPieza');
    const piezaIdInput = document.getElementById('piezaId');
    const estadoSelect = document.getElementById('estado');
    const tipo = new URLSearchParams(window.location.search).get('tipo');
    const fechaInput = document.getElementById('fecha');
    const horaInput = document.getElementById('hora');
    const nombrePacienteInput = document.getElementById('nombrePaciente');
    const tratamientoSelect = document.getElementById('tratamiento');
    const historialTratamientosDiv = document.getElementById('historialTratamientos');

    piezas.forEach(pieza => {
        pieza.addEventListener('click', () => {
            const id = pieza.getAttribute('data-id');
            const estado = pieza.getAttribute('data-estado');
            piezaIdInput.value = id;
            estadoSelect.value = estado;
            modal.style.display = 'block';

            // Cargar el historial de tratamientos
            fetch(`cargar_historial.php?pieza_id=${id}&tipo=${tipo}`)
                .then(response => response.json())
                .then(data => {
                    historialTratamientosDiv.innerHTML = '';
/*
                    if (data.length > 0) {
                        data.forEach(tratamiento => {
                            const tratamientoDiv = document.createElement('div');
                            tratamientoDiv.innerHTML = `
   <p>Fecha: ${tratamiento.fecha} Hora: ${tratamiento.hora} Tratamiento: ${tratamiento.nombre} Estado: ${tratamiento.estado}  pieza: ${tratamiento.pieza_id} </p>
                                
                                <hr>
                            `;
                            historialTratamientosDiv.appendChild(tratamientoDiv);
                        });
                    } else {
                        historialTratamientosDiv.innerHTML = '<p>No hay tratamientos registrados.</p>';
                    }
                });*/
if (data.length > 0) {
            const tabla = document.createElement('table');
            tabla.style.width = '100%';
            tabla.style.borderCollapse = 'collapse';
            tabla.style.marginTop = '20px';

            const thead = document.createElement('thead');
            const tbody = document.createElement('tbody');
            const headerRow = document.createElement('tr');

            const headers = ['Fecha', 'Hora', 'Tratamiento', 'Estado', 'Pieza'];
            headers.forEach(header => {
                const th = document.createElement('th');
                th.style.border = '1px solid black';
                th.style.padding = '8px';
                th.style.backgroundColor = '#4CAF50';
                th.style.color = 'white';
                th.style.fontWeight = 'bold';
                th.textContent = header;
                headerRow.appendChild(th);
            });

            thead.appendChild(headerRow);

            data.forEach(tratamiento => {
                const dataRow = document.createElement('tr');
                dataRow.style.border = '1px solid black';
                dataRow.style.padding = '8px';
                dataRow.style.textAlign = 'left';
                dataRow.style.fontSize = '14px'; // Tamaño de letra ajustado

                const values = [
                    tratamiento.fecha,
                    tratamiento.hora,
                    tratamiento.nombre,
                    tratamiento.estado,
                    tratamiento.pieza_id
                ];

                values.forEach(value => {
                    const td = document.createElement('td');
                    td.style.border = '1px solid black';
                    td.style.padding = '8px';
                    td.textContent = value;
                    dataRow.appendChild(td);
                });

                tbody.appendChild(dataRow);
            });

            tabla.appendChild(thead);
            tabla.appendChild(tbody);
            historialTratamientosDiv.appendChild(tabla);
        } else {
            historialTratamientosDiv.innerHTML = 'No se encontraron tratamientos.';
        }
    })
    .catch(error => console.error('Error:', error));
        });
    });

    span.onclick = function() {
        modal.style.display = 'none';
    }

    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = 'none';
        }
    }

    formPieza.addEventListener('submit', (e) => {
        e.preventDefault();
        const formData = new FormData(formPieza);
        formData.append('tipo', tipo);
        fetch('guardar_datos.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const id = piezaIdInput.value;
                const estado = estadoSelect.value;
                const pieza = document.querySelector(`.pieza[data-id='${id}']`);
                pieza.setAttribute('data-estado', estado);
                pieza.className = `pieza ${estado}`;
                alert('Datos guardados con éxito');
                modal.style.display = 'none';
            } else {
                alert('Error al guardar los datos');
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    });

    piezas.forEach(pieza => {
        const estado = pieza.getAttribute('data-estado');
        pieza.className = `pieza ${estado}`;
    });
});

