<?php
// Conexión a la base de datos
$dsn = 'mysql:host=exdb.telconetperu.pe;dbname=dental';
$username = 'user_dental';
$password = '@lba$102979';

try {
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // ID del paciente (se puede obtener de una variable GET, POST, etc.)
    $idpaciente = $_GET['idpaciente'];

    // Consulta SQL
    $sql = "SELECT 
                p.pieza_id,
                p.estado,
                p.tipo,
                p.id_paciente,
                p.precio,
                p.detalles,
                p.id_estado_cita,
                ed1.estado_diente AS Oclusal,
                ed2.estado_diente AS Vestibular,
                ed3.estado_diente AS Mesial,
                ed4.estado_diente AS Distal,
                ed5.estado_diente AS Palatino
            FROM 
                piezas p
            LEFT JOIN estado_diente ed1 ON p.Oclusal = ed1.id_estado_diente
            LEFT JOIN estado_diente ed2 ON p.Vestibular = ed2.id_estado_diente
            LEFT JOIN estado_diente ed3 ON p.Mesial = ed3.id_estado_diente
            LEFT JOIN estado_diente ed4 ON p.Distal = ed4.id_estado_diente
            LEFT JOIN estado_diente ed5 ON p.Palatino = ed5.id_estado_diente
            WHERE 
                p.id_paciente = 5";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':idpaciente', $idpaciente, PDO::PARAM_INT);
    $stmt->execute();
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Calcular el total del precio
    $totalPrecio = 0;
    foreach ($resultados as $tratamiento) {
        $totalPrecio += $tratamiento['precio'];
    }

} catch (PDOException $e) {
    echo 'Error: ' . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Tratamientos</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: left;
            font-size: 14px; /* Tamaño de letra ajustado */
        }
        th {
            background-color: #4CAF50;
            color: white;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        tr:hover {
            background-color: #f1f1f1;
        }
    </style>
</head>
<body>
    <div id="result">
        <table>
            <thead>
                <tr>
                    <th>Pieza ID</th>
                    <th>Estado</th>
                    <th>Tipo</th>
                    <th>Paciente ID</th>
                    <th>Precio</th>
                    <th>Detalles</th>
                    <th>Estado Cita</th>
                    <th>Oclusal</th>
                    <th>Vestibular</th>
                    <th>Mesial</th>
                    <th>Distal</th>
                    <th>Palatino</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($resultados as $tratamiento): ?>
                    <tr data-id="<?php echo htmlspecialchars($tratamiento['pieza_id']); ?>">
                        <td><?php echo htmlspecialchars($tratamiento['pieza_id']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['estado']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['tipo']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['id_paciente']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['precio']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['detalles']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['id_estado_cita']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['Oclusal']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['Vestibular']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['Mesial']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['Distal']); ?></td>
                        <td><?php echo htmlspecialchars($tratamiento['Palatino']); ?></td>
                        <td><button class="edit-button">Editar</button></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="4" style="text-align: right; font-weight: bold;">Total Precio:</td>
                    <td colspan="8" id="total-precio"><?php echo htmlspecialchars($totalPrecio); ?></td>
                </tr>
            </tfoot>
        </table>
    </div>

    <!-- Modal para editar -->
    <div id="edit-modal" style="display:none;">
        <h3>Editar Tratamiento</h3>
        <form id="edit-form">
            <input type="hidden" id="pieza-id">
            <label for="id-estado-diente">ID Estado Diente:</label>
            <input type="number" id="id-estado-diente" required>
            <button type="submit">Guardar</button>
        </form>
    </div>

    <script>
        document.querySelectorAll('.edit-button').forEach(button => {
            button.addEventListener('click', event => {
                const row = event.target.closest('tr');
                const piezaId = row.dataset.id;
                const modal = document.getElementById('edit-modal');
                document.getElementById('pieza-id').value = piezaId;
                modal.style.display = 'block';
            });
        });

        document.getElementById('edit-form').addEventListener('submit', event => {
            event.preventDefault();
            const piezaId = document.getElementById('pieza-id').value;
            const idEstadoDiente = document.getElementById('id-estado-diente').value;

            fetch(`actualizar_estado.php`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({
                    pieza_id: piezaId,
                    id_estado_diente: idEstadoDiente
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Actualizar la fila en la tabla
                    const row = document.querySelector(`tr[data-id="${piezaId}"]`);
                    if (idEstadoDiente == 1) {
                        const precio = parseFloat(row.cells[4].innerText);
                        const totalPrecioElem = document.getElementById('total-precio');
                        const totalPrecio = parseFloat(totalPrecioElem.innerText);
                        totalPrecioElem.innerText = (totalPrecio - precio).toFixed(2);

                        // Añadir fila indicando que se realizó el pago
                        const tbody = document.querySelector('tbody');
                        const newRow = document.createElement('tr');
                        newRow.innerHTML = `
                            <td colspan="13" style="text-align: center;">Pago realizado para pieza ${piezaId}</td>
                        `;
                        tbody.appendChild(newRow);
                    }
                    row.cells[7].innerText = idEstadoDiente; // Actualizar Oclusal como ejemplo
                    document.getElementById('edit-modal').style.display = 'none';
                }
            })
            .catch(error => console.error('Error:', error));
        });
    </script>
</body>
</html>
