<!DOCTYPE html>
<html>
<head>
<meta name="viewport" content="initial-scale=1.0, user-scalable=no" />


<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAzpOJNnikRO5AMIqjkAS-5fwu7yLxuCIU&libraries=geometry,weather&sensor=false"></script>

<script type="text/javascript">
var map, marker;
var startPos = [8.893260000000001, 76.61427];
var speed = 50; // km/h

var delay = 2000;
var icon ;

function initialize()
{
    var myOptions = {
        zoom: 10,
        center: new google.maps.LatLng(8.893260000000001, 76.61427),
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };
    map = new google.maps.Map(document.getElementById("mapa"), myOptions);
    var car = "M17.402,0H5.643C2.526,0,0,3.467,0,6.584v34.804c0,3.116,2.526,5.644,5.643,5.644h11.759c3.116,0,5.644-2.527,5.644-5.644 V6.584C23.044,3.467,20.518,0,17.402,0z M22.057,14.188v11.665l-2.729,0.351v-4.806L22.057,14.188z M20.625,10.773 c-1.016,3.9-2.219,8.51-2.219,8.51H4.638l-2.222-8.51C2.417,10.773,11.3,7.755,20.625,10.773z M3.748,21.713v4.492l-2.73-0.349 V14.502L3.748,21.713z M1.018,37.938V27.579l2.73,0.343v8.196L1.018,37.938z M2.575,40.882l2.218-3.336h13.771l2.219,3.336H2.575z M19.328,35.805v-7.872l2.729-0.355v10.048L19.328,35.805z";
     icon = {
    path: car,
    scale: .7,
    strokeColor: 'white',
    strokeWeight: .10,
    fillOpacity: 1,
    fillColor: '#404040',
    offset: '5%',
    // rotation: parseInt(heading[i]),
    anchor: new google.maps.Point(10, 25) // orig 10,50 back of car, 10,0 front of car, 10,25 center of car
};
    marker = new google.maps.Marker({
        position: new google.maps.LatLng(startPos[0], startPos[1]),
        icon:icon,
        map: map
        
    });
    var pathCoords2 = [{
  "lat": 8.893260000000001,
  "lng": 76.61427
}, {
  "lat": 8.894430000000002,
  "lng": 76.61418
}, {
  "lat": 8.89484,
  "lng": 76.61416000000001
},  {
  "lat": 8.55532,
  "lng": 76.90364000000001
}, {
  "lat": 8.52964,
  "lng": 76.93216000000001
}, {
  "lat": 8.529430000000001,
  "lng": 76.93264
}, {
  "lat": 8.52426,
  "lng": 76.93668000000001
}];


      var pathCoords = [[
   8.893260000000001,
   76.61427
], [
   8.894430000000002,
   76.61418
],[
  8.52426,
   76.93668000000001
]
   


];

console.log(pathCoords);
console.log(pathCoords2);

var car = "M17.402,0H5.643C2.526,0,0,3.467,0,6.584v34.804c0,3.116,2.526,5.644,5.643,5.644h11.759c3.116,0,5.644-2.527,5.644-5.644 V6.584C23.044,3.467,20.518,0,17.402,0z M22.057,14.188v11.665l-2.729,0.351v-4.806L22.057,14.188z M20.625,10.773 c-1.016,3.9-2.219,8.51-2.219,8.51H4.638l-2.222-8.51C2.417,10.773,11.3,7.755,20.625,10.773z M3.748,21.713v4.492l-2.73-0.349 V14.502L3.748,21.713z M1.018,37.938V27.579l2.73,0.343v8.196L1.018,37.938z M2.575,40.882l2.218-3.336h13.771l2.219,3.336H2.575z M19.328,35.805v-7.872l2.729-0.355v10.048L19.328,35.805z";
            var lineSymbol = {
                path: car,
                //rotation: 185,
                scale: .7,
                strokeColor: '#212529',
                fillColor: '#212529',
                // offset: '5%',

            };
var line2 = new google.maps.Polyline({
  path:[],
  strokeColor: "#582EF2",
  strokeOpacity: 0.7,
  strokeWeight: 2,
  geodesic: true, //set to false if you want straight line instead of arc
  icons: [{
                    icon: lineSymbol,
                    offset: '0%'
                }],
  map: map,
});
line2.setMap(map);

      animateMarker(marker, pathCoords, speed);
      var count = 0;
            window.setInterval(function () {
                count = (count + 0.1) % 200;

                var icons = line2.get('icons');
                icons[0].offset = (count / 2) + '%';
                line2.set('icons', icons);
            }, 5);

       
    google.maps.event.addListenerOnce(map, 'idle', function()
    {
      
    });
}

google.maps.event.addDomListener(window, 'load', initialize);

function animateMarker(marker, coords, km_h)
{
    var target = 0;
    var km_h = km_h || 50;
    coords.push([startPos[0], startPos[1]]);
    
    function goToPoint()
    {
        var lat = marker.position.lat();
        var lng = marker.position.lng();
        var step = (km_h * 1000 * delay) / 36000; // in meters
        
        var dest = new google.maps.LatLng(
 coords[target][0], coords[target][1]);
        console.log(dest);
        var distance = google.maps.geometry.spherical.computeDistanceBetween(
        dest, marker.position); // in meters
        
        var numStep = distance / step;
        var i = 0;
        var deltaLat = (coords[target][0] - lat) / numStep;
        var deltaLng = (coords[target][1] - lng) / numStep;
        
        function moveMarker()
        {
            lat += deltaLat;
            lng += deltaLng;
            i += step;
            
            if (i < distance)
            {
                //marker.setPosition(new google.maps.LatLng(lat, lng));
                map.panTo(new google.maps.LatLng(lat, lng));
              var heading = google.maps.geometry.spherical.computeHeading(dest , new google.maps.LatLng(lat, lng));
                icon.rotation = heading;
               marker.setIcon(icon);
                setTimeout(moveMarker, delay);
            }
            else
            {   marker.setPosition(new google.maps.LatLng(startPos[0], startPos[1]));
              map.panTo(new google.maps.LatLng(startPos[0], startPos[1]));
                target++;
                if (target == coords.length){ target = 0; }
                
                setTimeout(goToPoint, delay);
            }
        }
        moveMarker();
    }
    goToPoint();
}
</script>

</script>
</head>
<body   >
 
 

<style type="text/css">
  html { height: 100% }
  body { height: 80%; margin: 10px; padding: 0px }
  #mapa { height: 100% }
</style> 

  
<div id="mapa"></div>



</body>
</html>