<?php
session_start();
require("menu.php");

// Conexión a la base de datos
$host = 'exdb.telconetperu.pe'; // Cambia esto si es necesario
$dbname = 'dental';
$username = 'user_dental';
$password = '@lba$102979';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("No se pudo conectar a la base de datos: " . $e->getMessage());
}

// Obtener el ID del paciente desde la URL
$id_paciente = isset($_GET['id']) ? $_GET['id'] : null;
$nombre_paciente = isset($_GET['nombre']) ? $_GET['nombre'] : null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $fecha = $_POST['fecha'];
    $medicamento = $_POST['medicamento'];
    $indicacion = $_POST['indicacion'];

    try {
        if (!$id_paciente) {
            throw new Exception('ID del paciente no especificado.');
        }

        // Obtener el ApPaterno del paciente
        $stmt = $pdo->prepare("SELECT ApPaterno FROM TConexion WHERE id = ?");
        $stmt->execute([$id_paciente]);
        $ApPaterno = $stmt->fetchColumn();

        if (!$ApPaterno) {
            throw new Exception('Paciente no encontrado o ApPaterno no disponible.');
        }

        // Obtener el id_doctor a partir del ApPaterno
        $stmt = $pdo->prepare("SELECT id FROM propietario WHERE id = ?");
        $stmt->execute([$ApPaterno]);
        $id_doctor = $stmt->fetchColumn();

        if (!$id_doctor) {
            throw new Exception('Doctor no encontrado para ApPaterno: ' . htmlspecialchars($ApPaterno));
        }

        // Insertar la medicación en la tabla receta
        $stmt = $pdo->prepare("INSERT INTO receta (id_paciente, fecha, medicamento, indicacion, id_doctor) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$id_paciente, $fecha, $medicamento, $indicacion, $id_doctor]);

        echo "<div class='alert alert-success'>Medicación registrada exitosamente.</div>";
    } catch (Exception $e) {
        echo "<div class='alert alert-danger'>Error: " . $e->getMessage() . "</div>";
    }
}

// Generar el listado de recetas
$recetas = [];
if ($id_paciente) {
    $stmt = $pdo->prepare("SELECT id_receta, fecha, medicamento, indicacion FROM receta WHERE id_paciente = ?");
    $stmt->execute([$id_paciente]);
    $recetas = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Función para generar el enlace de PDF
function generarPDF($id_paciente, $index) {
    return "generar_pdfM.php?id=" . urlencode($id_paciente) . "&index=" . urlencode($index);
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Registrar Medicación</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</head>
<body>
    <div class="container mt-4">
        <h1>Registrar Medicación para Paciente</h1>
        <?php
        if ($id_paciente) {
           // echo "<p>Paciente: " . htmlspecialchars($nombre_paciente) . " (ID: " . htmlspecialchars($id_paciente) . ")</p>";
        } else {
            echo "<p>No se ha recibido el ID del paciente.</p>";
        }
        ?>
        
        <!-- Formulario para registrar medicación -->
        <form action="" method="post">
            <div class="form-group">
                <label for="fecha">Fecha:</label>
                <input type="date" id="fecha" name="fecha" class="form-control" required>
            </div>
            <div class="form-group">
                <label for="medicamento">Medicamento:</label>
                <textarea type="text" id="medicamento" name="medicamento" class="form-control" required></textarea>
            </div>
            <div class="form-group">
                <label for="indicacion">Indicación:</label>
                <textarea type="text" id="indicacion" name="indicacion" class="form-control" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Registrar</button>
        </form>

        <!-- Listado de recetas -->
        <?php if ($recetas): ?>
        <h2 class="mt-4">Listado de Recetas</h2>
        <table class="table table-bordered mt-2">
            <thead>
                <tr>
                    
                    <th>Medicamento</th>
                    <th>Indicación</th>
		    <th>Fecha</th>
                    <th>Acción</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($recetas as $index => $receta): ?>
                <tr>
                    <td><?php echo htmlspecialchars($receta['medicamento']); ?></td>
                    <td><?php echo htmlspecialchars($receta['indicacion']); ?></td>
                    <td><?php echo htmlspecialchars($receta['fecha']); ?></td>
		    <td>
			<a href="generar_pdfM.php?id_paciente=<?php echo urlencode($id_paciente); ?>&receta_id=<?php echo urlencode($receta['id_receta']); ?>" class="btn btn-success" target="_blank">Generar PDF</a>


                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php endif; ?>
    </div>
</body>
</html>
