<?php

session_start();

require("menu.php");

// Conexión a la base de datos
$host = 'localhost'; // Cambia esto si es necesario
$dbname = 'dental';
$username = 'user_dental';
$password = '@lba$102979';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("No se pudo conectar a la base de datos: " . $e->getMessage());
}

// Obtener el ID del paciente desde la URL
$id_paciente = isset($_GET['id']) ? $_GET['id'] : null;
$nombre_paciente = isset($_GET['nombre']) ? $_GET['nombre'] : null;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $fecha = $_POST['fecha'];
    $medicamento = $_POST['medicamento'];
    $indicacion = $_POST['indicacion'];

    try {
        if (!$id_paciente) {
            throw new Exception('ID del paciente no especificado.');
        }

        // Obtener el ApPaterno del paciente
        $stmt = $pdo->prepare("SELECT ApPaterno FROM TConexion WHERE id = ?");
        $stmt->execute([$id_paciente]);
        $ApPaterno = $stmt->fetchColumn();

        if (!$ApPaterno) {
            throw new Exception('Paciente no encontrado o ApPaterno no disponible.');
        }

        // Obtener el id_doctor a partir del ApPaterno
        $stmt = $pdo->prepare("SELECT id FROM propietario WHERE id = ?");
        $stmt->execute([$ApPaterno]);
        $id_doctor = $stmt->fetchColumn();

        if (!$id_doctor) {
            throw new Exception('Doctor no encontrado para ApPaterno: ' . htmlspecialchars($ApPaterno));
        }

        // Insertar la medicación en la tabla receta
        $stmt = $pdo->prepare("INSERT INTO receta (id_paciente, fecha, medicamento, indicacion, id_doctor) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$id_paciente, $fecha, $medicamento, $indicacion, $id_doctor]);

        echo "Medicación registrada exitosamente.";
    } catch (Exception $e) {
        echo "Error: " . $e->getMessage();
    }
} else {
    // Mostrar el formulario
    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <title>Registrar Medicación</title>
    </head>
    <body>
        <h1>Registrar Medicación para Paciente</h1>
        <?php
        if ($id_paciente) {
            echo "<p>Paciente: " . htmlspecialchars($nombre_paciente) . " (ID: " . htmlspecialchars($id_paciente) . ")</p>";
        } else {
            echo "<p>No se ha recibido el ID del paciente.</p>";
        }
        ?>
        <form action="" method="post">
            <label for="fecha">Fecha:</label>
            <input type="date" id="fecha" name="fecha" required>
            <br>
            <label for="medicamento">Medicamento:</label>
            <input type="text" id="medicamento" name="medicamento" required>
            <br>
            <label for="indicacion">Indicación:</label>
            <input type="text" id="indicacion" name="indicacion" required>
            <br>
            <input type="submit" value="Registrar">
        </form>
    </body>
    </html>
    <?php
}
?>
