<?php
require_once 'conexion/conexion.php';
session_start();
$today = date('Y-m-d');
require("menu.php");
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro de Conductores</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <!-- DataTables -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap5.min.css">
    <style>
        .bg-orange {
            background-color: #fd7e14;
        }
        .alert-orange {
            background-color: #fff3cd;
            border-color: #ffeeba;
            color: #856404;
        }
        .btn-outline-orange {
            color: #fd7e14;
            border-color: #fd7e14;
        }
        .btn-outline-orange:hover {
            color: #fff;
            background-color: #fd7e14;
            border-color: #fd7e14;
        }
    </style>
</head>
<body>
    <div class="container-fluid mt-3">
        <button class="btn btn-outline-primary mb-2" type="button" onclick="frmRegistroConductor();"><i class="fas fa-plus"></i> Nuevo Registro</button>
        <div class="card">
            <div class="card-header bg-orange text-white">
                Registro de Conductores
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover display responsive nowrap" id="tblRegistros" style="width: 99%;">
                        <thead class="bg-orange text-white">
                            <tr>
                                <th>Nombres</th>
                                <th>Apellidos</th>
                                <th>DNI</th>
                                <th>Dirección</th>
                                <th>Celular</th>
                                <th>Vehículo</th>
                                <th>Placa</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal para el formulario -->
    <div class="modal fade" id="modalRegistro" tabindex="-1" aria-labelledby="modalRegistroLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-orange text-white">
                    <h5 class="modal-title" id="modalRegistroLabel">Nuevo Registro</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form id="frmRegistro" autocomplete="off" enctype="multipart/form-data">
                    <div class="modal-body ui-front">
                        <div class="alert alert-orange d-flex align-items-center" role="alert">
                            <div>
                                Todos los campos con <span class="text-danger fw-bold">*</span> son obligatorios.
                            </div>
                        </div>
                        <input type="hidden" id="id" name="id">
                        <div class="row">
                            <div class="col-md-6">
                                <!-- Datos Personales -->
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="Nombres" name="Nombres" placeholder="Nombres" required>
                                    <label for="Nombres"><i class="fas fa-user"></i> Nombres <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="ApPaterno" name="ApPaterno" placeholder="Apellido Paterno" required>
                                    <label for="ApPaterno"><i class="fas fa-user"></i> Apellido Paterno <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="ApMaterno" name="ApMaterno" placeholder="Apellido Materno" required>
                                    <label for="ApMaterno"><i class="fas fa-user"></i> Apellido Materno <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="DNI" name="DNI" placeholder="DNI" pattern="\d{8}" required>
                                    <label for="DNI"><i class="fas fa-id-card"></i> DNI <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="Direccion" name="Direccion" placeholder="Dirección" required>
                                    <label for="Direccion"><i class="fas fa-map-marker-alt"></i> Dirección <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="Celular" name="Celular" placeholder="Celular" pattern="[0-9]{9}" required>
                                    <label for="Celular"><i class="fas fa-phone"></i> Celular <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <select class="form-control" id="EstadoCivil" name="EstadoCivil" required>
                                        <option value="">Seleccione...</option>
                                        <option value="Soltero">Soltero/a</option>
                                        <option value="Casado">Casado/a</option>
                                        <option value="Divorciado">Divorciado/a</option>
                                        <option value="Viudo">Viudo/a</option>
                                    </select>
                                    <label for="EstadoCivil"><i class="fas fa-heart"></i> Estado Civil <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <select class="form-control" id="Genero" name="Genero" required>
                                        <option value="">Seleccione...</option>
                                        <option value="Masculino">Masculino</option>
                                        <option value="Femenino">Femenino</option>
                                    </select>
                                    <label for="Genero"><i class="fas fa-venus-mars"></i> Género <span class="text-danger fw-bold">*</span></label>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <!-- Datos del Vehículo -->
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="marca" name="marca" placeholder="Marca del vehículo">
                                    <label for="marca"><i class="fas fa-car"></i> Marca</label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="modelo" name="modelo" placeholder="Modelo del vehículo">
                                    <label for="modelo"><i class="fas fa-car"></i> Modelo</label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="placa" name="placa" placeholder="Placa del vehículo">
                                    <label for="placa"><i class="fas fa-car"></i> Placa</label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="color" name="color" placeholder="Color del vehículo">
                                    <label for="color"><i class="fas fa-palette"></i> Color</label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <input type="text" class="form-control" id="anio" name="anio" placeholder="Año del vehículo" pattern="\d{4}">
                                    <label for="anio"><i class="fas fa-calendar-alt"></i> Año</label>
                                </div>
                                
                                <!-- Documentos -->
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-floating mb-3">
                                            <input type="date" class="form-control" id="fechaIniBrevet" name="fechaIniBrevet">
                                            <label for="fechaIniBrevet"><i class="fas fa-id-card"></i> Brevet Inicio</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating mb-3">
                                            <input type="date" class="form-control" id="fechaFinBrevet" name="fechaFinBrevet">
                                            <label for="fechaFinBrevet"><i class="fas fa-id-card"></i> Brevet Fin</label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-floating mb-3">
                                            <input type="date" class="form-control" id="fechaIniReviTec" name="fechaIniReviTec">
                                            <label for="fechaIniReviTec"><i class="fas fa-file-alt"></i> Revisión Técnica Inicio</label>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-floating mb-3">
                                            <input type="date" class="form-control" id="fechaFinReviTec" name="fechaFinReviTec">
                                            <label for="fechaFinReviTec"><i class="fas fa-file-alt"></i> Revisión Técnica Fin</label>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <select class="form-control" id="dia_plaqueo" name="dia_plaqueo">
                                        <option value="">Seleccione día de plaqueo</option>
                                        <option value="Lunes">Lunes</option>
                                        <option value="Martes">Martes</option>
                                        <option value="Miércoles">Miércoles</option>
                                        <option value="Jueves">Jueves</option>
                                        <option value="Viernes">Viernes</option>
                                    </select>
                                    <label for="dia_plaqueo"><i class="fas fa-calendar-day"></i> Día de Plaqueo</label>
                                </div>
                                
                                <div class="form-floating mb-3">
                                    <select class="form-control" id="id_estado" name="id_estado" required>
                                        <option value="1">Activo</option>
                                        <option value="0">Inactivo</option>
                                    </select>
                                    <label for="id_estado"><i class="fas fa-check-circle"></i> Estado <span class="text-danger fw-bold">*</span></label>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="imagen" class="form-label"><i class="fas fa-image"></i> Foto del Conductor</label>
                                    <input class="form-control" type="file" id="imagen" name="imagen" accept="image">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary" id="btnGuardar">Guardar</button>
                        <button type="button" class="btn btn-outline-danger" data-bs-dismiss="modal">Cancelar</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
 <!-- jQuery, Bootstrap JS, DataTables -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/responsive.bootstrap5.min.js"></script>
    <!-- SweetAlert2 -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        $(document).ready(function() {
            // Inicializar DataTable
            var table = $('#tblRegistros').DataTable({
                "ajax": {
                    "url": "crud_registro.php?action=listar",
                    "dataSrc": ""
                },
                "columns": [
                    { "data": "Nombres" },
                    { "data": "Apellidos" },
                    { "data": "DNI" },
                    { "data": "Direccion" },
                    { "data": "Celular" },
                    { 
                        "data": null,
                        "render": function(data, type, row) {
                            return row.marca + ' ' + row.modelo;
                        }
                    },
                    { "data": "placa" },
                    { 
                        "data": "id_estado",
                        "render": function(data, type, row) {
                            return data == 1 ? '<span class="badge bg-success">Activo</span>' : '<span class="badge bg-danger">Inactivo</span>';
                        }
                    },
                    {
                        "data": null,
                        "render": function(data, type, row) {
                            return `
                                <div class="btn-group" role="group">
                                    <button class="btn btn-sm btn-outline-primary" onclick="editarRegistro(${row.id})"><i class="fas fa-edit"></i></button>
                                    <button class="btn btn-sm btn-outline-danger" onclick="eliminarRegistro(${row.id})"><i class="fas fa-trash"></i></button>
                                </div>
                            `;
                        },
                        "orderable": false
                    }
                ],
                "responsive": true,
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.11.5/i18n/es-ES.json"
                }
            });

            // Manejar el envío del formulario
            $('#frmRegistro').submit(function(e) {
                e.preventDefault();
                
                var formData = new FormData(this);
                var url = $('#id').val() ? "crud_registro.php?action=actualizar" : "crud_registro.php?action=registrar";
                
                $.ajax({
                    url: url,
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function(response) {
                        var res = JSON.parse(response);
                        if (res.success) {
                            Swal.fire({
                                icon: 'success',
                                title: 'Éxito',
                                text: res.message
                            });
                            $('#modalRegistro').modal('hide');
                            table.ajax.reload();
                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: res.message
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: 'Ocurrió un error al procesar la solicitud'
                        });
                    }
                });
            });
        });

        // Función para abrir el modal de nuevo registro
        function frmRegistroConductor() {
            $('#frmRegistro')[0].reset();
            $('#modalRegistroLabel').text('Nuevo Registro');
            $('#modalRegistro').modal('show');
        }

        // Función para editar un registro
        function editarRegistro(id) {
            $.ajax({
                url: "crud_registro.php?action=obtener&id=" + id,
                type: "GET",
                success: function(response) {
                    var res = JSON.parse(response);
                    if (res.success) {
                        var data = res.data;
                        
                        // Llenar el formulario con los datos
                        $('#id').val(data.id);
                        $('#Nombres').val(data.Nombres);
                        $('#ApPaterno').val(data.ApPaterno);
                        $('#ApMaterno').val(data.ApMaterno);
                        $('#DNI').val(data.DNI);
                        $('#Direccion').val(data.Direccion);
                        $('#Celular').val(data.Celular);
                        $('#EstadoCivil').val(data.EstadoCivil);
                        $('#Genero').val(data.Genero);
                        $('#marca').val(data.marca);
                        $('#modelo').val(data.modelo);
                        $('#placa').val(data.placa);
                        $('#color').val(data.color);
                        $('#anio').val(data.anio);
                        $('#fechaIniBrevet').val(data.fechaIniBrevet);
                        $('#fechaFinBrevet').val(data.fechaFinBrevet);
                        $('#fechaIniReviTec').val(data.fechaIniReviTec);
                        $('#fechaFinReviTec').val(data.fechaFinReviTec);
                        $('#dia_plaqueo').val(data.dia_plaqueo);
                        $('#id_estado').val(data.id_estado);
                        
                        $('#modalRegistroLabel').text('Editar Registro');
                        $('#modalRegistro').modal('show');
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Error',
                            text: res.message
                        });
                    }
                }
            });
        }

        // Función para eliminar un registro
        function eliminarRegistro(id) {
            Swal.fire({
                title: '¿Estás seguro?',
                text: "¡No podrás revertir esto!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, eliminarlo!',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: "crud_registro.php?action=eliminar&id=" + id,
                        type: "GET",
                        success: function(response) {
                            var res = JSON.parse(response);
                            if (res.success) {
                                Swal.fire(
                                    'Eliminado!',
                                    res.message,
                                    'success'
                                );
                                $('#tblRegistros').DataTable().ajax.reload();
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: res.message
                                });
                            }
                        }
                    });
                }
            });
        }
    </script>
</body>
</html>
