<?php
$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

// Crear la conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Verificar que el formulario haya sido enviado
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $id_pagos = $_POST['id_pagos'];
    $pagos = $_POST['pagos'];
    $fecha_pago = $_POST['fecha_pago'];
    $detalles = $_POST['detalles'];
    $id_paciente = $_POST['id_paciente'];

    // Preparar y enlazar
    $stmt = $conn->prepare("INSERT INTO pagos (id_pagos, pagos, fecha_pago, detalles, id_paciente) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("isssi", $id_pagos, $pagos, $fecha_pago, $detalles, $id_paciente);

    // Ejecutar la consulta
    if ($stmt->execute()) {
        echo "Nuevo registro creado exitosamente";
    } else {
        echo "Error: " . $stmt->error;
    }

    // Cerrar la declaración
    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Registro de Pagos</title>
</head>
<body>
    <h1>Registrar Pago</h1>
    <form action="registro_pagos.php" method="post">
        <label for="id_pagos">ID Pagos:</label>
        <input type="text" id="id_pagos" name="id_pagos"><br><br>
        <label for="pagos">Pagos:</label>
        <input type="text" id="pagos" name="pagos"><br><br>
        <label for="fecha_pago">Fecha de Pago:</label>
        <input type="date" id="fecha_pago" name="fecha_pago"><br><br>
        <label for="detalles">Detalles:</label>
        <textarea id="detalles" name="detalles"></textarea><br><br>
        <label for="id_paciente">ID Paciente:</label>
        <input type="text" id="id_paciente" name="id_paciente"><br><br>
        <input type="submit" value="Registrar Pago">
    </form>

    <h1>Pagos</h1>
    <table border="1">
        <tr>
            <th>ID Pagos</th>
            <th>Pagos</th>
            <th>Fecha de Pago</th>
            <th>Detalles</th>
            <th>ID Paciente</th>
        </tr>
        <?php
        $sql_pagos = "SELECT id_pagos, pagos, fecha_pago, detalles, id_paciente FROM pagos";
        $result_pagos = $conn->query($sql_pagos);

        if ($result_pagos->num_rows > 0) {
            while($row = $result_pagos->fetch_assoc()) {
                echo "<tr>
                        <td>" . $row["id_pagos"]. "</td>
                        <td>" . $row["pagos"]. "</td>
                        <td>" . $row["fecha_pago"]. "</td>
                        <td>" . $row["detalles"]. "</td>
                        <td>" . $row["id_paciente"]. "</td>
                    </tr>";
            }
        } else {
            echo "<tr><td colspan='5'>No hay registros</td></tr>";
        }
        ?>
    </table>

    <h1>Cálculo del Total</h1>
    <?php
    $sql_piezas = "SELECT id_paciente, SUM(precio) as total_piezas FROM piezas GROUP BY id_paciente";
    $result_piezas = $conn->query($sql_piezas);

    if ($result_piezas->num_rows > 0) {
        while($row_piezas = $result_piezas->fetch_assoc()) {
            $id_paciente = $row_piezas["id_paciente"];
            $total_piezas = $row_piezas["total_piezas"];

            $sql_pagos = "SELECT SUM(pagos) as total_pagos FROM pagos WHERE id_paciente = $id_paciente";
            $result_pagos = $conn->query($sql_pagos);
            $total_pagos = 0;
            if ($result_pagos->num_rows > 0) {
                $row_pagos = $result_pagos->fetch_assoc();
                $total_pagos = $row_pagos["total_pagos"];
            }

            $monto_restante = $total_piezas - $total_pagos;

            echo "<p>Paciente ID: $id_paciente</p>";
            echo "<p>Total Piezas: $total_piezas</p>";
            echo "<p>Total Pagos: $total_pagos</p>";
            echo "<p>Monto Restante: $monto_restante</p>";
            echo "<hr>";
        }
    } else {
        echo "<p>No hay registros en la tabla de piezas</p>";
    }

    $conn->close();
    ?>
</body>
</html>
