<?php
$fecha_y_hora = date("Y-m-d H:i:s");
require("menu.php");
session_start();
$id_UC = $_SESSION["session_idusario"] ?? null;

$tipo = $_GET['tipo'] ?? 'adulto';
$id_paciente = $_GET['id'] ?? null;
$nombre = $_GET['nombre'] ?? null;

require('../vista/fpdf/fpdf.php');

$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

// Crear la conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Verificar la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Manejar eliminación de registros
if (isset($_GET['eliminar'])) {
    $id_pagos = $_GET['eliminar'];
    $stmt = $conn->prepare("DELETE FROM pagos WHERE id_pagos = ?");
    $stmt->bind_param("i", $id_pagos);
    
    if ($stmt->execute()) {
        echo "<script>alert('Registro eliminado exitosamente');</script>";
    } else {
        echo "<script>alert('Error al eliminar registro: " . $stmt->error . "');</script>";
    }

    $stmt->close();
}

// Cargar datos para editar si se proporciona un id_pagos
$registro = null;
if (isset($_GET['id_pago'])) {
    $id_pagos = $_GET['id_pago'];
    $stmt = $conn->prepare("SELECT pagos, fecha_pago, detalles FROM pagos WHERE id_pagos = ?");
    $stmt->bind_param("i", $id_pagos);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $registro = $result->fetch_assoc();
    } else {
        echo "Registro no encontrado.";
    }
    $stmt->close();
}

// Verificar que el formulario haya sido enviado
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['registro'])) {
    $id_pagos = $_POST['id_pagos'];
    $pagos = $_POST['pagos'];
    $fecha_pago = $_POST['fecha_pago'];
    $detalles = $_POST['detalles'];

    // Validar que el campo de detalles no esté vacío
    if (empty($detalles)) {
        echo "<script>alert('El campo de detalles no puede estar vacío.');</script>";
    } else {
        // Si hay un id_pagos, actualiza el registro existente
        if (!empty($id_pagos)) {
            $stmt = $conn->prepare("UPDATE pagos SET pagos = ?, fecha_pago = ?, detalles = ? WHERE id_pagos = ?");
            $stmt->bind_param("sssi", $pagos, $fecha_pago, $detalles, $id_pagos);
        } else {
            $stmt = $conn->prepare("INSERT INTO pagos (pagos, fecha_pago, detalles, id_paciente, id_usuario) VALUES (?, ?, ?, ?, ?)");
            $stmt->bind_param("sssii", $pagos, $fecha_pago, $detalles, $id_paciente, $id_UC);
        }

        // Ejecutar la consulta
        if ($stmt->execute()) {
            echo "Registro guardado exitosamente";
        } else {
            echo "Error: " . $stmt->error;
        }

        $stmt->close();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.0.7/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <style>
        body {
            margin: 20px;
            background-color: #f4f4f4;
        }
    </style>
    <title>Registro de Pagos</title>
    <script>
        function generarPDF() {
            var id = "<?php echo $id_paciente; ?>";
            var tipo = "<?php echo $tipo; ?>";
            var nombre = "<?php echo $nombre; ?>";
            window.open("rep_pagos.php?id=" + id + "&tipo=" + tipo + "&nombre=" + nombre, "_blank");
        }
    </script>
</head>
<body>
    <div class="container">
        <h1 class="mt-4"><?php echo isset($registro) ? 'Editar Pago' : 'Registrar Pago'; ?></h1>
        <form action="registro_pagos2.php?id=<?php echo $id_paciente; ?>&tipo=<?php echo $tipo; ?>&nombre=<?php echo $nombre; ?>" method="post">
            <input type="hidden" id="id_pagos" name="id_pagos" value="<?php echo isset($registro) ? $id_pagos : ''; ?>">
            <div class="form-group">
                <label for="pagos">Pagos:</label>
                <input type="text" class="form-control" id="pagos" name="pagos" value="<?php echo isset($registro) ? htmlspecialchars($registro['pagos']) : ''; ?>" required>
            </div>
            <input type="hidden" id="fecha_pago" name="fecha_pago" value="<?php echo isset($registro) ? htmlspecialchars($registro['fecha_pago']) : $fecha_y_hora; ?>" readonly>
            <div class="form-group">
                <label for="detalles">Detalles:</label>
                <textarea class="form-control" id="detalles" name="detalles" required><?php echo isset($registro) ? htmlspecialchars($registro['detalles']) : ''; ?></textarea>
            </div>
            <input type="hidden" id="id_paciente" name="id_paciente" value="<?php echo $id_paciente; ?>">
            <input type="hidden" id="id_usuario" name="id_usuario" value="<?php echo $id_UC; ?>">
            <button class="btn btn-primary" type="submit" name="registro"><?php echo isset($registro) ? 'Actualizar Pago' : 'Registrar Pago'; ?></button>
        </form>

        <h2 class="mt-4">Pagos Registrados</h2>
        <table class="table table-bordered">
            <thead class="thead-light">
                <tr>
                    <th>Nombre Paciente</th>
                    <th>Monto Pagado</th>
                    <th>Fecha de Pago</th>
                    <th>Detalles</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $sql_pagos = "SELECT id_pagos, pagos, fecha_pago, detalles FROM pagos WHERE id_paciente=" . $id_paciente;
                $result_pagos = $conn->query($sql_pagos);

                if ($result_pagos->num_rows > 0) {
                    while ($row = $result_pagos->fetch_assoc()) {
                        echo "<tr>
                                <td>" . htmlspecialchars($nombre) . "</td>
                                <td>" . number_format($row["pagos"], 2, '.', ',') . "</td>
                                <td>" . htmlspecialchars($row["fecha_pago"]) . "</td>
                                <td>" . htmlspecialchars($row["detalles"]) . "</td>
                                <td>
                                    <a href='registro_pagos2.php?id_pago=" . $row['id_pagos'] . "&id=" . $id_paciente . "&tipo=" . $tipo . "&nombre=" . $nombre . "' 
                                       class='btn btn-warning btn-sm'>
                                       Editar
                                    </a>
                                    <a href='registro_pagos2.php?id=" . $id_paciente . "&tipo=" . $tipo . "&nombre=" . $nombre . "&eliminar=" . $row['id_pagos'] . "' 
                                       class='btn btn-danger btn-sm' 
                                       onclick='return confirm(\"¿Estás seguro de que deseas eliminar este registro?\")'>
                                       Eliminar
                                    </a>
                                </td>
                            </tr>";
                    }
                } else {
                    echo "<tr><td colspan='5'>No hay registros</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <h2 class="mt-4">Resumen de Tratamientos</h2>
        <?php
        $sql_piezas = "SELECT id_paciente, SUM(precio) as total_piezas FROM piezas WHERE id_paciente = $id_paciente GROUP BY id_paciente";
        $result_piezas = $conn->query($sql_piezas);

        if ($result_piezas->num_rows > 0) {
            while ($row_piezas = $result_piezas->fetch_assoc()) {
                $total_piezas = $row_piezas["total_piezas"];

                $sql_pagos = "SELECT SUM(pagos) as total_pagos FROM pagos WHERE id_paciente = $id_paciente";
                $result_pagos = $conn->query($sql_pagos);
                $total_pagos = 0;
                if ($result_pagos->num_rows > 0) {
                    $row_pagos = $result_pagos->fetch_assoc();
                    $total_pagos = $row_pagos["total_pagos"];
                }

                $monto_restante = $total_piezas - $total_pagos;

                echo "<table class='table table-bordered'>
                        <tr><th>Descripción</th><th>Valor</th></tr>
                        <tr><td>Total Tratamiento</td><td>" . number_format($total_piezas, 2, '.', ',') . "</td></tr>
                        <tr><td>Total Pagos</td><td>" . number_format($total_pagos, 2, '.', ',') . "</td></tr>
                        <tr><td>Monto Restante</td><td>" . number_format($monto_restante, 2, '.', ',') . "</td></tr>
                    </table>";
            }
        } else {
            echo "<p>No hay registros en la tabla de piezas</p>";
        }

        $conn->close();
        ?>
        <br>
        <button class="btn btn-secondary" onclick="generarPDF()">Generar PDF de Pagos</button>
        <button class="btn btn-info" onclick="window.print()">Imprimir</button>
    </div>
    <script src="https://kit.fontawesome.com/a076d05399.js"></script>
</body>
</html>
