<?php


ini_set("default_charset", "UTF-8");
session_start();

$ruta_base = '../Assets/img/usuario/';
// Obtén el nombre de la foto desde la sesión
$foto = isset($_SESSION['session_foto']) ? $_SESSION['session_foto'] : 'imagen_default.jpg'; // Usa una imagen por defecto si no hay foto en la sesión
// Construye la ruta completa
$ruta_completa = $ruta_base . $foto;
$nombre = $_SESSION['session_nomb_clinica'];
$direccionu = $_SESSION['session_direccion'];
$correo = $_SESSION['session_correo'];
$telefono = $_SESSION['session_numcontacto'];

// Incluye la biblioteca FPDF
require('fpdf/fpdf.php');

// Configuración de la base de datos
$servername = "localhost";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Comprobar conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtén el ID del paciente de los parámetros GET
$id = $_GET['id'] ?? 0;

// Verifica que el ID no esté vacío y sea un número entero
if (!filter_var($id, FILTER_VALIDATE_INT)) {
    die("ID inválido.");
}

// Consultar información del paciente
$sqlPaciente = "SELECT Nombres, ApPaterno, ApMaterno, DNI, Direccion, Celular, EstadoCivil 
                 FROM TConexion 
                 WHERE id = ?";
$stmt = $conn->prepare($sqlPaciente);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPaciente = $stmt->get_result();

if ($resultPaciente->num_rows === 0) {
    die("No se encontró el paciente con el ID proporcionado.");
}

$paciente = $resultPaciente->fetch_assoc();

// Consultar piezas dentales
$sqlPiezas = "SELECT pieza_id, estado, tipo, detalles, precio 
              FROM piezas 
              WHERE id_paciente = ?";
$stmt = $conn->prepare($sqlPiezas);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPiezas = $stmt->get_result();
$piezas = [];
$totalPrecio = 0;

while ($row = $resultPiezas->fetch_assoc()) {
    $piezas[] = $row;
    $totalPrecio += $row['precio'];
}

// Cierra la conexión a la base de datos
$conn->close();

// Crear el documento PDF
$pdf = new FPDF();
header("Content-Type: text/html; charset=iso-8859-1 ");
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 16);
$pdf->Image($ruta_completa, 10, 10, 25, 'C');



$pdf->Ln(10); // Ajusta el valor si es necesario para dejar espacio debajo de la imagen

// Configura la fuente para el texto
$pdf->SetFont('Arial', 'B', 18);

// Añade el texto debajo de la imagen
$pdf->Cell(0, 10, 'Clinica ' . htmlspecialchars($nombre), 0, 1, 'C');
$pdf->Ln(3);

$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, 'Direccion: ' . htmlspecialchars($direccionu), 0, 1, 'C');
$pdf->Cell(0, 4, 'Telefono: ' . htmlspecialchars($telefono), 0, 1, 'C');
$pdf->Cell(0, 4, 'Correo: ' . htmlspecialchars($correo), 0, 1, 'C');
$pdf->Ln(4);

// Título
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'Reporte de Piezas Dentales', 0, 1, 'C');

// Información del paciente
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, utf8_decode('Información del Paciente'), 0, 1, 'L');

$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 5, 'Nombre: ' . htmlspecialchars($paciente['Nombres']), 0, 1, 'L');
$pdf->Cell(0, 5, 'DNI: ' . htmlspecialchars($paciente['DNI']), 0, 1, 'L');
$pdf->Cell(0, 5, utf8_decode('Dirección: ') . htmlspecialchars($paciente['ApMaterno']), 0, 1, 'L');
$pdf->Cell(0, 5, 'Celular: ' . htmlspecialchars($paciente['Celular']), 0, 1, 'L');
//$pdf->Cell(0, 10, 'Estado Civil: ' . htmlspecialchars($paciente['EstadoCivil']), 0, 1, 'L');

// Piezas dentales
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, 'Pieza', 1);
$pdf->Cell(60, 10, 'Estado', 1);
$pdf->Cell(60, 10, 'Detalles', 1);
$pdf->Cell(30, 10, 'Precio', 1);
$pdf->Ln();

$pdf->SetFont('Arial', '', 10);

foreach ($piezas as $pieza) {
    $pdf->Cell(40, 10, htmlspecialchars($pieza['pieza_id']), 1);
    $pdf->Cell(60, 10, htmlspecialchars($pieza['estado']), 1);
    $pdf->Cell(60, 10, htmlspecialchars($pieza['detalles']), 1);
    $pdf->Cell(30, 10, 'S/.' . number_format($pieza['precio'], 2), 1);
    $pdf->Ln();
}

// Total
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(160, 10, 'Total', 1);
$pdf->Cell(30, 10, 'S/.' . number_format($totalPrecio, 2), 1);
// Output PDF
$pdf->Output();


?>
