<?php
session_start();


// Incluye la biblioteca FPDF
require('fpdf/fpdf.php');

// Configuración de la base de datos
$servername = "localhost";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Comprobar conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtén el ID del paciente de los parámetros GET
$id = $_GET['id'] ?? 0;

// Verifica que el ID no esté vacío y sea un número entero
if (!filter_var($id, FILTER_VALIDATE_INT)) {
    die("ID inválido.");
}

// Consultar información del paciente
$sqlPaciente = "SELECT Nombres, ApPaterno, ApMaterno, DNI, Direccion, Celular, EstadoCivil 
                 FROM TConexion 
                 WHERE id = ?";
$stmt = $conn->prepare($sqlPaciente);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPaciente = $stmt->get_result();

if ($resultPaciente->num_rows === 0) {
    die("No se encontró el paciente con el ID proporcionado.");
}

$paciente = $resultPaciente->fetch_assoc();

// Consultar piezas dentales
$sqlPiezas = "SELECT pieza_id, estado, tipo, precio 
              FROM piezas 
              WHERE id_paciente = ?";
$stmt = $conn->prepare($sqlPiezas);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPiezas = $stmt->get_result();
$piezas = [];
$totalPrecio = 0;

while ($row = $resultPiezas->fetch_assoc()) {
    $piezas[] = $row;
    $totalPrecio += $row['precio'];
}

// Cierra la conexión a la base de datos
$conn->close();

// Crear el documento PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 16);

// Título
$pdf->Cell(0, 10, 'Reporte de Piezas Dentales', 0, 1, 'C');

// Información del paciente
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Información del Paciente', 0, 1, 'L');

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(0, 10, 'Nombre: ' . htmlspecialchars($paciente['Nombres'] . ' ' . $paciente['ApPaterno'] . ' ' . $paciente['ApMaterno']), 0, 1, 'L');
$pdf->Cell(0, 10, 'DNI: ' . htmlspecialchars($paciente['DNI']), 0, 1, 'L');
$pdf->Cell(0, 10, 'Dirección: ' . htmlspecialchars($paciente['Direccion']), 0, 1, 'L');
$pdf->Cell(0, 10, 'Celular: ' . htmlspecialchars($paciente['Celular']), 0, 1, 'L');
$pdf->Cell(0, 10, 'Estado Civil: ' . htmlspecialchars($paciente['EstadoCivil']), 0, 1, 'L');

// Piezas dentales
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, 'Pieza ID', 1);
$pdf->Cell(60, 10, 'Estado', 1);
$pdf->Cell(60, 10, 'Tipo', 1);
$pdf->Cell(30, 10, 'Precio', 1);
$pdf->Ln();

$pdf->SetFont('Arial', '', 12);

foreach ($piezas as $pieza) {
    $pdf->Cell(40, 10, htmlspecialchars($pieza['pieza_id']), 1);
    $pdf->Cell(60, 10, htmlspecialchars($pieza['estado']), 1);
    $pdf->Cell(60, 10, htmlspecialchars($pieza['tipo']), 1);
    $pdf->Cell(30, 10, '$' . number_format($pieza['precio'], 2), 1);
    $pdf->Ln();
}

// Total
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(160, 10, 'Total', 1);
$pdf->Cell(30, 10, '$' . number_format($totalPrecio, 2), 1);

// Output PDF
$pdf->Output();
?>
