<?php

require('fpdf/fpdf.php');

// Conexión a la base de datos
$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtener ID del paciente y tipo de odontograma
$id = $_GET['id'] ?? 0;
$tipo = $_GET['tipo'] ?? 'adulto';

// Obtener datos de la sesión
session_start(); // Inicia la sesión si no está iniciada
$ruta_base = '../Assets/img/usuario/';
$foto = isset($_SESSION['session_foto']) ? $_SESSION['session_foto'] : 'imagen_default.jpg'; // Imagen por defecto si no se encuentra
$ruta_completa = $ruta_base . $foto;
$nombre = $_SESSION['session_nomb_clinica'];
$direccionu = $_SESSION['session_direccion'];
$correo = $_SESSION['session_correo'];
$telefono = $_SESSION['session_numcontacto'];

// Consultar información del paciente
$sqlPaciente = "SELECT * 
                 FROM TConexion 
                 WHERE id = ?";
$stmt = $conn->prepare($sqlPaciente);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPaciente = $stmt->get_result();

if ($resultPaciente->num_rows === 0) {
    die("No se encontró el paciente con el ID proporcionado.");
}


$paciente = $resultPaciente->fetch_assoc();



// Datos del paciente
$nombrePaciente = $paciente['Nombres'];
$direccionPaciente = $paciente['Direccion'];
$telefonoPaciente = $paciente['Celular'];
$correoPaciente = $paciente['DNI']; // Asumimos que DNI es el correo aquí, ajusta si es necesario

// Crear instancia del objeto FPDF
class PDF extends FPDF
{
    private $ruta_completa;
    private $nombre;
    private $direccionu;
    private $telefono;
    private $correo;

    function __construct($ruta_completa, $nombre, $direccionu, $telefono, $correo)
    {
        parent::__construct();
        $this->ruta_completa = $ruta_completa;
        $this->nombre = $nombre;
        $this->direccionu = $direccionu;
        $this->telefono = $telefono;
        $this->correo = $correo;
    }

    // Cabecera
    function Header()
    {
        // Imagen
        $this->Image($this->ruta_completa, 10, 10, 25, 25);

        // Texto de la clínica
        $this->SetFont('Arial', 'B', 18);
        $this->Cell(0, 8, 'Clinica ' . htmlspecialchars($this->nombre), 0, 1, 'C');

        // Información adicional de la clínica
        $this->SetFont('Arial', '', 8);
        $this->Cell(0, 4, 'Direccion: ' . htmlspecialchars($this->direccionu), 0, 1, 'C');
        $this->Cell(0, 4, 'Telefono: ' . htmlspecialchars($this->telefono), 0, 1, 'C');
        $this->Cell(0, 4, 'Correo: ' . htmlspecialchars($this->correo), 0, 1, 'C');
        $this->Ln(4); // Espacio debajo de la información adicional
    }




    // Pie de página
    function Footer()
    {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Pagina ' . $this->PageNo(), 0, 0, 'C');
    }
}

$pdf = new PDF($ruta_completa, $nombre, $direccionu, $telefono, $correo);
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Agregar datos del paciente
$pdf->Cell(0, 10, 'Datos del Paciente:', 0, 1, 'L');
//$pdf->Ln(5);
$pdf->SetFont('Arial', '', 12);

$pdf->Cell(0, 5, 'Nombre: ' . htmlspecialchars($paciente['Nombres']), 0, 1, 'L');
$pdf->Cell(0, 5, 'DNI: ' . htmlspecialchars($paciente['DNI']), 0, 1, 'L');
$pdf->Cell(0, 5, utf8_decode('Dirección: ') . htmlspecialchars($paciente['ApMaterno']), 0, 1, 'L');
$pdf->Cell(0, 5, 'Celular: ' . htmlspecialchars($paciente['Celular']), 0, 1, 'L');
$pdf->Ln(5); // Espacio antes del odontograma



// Configuración del odontograma
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'Odontograma', 0, 1, 'C');

$piezas_nino_linea1 = [55, 54, 53, 52, 51, 61, 62, 63, 64, 65];
$piezas_nino_linea2 = [85, 84, 83, 82, 81, 71, 72, 73, 74, 75];
$piezas_nino = array_merge($piezas_nino_linea1, $piezas_nino_linea2);

$piezas_adulto_linea1 = [18, 17, 16, 15, 14, 13, 12, 11, 21, 22, 23, 24, 25, 26, 27, 28];
$piezas_adulto_linea2 = [48, 47, 46, 45, 44, 43, 42, 41, 31, 32, 33, 34, 35, 36, 37, 38];
$piezas_adulto = array_merge($piezas_adulto_linea1, $piezas_adulto_linea2);

$isAdulto = $tipo === 'adulto';
$piezas = $isAdulto ? $piezas_adulto : $piezas_nino;
$linea1 = $isAdulto ? $piezas_adulto_linea1 : $piezas_nino_linea1;
$linea2 = $isAdulto ? $piezas_adulto_linea2 : $piezas_nino_linea2;

// Estados posibles y colores
$estados = [
    'sano' => ['label' => 'Sano', 'color' => [0, 255, 0]],         // Verde
    'cariado' => ['label' => 'Cariado', 'color' => [255, 0, 0]],   // Rojo
    'ausente' => ['label' => 'Ausente', 'color' => [128, 128, 128]], // Gris
    'restauracion' => ['label' => 'Restauracion', 'color' => [0, 0, 255]], // Azul
    'extraccion' => ['label' => 'Extraccion', 'color' => [255, 165, 0]] // Naranja
];

// Consultar estado de las piezas dentales
$sql = "SELECT pieza_id, estado FROM piezas WHERE tipo='$tipo' AND id_paciente=$id";
$result = $conn->query($sql);

$estadosPiezas = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $pieza_id = $row['pieza_id'];
        $estadosPiezas[$pieza_id] = $row['estado'];
    }
}

// Configuración de tamaño y espaciado
$piezaWidthOriginal = 60;
$piezaHeightOriginal = 90;
$reductionFactor = 0.1; // Reducción del 10%
$piezaWidth = $piezaWidthOriginal * $reductionFactor;
$piezaHeight = $piezaHeightOriginal * $reductionFactor;
$gap = 5; // Espaciado entre imágenes, reducido para acercar las imágenes

// Calcular el número de columnas y filas en el diseño
$columns = $isAdulto ? 16 : 10; // Cambia según el tipo de odontograma
$rows = ceil(count($piezas) / $columns);
$xStart = (210 - ($columns * $piezaWidth + ($columns - 1) * $gap)) / 2; // Centrado horizontal
$yStart = 80; // Posición inicial Y ajustada para dejar espacio para la información del paciente
$xOffset = $piezaWidth + $gap; // Offset para columnas
$yOffset = $piezaHeight + $gap; // Offset para filas

// Configurar fuente para los números de pieza
$pdf->SetFont('Arial', 'B', 8); // Fuente Arial en negrita, tamaño 8

// Añadir las imágenes y números de piezas con colores de estado
foreach ($piezas as $index => $pieza) {
    $column = $index % $columns;
    $row = intdiv($index, $columns);

    $x = $xStart + $column * $xOffset;
    $y = $yStart + $row * $yOffset;

    // Genera la ruta de la imagen
    $imagen = "dientes/diente_" . $pieza . ".png";

    // Asegúrate de que la imagen exista
    if (file_exists($imagen)) {
        // Añadir imagen
        $pdf->Image($imagen, $x, $y + 5, $piezaWidth, $piezaHeight);
    } else {
        // Añadir un espacio en caso de que la imagen no exista
        $pdf->SetXY($x, $y + 10);
        $pdf->Cell($piezaWidth, $piezaHeight, '', 0, 0, 'C');
    }

    // Obtener el estado y color
    $estado = $estadosPiezas[$pieza] ?? 'sano'; // Usa 'sano' si el estado no está en la base de datos
    $color = $estados[$estado]['color'];
    // Configurar color del texto
    $pdf->SetTextColor($color[0], $color[1], $color[2]);

    // Colocar el número de pieza
    $pdf->SetXY($x, $y + ($isAdulto ? $piezaHeight - 10 : 0));
    $pdf->Cell($piezaWidth, 10, $pieza, 0, 0, 'C');
}

// Configurar la leyenda
$pdf->SetFont('Arial', '', 8); // Fuente Arial, tamaño 8
$legendX = 10;
$legendY = $y + $piezaHeight + 10; // Posicionar debajo de la tabla de piezas
$legendWidth = 4; // Ancho del cuadro de color
$legendHeight = 4; // Alto del cuadro de color
$legendSpacing = 16; // Espaciado entre las entradas de la leyenda

foreach ($estados as $estado => $info) {
    $pdf->SetXY($legendX, $legendY);
    $pdf->SetFillColor($info['color'][0], $info['color'][1], $info['color'][2]);
    $pdf->Cell($legendWidth, $legendHeight, '', 1, 0, 'C', true); // Cuadro de color
    $pdf->SetXY($legendX + $legendWidth, $legendY); // Ajustar la posición del texto
    $pdf->Cell(0, $legendHeight, $info['label'], 0, 0); // Texto de la leyenda
    $legendX += $legendWidth + $legendSpacing; // Incrementar la posición X para la siguiente entrada
}

// Consultar detalles de las piezas dentales
$sqlDetalles = "SELECT 
                    piezas.pieza_id,
                    piezas.estado,
                    piezas.tipo,
                    piezas.id_paciente,
                    piezas.precio,
                    piezas.detalles,
                    estado_cita.estado_diente AS estado_cita,
                    estado_oclusales.estado_diente AS estado_oclusal,
                    estado_vestibulares.estado_diente AS estado_vestibular,
                    estado_mesiales.estado_diente AS estado_mesial,
                    estado_distales.estado_diente AS estado_distal,
                    estado_paladinos.estado_diente AS estado_palatino
                FROM piezas
                LEFT JOIN estado_diente estado_cita ON piezas.id_estado_cita = estado_cita.id_estado_diente
                LEFT JOIN estado_diente estado_oclusales ON piezas.Oclusal = estado_oclusales.id_estado_diente
                LEFT JOIN estado_diente estado_vestibulares ON piezas.Vestibular = estado_vestibulares.id_estado_diente
                LEFT JOIN estado_diente estado_mesiales ON piezas.Mesial = estado_mesiales.id_estado_diente
                LEFT JOIN estado_diente estado_distales ON piezas.Distal = estado_distales.id_estado_diente
                LEFT JOIN estado_diente estado_paladinos ON piezas.Palatino = estado_paladinos.id_estado_diente
                WHERE piezas.id_paciente = $id
                GROUP BY piezas.pieza_id, piezas.estado, piezas.tipo, piezas.id_paciente, piezas.detalles, estado_cita.estado_diente, 
                         estado_oclusales.estado_diente, estado_vestibulares.estado_diente, estado_mesiales.estado_diente, 
                         estado_distales.estado_diente, estado_paladinos.estado_diente";

$stmtDetalles = $conn->prepare($sqlDetalles);
$stmtDetalles->bind_param("i", $id);
$stmtDetalles->execute();
$resultDetalles = $stmtDetalles->get_result();

$total_precio = 0;

// Configuración de la tabla
$pdf->SetFont('Arial', 'B', 10); // Fuente Arial en negrita, tamaño 8
$pdf->SetXY(10, $legendY + 20); // Posicionar la tabla debajo de la leyenda
$pdf->SetTextColor(0, 0, 0); // Color negro
$pdf->Cell(10, 10, 'Pieza', 1);
$pdf->Cell(25, 10, 'Estado', 1);
//$pdf->Cell(15, 10, 'Precio', 1);
$pdf->Cell(30, 10, 'Detalles', 1);
$pdf->Cell(25, 10, 'Oclusal', 1);
$pdf->Cell(25, 10, 'Vestibular', 1);
$pdf->Cell(25, 10, 'Mesial', 1);
$pdf->Cell(25, 10, 'Distal', 1);
$pdf->Cell(25, 10, 'Palatino', 1);
//$pdf->Cell(20, 10, 'Precio Total', 1);
$pdf->Ln();
// Añadir filas a la tabla
$pdf->SetFont('Arial', '', 10); // Fuente Arial, tamaño 6 para ajustar el texto

if ($resultDetalles->num_rows > 0) {
    while($row = $resultDetalles->fetch_assoc()) {
        $total_precio += $row["precio"];
        $pdf->Cell(10, 10, $row["pieza_id"], 1);
        $pdf->Cell(25, 10, $row["estado"], 1);
  //      $pdf->Cell(15, 10, number_format($row["precio"], 2, '.', ','), 1);
        $pdf->Cell(30, 10, $row["detalles"], 1);
        $pdf->Cell(25, 10, $row["estado_oclusal"], 1);
        $pdf->Cell(25, 10, $row["estado_vestibular"], 1);
        $pdf->Cell(25, 10, $row["estado_mesial"], 1);
        $pdf->Cell(25, 10, $row["estado_distal"], 1);
        $pdf->Cell(25, 10, $row["estado_palatino"], 1);
    //    $pdf->Cell(20, 10, number_format($total_precio, 2, '.', ','), 1);
        $pdf->Ln();
    }
}
//inicio piezas
$pdf->Ln(10);
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'Antecedentes Medicos', 0, 1, 'C');


// Agregar tabla con los datos del paciente uno debajo del otro solo si tienen datos
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);

// Títulos de la tabla
$height = 10;
$pdf->Cell(60, $height, 'Campo', 1);
$pdf->Cell(0, $height, 'Valor', 1);
$pdf->Ln();

// Datos del paciente, solo si existen
$pdf->SetFont('Arial', '', 10);
if (!empty($paciente['adelanto_encargado'])) {
    $pdf->Cell(60, $height, 'Tipo de Sangre', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['adelanto_encargado']), 1);
    $pdf->Ln();
}

if (!empty($paciente['entrega_material'])) {
    $pdf->Cell(60, $height, 'Temperatura', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['entrega_material']), 1);
    $pdf->Ln();
}
if (!empty($paciente['Genero'])) {
    $pdf->Cell(60, $height, 'Peso', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['Genero']), 1);
    $pdf->Ln();
}
if (!empty($paciente['marca'])) {
    $pdf->Cell(60, $height, 'Pulso', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['marca']), 1);
    $pdf->Ln();
}
if (!empty($paciente['modelo'])) {
    $pdf->Cell(60, $height, 'Enfermedades', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['modelo']), 1);
    $pdf->Ln();
}
if (!empty($paciente['placa'])) {
    $pdf->Cell(60, $height, 'Toma Medicamentos', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['placa']), 1);
    $pdf->Ln();
}
if (!empty($paciente['color'])) {
    $pdf->Cell(60, $height, 'Alergias', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['color']), 1);
    $pdf->Ln();
}
if (!empty($paciente['anio'])) {
    $pdf->Cell(60, $height, 'Cardiopatia', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['anio']), 1);
    $pdf->Ln();
}

if (!empty($paciente['fechaIniBrevet'])) {
    $pdf->Cell(60, $height, 'Alteracion Precion Arterial', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniBrevet']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaFinBrevet'])) {
    $pdf->Cell(60, $height, 'Embarazo', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinBrevet']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaIniReviTec'])) {
    $pdf->Cell(60, $height, 'Deabetes', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniReviTec']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaFinReviTec'])) {
    $pdf->Cell(60, $height, 'Hepatitis', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinReviTec']), 1);
    $pdf->Ln();
}

if (!empty($paciente['fechaIniSoat'])) {
    $pdf->Cell(60, $height, 'Fiebre Reumatica', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniSoat']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaFinSoat'])) {
    $pdf->Cell(60, $height, 'Enfermedaes Renales', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinSoat']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaIniSetare'])) {
    $pdf->Cell(60, $height, 'VIH', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniSetare']), 1);
    $pdf->Ln();
}

if (!empty($paciente['fechaFinSetare'])) {
    $pdf->Cell(60, $height, 'Fuma o Consume Licor', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinSetare']), 1);
    $pdf->Ln();
}
if (!empty($paciente['dia_plaqueo'])) {
    $pdf->Cell(60, $height, 'Observaciones', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['dia_plaqueo']), 1);
    $pdf->Ln();
}

//fin de piezas
// Obtener imágenes y descripciones para el PDF
$imagenesDatos = [];
$sqlImagenes = "SELECT ruta, descripcion FROM rx WHERE id_paciente = ?";
$stmtImagenes = $conn->prepare($sqlImagenes);
$stmtImagenes->bind_param('s', $id);
$stmtImagenes->execute();
$resultadoImagenes = $stmtImagenes->get_result();

while ($row = $resultadoImagenes->fetch_assoc()) {
    $imagenesDatos[] = $row;
}

$stmtImagenes->close();
$pdf->Ln(10);
// Configuración de imágenes
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'RX del Paciente', 0, 1, 'L');
$pdf->Ln(4);

$pdf->SetFont('Arial', '', 10);
$maxWidth = 180; // Ancho máximo para las imágenes (menos que el ancho de la página para márgenes)
$maxHeight = 180; // Altura máxima para las imágenes

foreach ($imagenesDatos as $data) {
    // Descripción con ajuste automático de línea
    $pdf->MultiCell(0, 10, 'Descripcion: ' . htmlspecialchars($data['descripcion']), 0, 'L');
    $pdf->Ln(5);

    $imagePath = __DIR__ . '/uploads/' . htmlspecialchars($id) . '/' . basename($data['ruta']);
    if (file_exists($imagePath)) {
        // Redimensionar imagen al 20% de su tamaño original
        list($originalWidth, $originalHeight) = getimagesize($imagePath);
        $scaledWidth = $originalWidth * 0.1;
        $scaledHeight = $originalHeight * 0.1;

        // Ajustar si la imagen es demasiado grande
        if ($scaledWidth > $maxWidth) {
            $scaledHeight = $scaledHeight * ($maxWidth / $scaledWidth);
            $scaledWidth = $maxWidth;
        }
        if ($scaledHeight > $maxHeight) {
            $scaledWidth = $scaledWidth * ($maxHeight / $scaledHeight);
            $scaledHeight = $maxHeight;
        }

        $pdf->Image($imagePath, 10, $pdf->GetY(), $scaledWidth, $scaledHeight);
        $pdf->Ln($scaledHeight + 10); // Espacio debajo de la imagen
    }
}


// Cerrar conexión
$conn->close();

// Salida del PDF
$pdf->Output();
?>

