<?php
require('fpdf/fpdf.php');


// Conexión a la base de datos
$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtener ID del paciente y tipo de odontograma
$id = $_GET['id'] ?? 0;
$tipo = $_GET['tipo'] ?? 'adulto';

// Obtener datos de la sesión
session_start(); // Inicia la sesión si no está iniciada
$ruta_base = '../Assets/img/usuario/';
$foto = isset($_SESSION['session_foto']) ? $_SESSION['session_foto'] : 'imagen_default.jpg'; // Imagen por defecto si no se encuentra
$ruta_completa = $ruta_base . $foto;
$nombre = $_SESSION['session_nomb_clinica'];
$direccionu = $_SESSION['session_direccion'];
$correo = $_SESSION['session_correo'];
$telefono = $_SESSION['session_numcontacto'];

// Consultar información del paciente
$sqlPaciente = "SELECT Nombres, ApPaterno, ApMaterno, DNI, Direccion, Celular, EstadoCivil 
                 FROM TConexion 
                 WHERE id = ?";
$stmt = $conn->prepare($sqlPaciente);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPaciente = $stmt->get_result();

if ($resultPaciente->num_rows === 0) {
    die("No se encontró el paciente con el ID proporcionado.");
}

$paciente = $resultPaciente->fetch_assoc();

// Datos del paciente
$nombrePaciente = $paciente['Nombres'];
$direccionPaciente = $paciente['Direccion'];
$telefonoPaciente = $paciente['Celular'];
$correoPaciente = $paciente['DNI']; // Asumimos que DNI es el correo aquí, ajusta si es necesario

// Crear instancia del objeto FPDF
$pdf = new FPDF();
$pdf->AddPage();

// Agregar la imagen de la clínica
$pdf->Image($ruta_completa, 10, 10, 25, 'C');

// Ajustar espacio debajo de la imagen
$pdf->Ln(10);

// Configurar la fuente para el texto
$pdf->SetFont('Arial', 'B', 18);

// Añadir el texto debajo de la imagen
$pdf->Cell(0, 10, 'Clinica ' . htmlspecialchars($nombre), 0, 1, 'C');
$pdf->Ln(3);

// Información adicional de la clínica
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, 'Direccion: ' . htmlspecialchars($direccionu), 0, 1, 'C');
$pdf->Cell(0, 4, 'Telefono: ' . htmlspecialchars($telefono), 0, 1, 'C');
$pdf->Cell(0, 4, 'Correo: ' . htmlspecialchars($correo), 0, 1, 'C');
$pdf->Ln(4);

// Configuración del paciente
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 5, 'Datos del Paciente', 0, 1, 'L');
$pdf->Ln(4);

$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 5, 'Nombre: ' . htmlspecialchars($nombrePaciente), 0, 1, 'L');
$pdf->Cell(0, 5, 'Direccion: ' . htmlspecialchars($direccionPaciente), 0, 1, 'L');
$pdf->Cell(0, 5, 'Telefono: ' . htmlspecialchars($telefonoPaciente), 0, 1, 'L');
$pdf->Cell(0, 5, 'Correo: ' . htmlspecialchars($correoPaciente), 0, 1, 'L');
$pdf->Ln(10);

// Configuración del odontograma
$piezas_nino_linea1 = [55, 54, 53, 52, 51, 61, 62, 63, 64, 65];
$piezas_nino_linea2 = [85, 84, 83, 82, 81, 71, 72, 73, 74, 75];
$piezas_nino = array_merge($piezas_nino_linea1, $piezas_nino_linea2);

$piezas_adulto_linea1 = [18, 17, 16, 15, 14, 13, 12, 11, 21, 22, 23, 24, 25, 26, 27, 28];
$piezas_adulto_linea2 = [48, 47, 46, 45, 44, 43, 42, 41, 31, 32, 33, 34, 35, 36, 37, 38];
$piezas_adulto = array_merge($piezas_adulto_linea1, $piezas_adulto_linea2);

$isAdulto = $tipo === 'adulto';
$piezas = $isAdulto ? $piezas_adulto : $piezas_nino;
$linea1 = $isAdulto ? $piezas_adulto_linea1 : $piezas_nino_linea1;
$linea2 = $isAdulto ? $piezas_adulto_linea2 : $piezas_nino_linea2;

// Estados posibles y colores
$estados = [
    'sano' => ['label' => 'Sano', 'color' => [0, 255, 0]],         // Verde
    'cariado' => ['label' => 'Cariado', 'color' => [255, 0, 0]],   // Rojo
    'ausente' => ['label' => 'Ausente', 'color' => [128, 128, 128]], // Gris
    'restauracion' => ['label' => 'Restauracion', 'color' => [0, 0, 255]], // Azul
    'extraccion' => ['label' => 'Extraccion', 'color' => [255, 165, 0]] // Naranja
];

// Consultar estado de las piezas dentales
$sql = "SELECT pieza_id, estado FROM piezas WHERE tipo='$tipo' AND id_paciente=$id";
$result = $conn->query($sql);

$estadosPiezas = [];

if ($result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $pieza_id = $row['pieza_id'];
        $estadosPiezas[$pieza_id] = $row['estado'];
    }
}

// Configuración de tamaño y espaciado
$piezaWidthOriginal = 60;
$piezaHeightOriginal = 90;
$reductionFactor = 0.1; // Reducción del 10%
$piezaWidth = $piezaWidthOriginal * $reductionFactor;
$piezaHeight = $piezaHeightOriginal * $reductionFactor;
$gap = 5; // Espaciado entre imágenes, reducido para acercar las imágenes

// Calcular el número de columnas y filas en el diseño
$columns = $isAdulto ? 16 : 10; // Cambia según el tipo de odontograma
$rows = ceil(count($piezas) / $columns);
$xStart = (210 - ($columns * $piezaWidth + ($columns - 1) * $gap)) / 2; // Centrado horizontal
$yStart = 80; // Posición inicial Y ajustada para dejar espacio para la información del paciente
$xOffset = $piezaWidth + $gap; // Offset para columnas
$yOffset = $piezaHeight + $gap; // Offset para filas

// Configurar fuente para los números de pieza
$pdf->SetFont('Arial', 'B', 8); // Fuente Arial en negrita, tamaño 8

// Añadir las imágenes y números de piezas con colores de estado
foreach ($piezas as $index => $pieza) {
    $column = $index % $columns;
    $row = intdiv($index, $columns);

    $x = $xStart + $column * $xOffset;
    $y = $yStart + $row * $yOffset;

    // Genera la ruta de la imagen
    $imagen = "dientes/diente_" . $pieza . ".png";

    // Asegúrate de que la imagen exista
    if (file_exists($imagen)) {
        // Añadir imagen
        $pdf->Image($imagen, $x, $y + 5, $piezaWidth, $piezaHeight);
    } else {
        // Añadir un espacio en caso de que la imagen no exista
        $pdf->SetXY($x, $y + 10);
        $pdf->Cell($piezaWidth, $piezaHeight, '', 0, 0, 'C');
    }

    // Obtener el estado y color
    $estado = $estadosPiezas[$pieza] ?? 'sano'; // Usa 'sano' si el estado no está en la base de datos
    $color = $estados[$estado]['color'];

    // Configurar color del texto
    $pdf->SetTextColor($color[0], $color[1], $color[2]);

    // Colocar el número de pieza
    $pdf->SetXY($x, $y + ($isAdulto ? $piezaHeight - 10 : 0));
    $pdf->Cell($piezaWidth, 10, $pieza, 0, 0, 'C');
}

// Configurar la leyenda
$pdf->SetFont('Arial', '', 8); // Fuente Arial, tamaño 8
$legendX = 10;
$legendY = $y + $piezaHeight + 10; // Posicionar debajo de la tabla de piezas
$legendWidth = 4; // Ancho del cuadro de color
$legendHeight = 4; // Alto del cuadro de color
$legendSpacing = 16; // Espaciado entre las entradas de la leyenda

foreach ($estados as $estado => $info) {
    $pdf->SetXY($legendX, $legendY);
    $pdf->SetFillColor($info['color'][0], $info['color'][1], $info['color'][2]);
    $pdf->Cell($legendWidth, $legendHeight, '', 1, 0, 'C', true); // Cuadro de color
    $pdf->SetXY($legendX + $legendWidth, $legendY); // Ajustar la posición del texto
    $pdf->Cell(0, $legendHeight, $info['label'], 0, 0); // Texto de la leyenda
    $legendX += $legendWidth + $legendSpacing; // Incrementar la posición X para la siguiente entrada
}

// Consultar detalles de las piezas dentales
$sqlDetalles = "SELECT 
                    piezas.pieza_id,
                    piezas.estado,
                    piezas.tipo,
                    piezas.id_paciente,
                    piezas.precio,
                    piezas.detalles,
                    estado_cita.estado_diente AS estado_cita,
                    estado_oclusales.estado_diente AS estado_oclusal,
                    estado_vestibulares.estado_diente AS estado_vestibular,
                    estado_mesiales.estado_diente AS estado_mesial,
                    estado_distales.estado_diente AS estado_distal,
                    estado_paladinos.estado_diente AS estado_palatino,
                    SUM(piezas.precio) OVER() AS total_precio
                FROM piezas
                LEFT JOIN estado_diente estado_cita ON piezas.id_estado_cita = estado_cita.id_estado_diente
                LEFT JOIN estado_diente estado_oclusales ON piezas.Oclusal = estado_oclusales.id_estado_diente
                LEFT JOIN estado_diente estado_vestibulares ON piezas.Vestibular = estado_vestibulares.id_estado_diente
                LEFT JOIN estado_diente estado_mesiales ON piezas.Mesial = estado_mesiales.id_estado_diente
                LEFT JOIN estado_diente estado_distales ON piezas.Distal = estado_distales.id_estado_diente
                LEFT JOIN estado_diente estado_paladinos ON piezas.Palatino = estado_paladinos.id_estado_diente
                WHERE piezas.id_paciente = $id
                GROUP BY piezas.pieza_id, piezas.estado, piezas.tipo, piezas.id_paciente, piezas.detalles, estado_cita.estado_diente, 
                         estado_oclusales.estado_diente, estado_vestibulares.estado_diente, estado_mesiales.estado_diente, 
                         estado_distales.estado_diente, estado_paladinos.estado_diente";

$stmtDetalles = $conn->prepare($sqlDetalles);
$stmtDetalles->bind_param("i", $id);
$stmtDetalles->execute();
$resultDetalles = $stmtDetalles->get_result();

$total_precio = 0;

// Configuración de la tabla
$pdf->SetFont('Arial', 'B', 8); // Fuente Arial en negrita, tamaño 8
$pdf->SetXY(10, $legendY + 20); // Posicionar la tabla debajo de la leyenda
$pdf->SetTextColor(0, 0, 0); // Color negro
$pdf->Cell(10, 10, 'Pieza', 1);
$pdf->Cell(15, 10, 'Estado', 1);
$pdf->Cell(15, 10, 'Precio', 1);
$pdf->Cell(30, 10, 'Detalles', 1);
//$pdf->Cell(15, 10, 'Estado Inicial', 1);
$pdf->Cell(15, 10, 'Oclusal', 1);
$pdf->Cell(15, 10, 'Vestibular', 1);
$pdf->Cell(15, 10, 'Mesial', 1);
$pdf->Cell(15, 10, 'Distal', 1);
$pdf->Cell(15, 10, 'Palatino', 1);
$pdf->Cell(20, 10, 'Precio Total', 1);
$pdf->Ln();

// Añadir filas a la tabla
$pdf->SetFont('Arial', '', 6); // Fuente Arial, tamaño 6 para ajustar el texto

if ($resultDetalles->num_rows > 0) {
    while($row = $resultDetalles->fetch_assoc()) {
        $total_precio += $row["precio"];
        $pdf->Cell(10, 10, $row["pieza_id"], 1);
        $pdf->Cell(15, 10, $row["estado"], 1);
        $pdf->Cell(15, 10, number_format($row["precio"], 2, '.', ','), 1);
        $pdf->Cell(30, 10, $row["detalles"], 1);
  //      $pdf->Cell(15, 10, $row["estado_cita"], 1);
        $pdf->Cell(15, 10, $row["estado_oclusal"], 1);
        $pdf->Cell(15, 10, $row["estado_vestibular"], 1);
        $pdf->Cell(15, 10, $row["estado_mesial"], 1);
        $pdf->Cell(15, 10, $row["estado_distal"], 1);
        $pdf->Cell(15, 10, $row["estado_palatino"], 1);
        $pdf->Cell(20, 10, number_format($total_precio, 2, '.', ','), 1);
        $pdf->Ln();
    }
}

// Cerrar conexión
$conn->close();

// Salvar el PDF
$pdf->Output('I', 'rep_piezas.pdf');
?>
