<?php

ini_set("default_charset", "UTF-8");
session_start();

$ruta_base = '../Assets/img/usuario/';
// Obtén el nombre de la foto desde la sesión
$foto = isset($_SESSION['session_foto']) ? $_SESSION['session_foto'] : 'imagen_default.jpg'; // Usa una imagen por defecto si no hay foto en la sesión
// Construye la ruta completa
$ruta_completa = $ruta_base . $foto;
$nombre = $_SESSION['session_nomb_clinica'];
$direccionu = $_SESSION['session_direccion'];
$correo = $_SESSION['session_correo'];
$telefono = $_SESSION['session_numcontacto'];

// Incluye la biblioteca FPDF
require('fpdf/fpdf.php');

// Configuración de la base de datos
$servername = "exdb.telconetperu.pe";
$username = "user_dental";
$password = "@lba$102979";
$dbname = "dental";

// Crear conexión
$conn = new mysqli($servername, $username, $password, $dbname);

// Comprobar conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtén el ID del paciente de los parámetros GET
$id = $_GET['id'] ?? 0;

// Verifica que el ID no esté vacío y sea un número entero
if (!filter_var($id, FILTER_VALIDATE_INT)) {
    die("ID inválido.");
}

// Consultar información del paciente
$sqlPaciente = "SELECT * 
                 FROM TConexion 
                 WHERE id = ?";
$stmt = $conn->prepare($sqlPaciente);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPaciente = $stmt->get_result();

if ($resultPaciente->num_rows === 0) {
    die("No se encontró el paciente con el ID proporcionado.");
}

$paciente = $resultPaciente->fetch_assoc();

// Consultar piezas dentales
$sqlPiezas = "SELECT pieza_id, estado, tipo, detalles, precio 
              FROM piezas 
              WHERE id_paciente = ?";
$stmt = $conn->prepare($sqlPiezas);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPiezas = $stmt->get_result();
$piezas = [];
$totalPrecio = 0;

while ($row = $resultPiezas->fetch_assoc()) {
    $piezas[] = $row;
    $totalPrecio += $row['precio'];
}

// Cierra la conexión a la base de datos
$conn->close();

// Crear el documento PDF
$pdf = new FPDF();
header("Content-Type: text/html; charset=iso-8859-1 ");
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 16);
$pdf->Image($ruta_completa, 10, 10, 25, 'C');

$pdf->Ln(10); // Ajusta el valor si es necesario para dejar espacio debajo de la imagen

// Configura la fuente para el texto
$pdf->SetFont('Arial', 'B', 18);
// Añade el texto debajo de la imagen
$pdf->Cell(0, 10, 'Clinica ' . htmlspecialchars($nombre), 0, 1, 'C');
$pdf->Ln(3);

$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, 'Direccion: ' . htmlspecialchars($direccionu), 0, 1, 'C');
$pdf->Cell(0, 4, 'Telefono: ' . htmlspecialchars($telefono), 0, 1, 'C');
$pdf->Cell(0, 4, 'Correo: ' . htmlspecialchars($correo), 0, 1, 'C');
$pdf->Ln(4);

// Título
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 10, 'Antecedentes Medicos', 0, 1, 'C');

// Información del paciente
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, utf8_decode('Información del Paciente'), 0, 1, 'L');

$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 5, 'Nombre: ' . htmlspecialchars($paciente['Nombres']), 0, 1, 'L');
$pdf->Cell(0, 5, 'DNI: ' . htmlspecialchars($paciente['DNI']), 0, 1, 'L');
$pdf->Cell(0, 5, utf8_decode('Dirección: ') . htmlspecialchars($paciente['ApMaterno']), 0, 1, 'L');
$pdf->Cell(0, 5, 'Celular: ' . htmlspecialchars($paciente['Celular']), 0, 1, 'L');

// Agregar tabla con los datos del paciente uno debajo del otro solo si tienen datos
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);

// Títulos de la tabla
$height = 10;
$pdf->Cell(60, $height, 'Campo', 1);
$pdf->Cell(0, $height, 'Valor', 1);
$pdf->Ln();

// Datos del paciente, solo si existen
$pdf->SetFont('Arial', '', 10);
if (!empty($paciente['adelanto_encargado'])) {
    $pdf->Cell(60, $height, 'Tipo de Sangre', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['adelanto_encargado']), 1);
    $pdf->Ln();
}

if (!empty($paciente['entrega_material'])) {
    $pdf->Cell(60, $height, 'Temperatura', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['entrega_material']), 1);
    $pdf->Ln();
}
if (!empty($paciente['Genero'])) {
    $pdf->Cell(60, $height, 'Peso', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['Genero']), 1);
    $pdf->Ln();
}
if (!empty($paciente['marca'])) {
    $pdf->Cell(60, $height, 'Pulso', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['marca']), 1);
    $pdf->Ln();
}
if (!empty($paciente['modelo'])) {
    $pdf->Cell(60, $height, 'Enfermedades', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['modelo']), 1);
    $pdf->Ln();
}
if (!empty($paciente['placa'])) {
    $pdf->Cell(60, $height, 'Toma Medicamentos', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['placa']), 1);
    $pdf->Ln();
}
if (!empty($paciente['color'])) {
    $pdf->Cell(60, $height, 'Alergias', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['color']), 1);
    $pdf->Ln();
}
if (!empty($paciente['anio'])) {
    $pdf->Cell(60, $height, 'Cardiopatia', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['anio']), 1);
    $pdf->Ln();
}

if (!empty($paciente['fechaIniBrevet'])) {
    $pdf->Cell(60, $height, 'Alteracion Precion Arterial', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniBrevet']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaFinBrevet'])) {
    $pdf->Cell(60, $height, 'Embarazo', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinBrevet']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaIniReviTec'])) {
    $pdf->Cell(60, $height, 'Deabetes', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniReviTec']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaFinReviTec'])) {
    $pdf->Cell(60, $height, 'Hepatitis', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinReviTec']), 1);
    $pdf->Ln();
}

if (!empty($paciente['fechaIniSoat'])) {
    $pdf->Cell(60, $height, 'Fiebre Reumatica', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniSoat']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaFinSoat'])) {
    $pdf->Cell(60, $height, 'Enfermedaes Renales', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinSoat']), 1);
    $pdf->Ln();
}
if (!empty($paciente['fechaIniSetare'])) {
    $pdf->Cell(60, $height, 'VIH', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaIniSetare']), 1);
    $pdf->Ln();
}

if (!empty($paciente['fechaFinSetare'])) {
    $pdf->Cell(60, $height, 'Fuma o Consume Licor', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['fechaFinSetare']), 1);
    $pdf->Ln();
}
if (!empty($paciente['dia_plaqueo'])) {
    $pdf->Cell(60, $height, 'Observaciones', 1);
    $pdf->Cell(0, $height, htmlspecialchars($paciente['dia_plaqueo']), 1);
    $pdf->Ln();
}
/*
// Piezas dentales
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(40, 10, 'Pieza', 1);
$pdf->Cell(60, 10, 'Estado', 1);
$pdf->Cell(60, 10, 'Detalles', 1);
$pdf->Cell(30, 10, 'Precio', 1);
$pdf->Ln();

$pdf->SetFont('Arial', '', 10);

foreach ($piezas as $pieza) {
    $pdf->Cell(40, 10, htmlspecialchars($pieza['pieza_id']), 1);
    $pdf->Cell(60, 10, htmlspecialchars($pieza['estado']), 1);
    $pdf->Cell(60, 10, htmlspecialchars($pieza['detalles']), 1);
    $pdf->Cell(30, 10, 'S/.' . number_format($pieza['precio'], 2), 1);
    $pdf->Ln();
}

// Total
$pdf->Ln();
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(160, 10, 'Total', 1);
$pdf->Cell(30, 10, 'S/.' . number_format($totalPrecio, 2), 1);
*/
// Output PDF
$pdf->Output();

?>
