<?php
require('fpdf/fpdf.php');

// Datos de conexión a la base de datos
$host = 'exdb.telconetperu.pe'; // o la IP de tu servidor de base de datos
$db = 'dental';
$user = 'user_dental';
$pass = '@lba$102979';

// Crear conexión
$conn = new mysqli($host, $user, $pass, $db);

// Verificar la conexión
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Obtener ID del paciente y tipo de odontograma
$id = $_GET['id'] ?? 0;
$tipo = $_GET['tipo'] ?? 'adulto';

// Obtener datos de la sesión
session_start(); // Inicia la sesión si no está iniciada
$ruta_base = '../Assets/img/usuario/';
$foto = isset($_SESSION['session_foto']) ? $_SESSION['session_foto'] : 'imagen_default.jpg'; // Imagen por defecto si no se encuentra
$ruta_completa = $ruta_base . $foto;
$nombre = $_SESSION['session_nomb_clinica'];
$direccionu = $_SESSION['session_direccion'];
$correo = $_SESSION['session_correo'];
$telefono = $_SESSION['session_numcontacto'];

// Consultar información del paciente
$sqlPaciente = "SELECT Nombres, ApPaterno, ApMaterno, DNI, Direccion, Celular, EstadoCivil 
                 FROM TConexion 
                 WHERE id = ?";
$stmt = $conn->prepare($sqlPaciente);
$stmt->bind_param("i", $id);
$stmt->execute();
$resultPaciente = $stmt->get_result();

if ($resultPaciente->num_rows === 0) {
    die("No se encontró el paciente con el ID proporcionado.");
}

$paciente = $resultPaciente->fetch_assoc();

// Datos del paciente
$nombrePaciente = $paciente['Nombres'];
$direccionPaciente = $paciente['Direccion'];
$telefonoPaciente = $paciente['Celular'];
$correoPaciente = $paciente['DNI']; // Asumimos que DNI es el correo aquí, ajusta si es necesario

// Obtener imágenes y descripciones para el PDF
$imagenesDatos = [];
$sqlImagenes = "SELECT ruta, descripcion FROM rx WHERE id_paciente = ?";
$stmtImagenes = $conn->prepare($sqlImagenes);
$stmtImagenes->bind_param('s', $id);
$stmtImagenes->execute();
$resultadoImagenes = $stmtImagenes->get_result();

while ($row = $resultadoImagenes->fetch_assoc()) {
    $imagenesDatos[] = $row;
}

$stmtImagenes->close();

// Crear instancia del objeto FPDF
$pdf = new FPDF();
$pdf->AddPage();

// Agregar la imagen de la clínica
$pdf->Image($ruta_completa, 10, 10, 25, 'C');

// Ajustar espacio debajo de la imagen
$pdf->Ln(5);

// Configurar la fuente para el texto
$pdf->SetFont('Arial', 'B', 21);

// Añadir el texto debajo de la imagen
$pdf->Cell(0, 10, 'Clinica ' . htmlspecialchars($nombre), 0, 1, 'C');
$pdf->Ln(2);

// Información adicional de la clínica
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(0, 4, 'Direccion: ' . htmlspecialchars($direccionu), 0, 1, 'C');
$pdf->Cell(0, 4, 'Telefono: ' . htmlspecialchars($telefono), 0, 1, 'C');
$pdf->Cell(0, 4, 'Correo: ' . htmlspecialchars($correo), 0, 1, 'C');
$pdf->Ln(4);

// Configuración del paciente
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 5, 'Datos del Paciente', 0, 1, 'L');
$pdf->Ln(4);

$pdf->SetFont('Arial', '', 10);
$pdf->Cell(0, 5, 'Nombre: ' . htmlspecialchars($nombrePaciente), 0, 1, 'L');
$pdf->Cell(0, 5, 'Direccion: ' . htmlspecialchars($direccionPaciente), 0, 1, 'L');
$pdf->Cell(0, 5, 'Telefono: ' . htmlspecialchars($telefonoPaciente), 0, 1, 'L');
$pdf->Cell(0, 5, 'Correo: ' . htmlspecialchars($correoPaciente), 0, 1, 'L');
$pdf->Ln(7);

// Configuración de imágenes
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'RX del Paciente', 0, 1, 'L');
$pdf->Ln(4);

$pdf->SetFont('Arial', '', 10);
$maxWidth = 180; // Ancho máximo para las imágenes (menos que el ancho de la página para márgenes)
$maxHeight = 180; // Altura máxima para las imágenes

foreach ($imagenesDatos as $data) {
    // Descripción con ajuste automático de línea
    $pdf->MultiCell(0, 10, 'Descripcion: ' . htmlspecialchars($data['descripcion']), 0, 'L');
    $pdf->Ln(5);

    $imagePath = __DIR__ . '/uploads/' . htmlspecialchars($id) . '/' . basename($data['ruta']);
    if (file_exists($imagePath)) {
        // Redimensionar imagen al 20% de su tamaño original
        list($originalWidth, $originalHeight) = getimagesize($imagePath);
        $scaledWidth = $originalWidth * 0.1;
        $scaledHeight = $originalHeight * 0.1;

        // Ajustar si la imagen es demasiado grande
        if ($scaledWidth > $maxWidth) {
            $scaledHeight = $scaledHeight * ($maxWidth / $scaledWidth);
            $scaledWidth = $maxWidth;
        }
        if ($scaledHeight > $maxHeight) {
            $scaledWidth = $scaledWidth * ($maxHeight / $scaledHeight);
            $scaledHeight = $maxHeight;
        }

        $pdf->Image($imagePath, 10, $pdf->GetY(), $scaledWidth, $scaledHeight);
        $pdf->Ln($scaledHeight + 10); // Espacio debajo de la imagen
    }
}

// Salida del PDF al navegador
header('Content-Type: application/pdf');
header('Content-Disposition: attachment; filename="reporte.pdf"');
$pdf->Output();

exit;
