<?php
//require('vendor/autoload.php'); // Solo si estás usando Composer para FPDF
require('fpdf/fpdf.php'); // Si has descargado FPDF manualmente

// Conectar a la base de datos
$dsn = 'mysql:host=exdb.telconetperu.pe;dbname=dental;charset=utf8';
$username = 'user_dental';
$password = '@lba$102979';

try {
    $pdo = new PDO($dsn, $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die('No se pudo conectar a la base de datos: ' . $e->getMessage());
}

// Definir el ID del paciente
$id_paciente = 1; // Cambia esto al ID del paciente que desees

// Definir la consulta
$sql = "
SELECT 
    piezas.pieza_id,
    piezas.estado,
    piezas.tipo,
    piezas.id_paciente,
    piezas.precio,
    piezas.detalles,
    estado_cita.estado_diente AS estado_cita,
    estado_oclusales.estado_diente AS estado_oclusal,
    estado_vestibulares.estado_diente AS estado_vestibular,
    estado_mesiales.estado_diente AS estado_mesial,
    estado_distales.estado_diente AS estado_distal,
    estado_paladinos.estado_diente AS estado_palatino,
    SUM(piezas.precio) OVER() AS total_precio
FROM piezas
LEFT JOIN estado_diente estado_cita ON piezas.id_estado_cita = estado_cita.id_estado_diente
LEFT JOIN estado_diente estado_oclusales ON piezas.Oclusal = estado_oclusales.id_estado_diente
LEFT JOIN estado_diente estado_vestibulares ON piezas.Vestibular = estado_vestibulares.id_estado_diente
LEFT JOIN estado_diente estado_mesiales ON piezas.Mesial = estado_mesiales.id_estado_diente
LEFT JOIN estado_diente estado_distales ON piezas.Distal = estado_distales.id_estado_diente
LEFT JOIN estado_diente estado_paladinos ON piezas.Palatino = estado_paladinos.id_estado_diente
WHERE piezas.id_paciente = ?
GROUP BY piezas.pieza_id, piezas.estado, piezas.tipo, piezas.id_paciente, piezas.detalles, estado_cita.estado_diente, 
         estado_oclusales.estado_diente, estado_vestibulares.estado_diente, estado_mesiales.estado_diente, 
         estado_distales.estado_diente, estado_paladinos.estado_diente
";

$stmt = $pdo->prepare($sql);
$stmt->execute([$id_paciente]);

$datos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Crear un nuevo documento PDF
$pdf = new FPDF();
$pdf->AddPage();
$pdf->SetFont('Arial', 'B', 12);

// Títulos de las columnas
$columnas = array_keys($datos[0]);
foreach ($columnas as $columna) {
    $pdf->Cell(40, 10, ucfirst($columna), 1);
}
$pdf->Ln();

// Datos
$pdf->SetFont('Arial', '', 12);
foreach ($datos as $fila) {
    foreach ($columnas as $columna) {
        $pdf->Cell(40, 10, $fila[$columna], 1);
    }
    $pdf->Ln();
}

// Total Precio
$total_precio = $datos[0]['total_precio'] ?? 0;
$pdf->Ln();
$pdf->Cell(40, 10, "Total Precio:", 1);
$pdf->Cell(40, 10, $total_precio, 1);

// Guardar el PDF en un archivo
$pdf->Output('F', 'listado_piezas_dentales.pdf');
?>
