<?php
require("menu.php");
$_SESSION["session_idusario"];
$id_UC = $_SESSION["session_idusario"];
$con = new mysqli('exdb.telconetperu.pe','user_dental','@lba$102979','dental'); // Conectar a la BD
if ($con->connect_error) {
    die("Conexión fallida: " . $con->connect_error);
}

// Consulta SQL ajustada
$sql = "SELECT
            DATE(fecha_pago) AS fecha,
            TIME(fecha_pago) AS hora,
            SUM(pagos) AS monto_acumulado
        FROM
            pagos
        WHERE
	    id_usuario = ?
	GROUP BY
            DATE(fecha_pago), TIME(fecha_pago)
        ORDER BY
            fecha, hora";

$stmt = $con->prepare($sql);

// Enlazar el parámetro
$stmt->bind_param("i", $id_UC);

// Ejecutar la consulta
$stmt->execute();

// Obtener el resultado
$query = $stmt->get_result();


//$query = $con->query($sql);

$fechas = array();
$horas = array();
$monto_acumulado = array();

while ($r = $query->fetch_object()) {
    $fechas[] = $r->fecha;
    $horas[] = $r->hora;
    $monto_acumulado[] = $r->monto_acumulado;
}

$con->close();

// Convertir los datos a JSON para ser utilizados en la gráfica
$data = array(
    'fechas' => $fechas,
    'horas' => $horas,
    'monto_acumulado' => $monto_acumulado
);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Reporte de Pagos por Hora y Fecha</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>
<body>
    <canvas id="myChart" width="800" height="400"></canvas>
    <script>
        var ctx = document.getElementById('myChart').getContext('2d');
        var fechas = <?php echo json_encode($data['fechas']); ?>;
        var horas = <?php echo json_encode($data['horas']); ?>;
        var monto_acumulado = <?php echo json_encode($data['monto_acumulado']); ?>;

        // Convertir las horas a un formato numérico para el eje y
        function horaToNumero(hora) {
            var partes = hora.split(':');
            return parseInt(partes[0]) + parseInt(partes[1]) / 60; // Convertir a número decimal
        }

        // Preparar los datos para el gráfico
        var etiquetasX = fechas;
        var datosY = horas.map(horaToNumero);

        // Datos del gráfico
        var data = {
            labels: etiquetasX,
            datasets: [{
                label: 'Monto por Pago',
                data: datosY.map((hora, index) => ({ x: etiquetasX[index], y: hora, monto: monto_acumulado[index] })),
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                fill: false,
                lineTension: 0.1,
                pointRadius: 5, // Radio de los puntos
                pointBackgroundColor: 'rgba(75, 192, 192, 0.7)',
                pointBorderColor: '#fff'
            }]
        };

        var myChart = new Chart(ctx, {
            type: 'line',
            data: data,
            options: {
                scales: {
                    x: {
                        title: {
                            display: true,
                            text: 'Fecha'
                        }
                    },
                    y: {
                        title: {
                            display: true,
                            text: 'Hora del Día'
                        },
                        ticks: {
                            callback: function(value, index, values) {
                                var horas = Math.floor(value);
                                var minutos = Math.round((value - horas) * 60);
                                return horas + ':' + (minutos < 10 ? '0' : '') + minutos; // Formato HH:MM
                            }
                        }
                    }
                },
                plugins: {
                    legend: {
                        display: true
                    },
                    tooltip: {
                        callbacks: {
                            label: function(tooltipItem) {
                                var fecha = tooltipItem.raw.x;
                                var hora = tooltipItem.raw.y;
                                var monto = tooltipItem.raw.monto;
                                var horas = Math.floor(hora);
                                var minutos = Math.round((hora - horas) * 60);
                                return 'Fecha: ' + fecha + ' | Hora: ' + horas + ':' + (minutos < 10 ? '0' : '') + minutos + ' | Monto: ' + monto;
                            }
                        }
                    }
                }
            }
        });
    </script>
</body>
</html>
